/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.telemetry.log;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.apache.seatunnel.engine.common.config.server.TelemetryLogsConfig;
import org.apache.seatunnel.engine.common.utils.LogUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskLogManagerService {
    private static final Logger log = LoggerFactory.getLogger(TaskLogManagerService.class);
    private String path;

    public TaskLogManagerService(TelemetryLogsConfig log) {
    }

    public void initClean() {
        try {
            this.path = LogUtil.getLogPath();
        }
        catch (Exception e) {
            log.debug("The corresponding log file path is not properly configured, please check the log configuration file.", (Throwable)e);
        }
    }

    public void clean(long jobId) {
        String[] logFiles;
        log.info("Cleaning logs for jobId: {} , path : {}", (Object)jobId, (Object)this.path);
        if (this.path == null) {
            return;
        }
        for (String logFile : logFiles = this.getLogFiles(jobId, this.path)) {
            try {
                Files.delete(Paths.get(this.path + "/" + logFile, new String[0]));
            }
            catch (IOException e) {
                log.warn("Failed to delete log file: {}", (Object)logFile, (Object)e);
            }
        }
    }

    private String[] getLogFiles(long jobId, String path) {
        File logDir = new File(path);
        if (!logDir.exists() || !logDir.isDirectory()) {
            log.warn("Skipping deletion: Log directory '{}' either does not exist or is not a valid directory. Please verify the path and ensure the logs are being written correctly.", (Object)path);
            return new String[0];
        }
        return logDir.list((dir, name) -> name.contains(String.valueOf(jobId)));
    }
}

