/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.rest;

import com.hazelcast.instance.impl.Node;
import com.hazelcast.spi.impl.NodeEngineImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.seatunnel.api.common.JobContext;
import org.apache.seatunnel.engine.common.config.JobConfig;
import org.apache.seatunnel.engine.core.dag.actions.Action;
import org.apache.seatunnel.engine.core.dag.logical.LogicalDag;
import org.apache.seatunnel.engine.core.job.AbstractJobEnvironment;
import org.apache.seatunnel.engine.core.job.JobImmutableInformation;
import org.apache.seatunnel.engine.core.parse.MultipleTableJobConfigParser;
import org.apache.seatunnel.engine.server.SeaTunnelServer;
import org.apache.seatunnel.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.seatunnel.shade.com.typesafe.config.Config;

public class RestJobExecutionEnvironment
extends AbstractJobEnvironment {
    private final Config seaTunnelJobConfig;
    private final NodeEngineImpl nodeEngine;
    private final Long jobId;
    private final SeaTunnelServer seaTunnelServer;

    public RestJobExecutionEnvironment(SeaTunnelServer seaTunnelServer, JobConfig jobConfig, Config seaTunnelJobConfig, Node node, boolean isStartWithSavePoint, Long jobId) {
        super(jobConfig, isStartWithSavePoint);
        this.seaTunnelServer = seaTunnelServer;
        this.seaTunnelJobConfig = seaTunnelJobConfig;
        this.nodeEngine = node.getNodeEngine();
        this.jobConfig.setJobContext(new JobContext(Long.valueOf(Objects.nonNull(jobId) ? jobId.longValue() : this.nodeEngine.getHazelcastInstance().getFlakeIdGenerator("SeaTunnelIdGenerator").newId())));
        this.jobId = Long.valueOf(this.jobConfig.getJobContext().getJobId());
    }

    public Long getJobId() {
        return this.jobId;
    }

    @VisibleForTesting
    public LogicalDag getLogicalDag() {
        ImmutablePair immutablePair = this.getJobConfigParser().parse(this.seaTunnelServer.getClassLoaderService());
        this.actions.addAll((Collection)immutablePair.getLeft());
        this.jarUrls.addAll(this.commonPluginJars);
        this.jarUrls.addAll((Collection)immutablePair.getRight());
        this.actions.forEach(action -> RestJobExecutionEnvironment.addCommonPluginJarsToAction((Action)action, new HashSet(this.commonPluginJars), Collections.emptySet()));
        return this.getLogicalDagGenerator().generate();
    }

    protected MultipleTableJobConfigParser getJobConfigParser() {
        List<Object> pipelineCheckpoints = Collections.emptyList();
        if (this.isStartWithSavePoint) {
            LOGGER.info("Start with savepoint, get checkpoint state from server");
            pipelineCheckpoints = this.seaTunnelServer.getCheckpointService().getLatestCheckpointData(this.jobConfig.getJobContext().getJobId());
        }
        return new MultipleTableJobConfigParser(this.seaTunnelJobConfig, this.idGenerator, this.jobConfig, this.commonPluginJars, this.isStartWithSavePoint, pipelineCheckpoints);
    }

    public JobImmutableInformation build() {
        return new JobImmutableInformation(Long.parseLong(this.jobConfig.getJobContext().getJobId()), this.jobConfig.getName(), this.isStartWithSavePoint, this.nodeEngine.getSerializationService().toData((Object)this.getLogicalDag()), this.jobConfig, new ArrayList(this.jarUrls), new ArrayList(this.connectorJarIdentifiers));
    }
}

