/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.resourcemanager.worker;

import com.hazelcast.cluster.Address;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.apache.seatunnel.engine.server.resourcemanager.resource.ResourceProfile;
import org.apache.seatunnel.engine.server.resourcemanager.resource.SlotProfile;
import org.apache.seatunnel.engine.server.serializable.ResourceDataSerializerHook;

public class WorkerProfile
implements IdentifiedDataSerializable {
    private Address address;
    private ResourceProfile profile;
    private ResourceProfile unassignedResource;
    private boolean dynamicSlot;
    private SlotProfile[] assignedSlots;
    private SlotProfile[] unassignedSlots;
    private Map<String, String> attributes;

    public WorkerProfile(Address address) {
        this.address = address;
        this.unassignedResource = new ResourceProfile();
    }

    public WorkerProfile() {
        this.address = new Address();
    }

    public int getFactoryId() {
        return ResourceDataSerializerHook.FACTORY_ID;
    }

    public int getClassId() {
        return 5;
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject((Object)this.address);
        out.writeObject((Object)this.profile);
        out.writeObject((Object)this.unassignedResource);
        out.writeInt(this.assignedSlots.length);
        for (SlotProfile assignedSlot : this.assignedSlots) {
            out.writeObject((Object)assignedSlot);
        }
        out.writeInt(this.unassignedSlots.length);
        for (SlotProfile unassignedSlot : this.unassignedSlots) {
            out.writeObject((Object)unassignedSlot);
        }
        out.writeBoolean(this.dynamicSlot);
        out.writeObject(this.attributes);
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.address = (Address)in.readObject();
        this.profile = (ResourceProfile)in.readObject();
        this.unassignedResource = (ResourceProfile)in.readObject();
        int assignedSlotsLength = in.readInt();
        this.assignedSlots = new SlotProfile[assignedSlotsLength];
        for (int i = 0; i < this.assignedSlots.length; ++i) {
            this.assignedSlots[i] = (SlotProfile)in.readObject();
        }
        int unassignedSlotsLength = in.readInt();
        this.unassignedSlots = new SlotProfile[unassignedSlotsLength];
        for (int i = 0; i < this.unassignedSlots.length; ++i) {
            this.unassignedSlots[i] = (SlotProfile)in.readObject();
        }
        this.dynamicSlot = in.readBoolean();
        this.attributes = (Map)in.readObject();
    }

    public Address getAddress() {
        return this.address;
    }

    public ResourceProfile getProfile() {
        return this.profile;
    }

    public ResourceProfile getUnassignedResource() {
        return this.unassignedResource;
    }

    public boolean isDynamicSlot() {
        return this.dynamicSlot;
    }

    public SlotProfile[] getAssignedSlots() {
        return this.assignedSlots;
    }

    public SlotProfile[] getUnassignedSlots() {
        return this.unassignedSlots;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public void setProfile(ResourceProfile profile) {
        this.profile = profile;
    }

    public void setUnassignedResource(ResourceProfile unassignedResource) {
        this.unassignedResource = unassignedResource;
    }

    public void setDynamicSlot(boolean dynamicSlot) {
        this.dynamicSlot = dynamicSlot;
    }

    public void setAssignedSlots(SlotProfile[] assignedSlots) {
        this.assignedSlots = assignedSlots;
    }

    public void setUnassignedSlots(SlotProfile[] unassignedSlots) {
        this.unassignedSlots = unassignedSlots;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WorkerProfile)) {
            return false;
        }
        WorkerProfile other = (WorkerProfile)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isDynamicSlot() != other.isDynamicSlot()) {
            return false;
        }
        Address this$address = this.getAddress();
        Address other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
            return false;
        }
        ResourceProfile this$profile = this.getProfile();
        ResourceProfile other$profile = other.getProfile();
        if (this$profile == null ? other$profile != null : !this$profile.equals(other$profile)) {
            return false;
        }
        ResourceProfile this$unassignedResource = this.getUnassignedResource();
        ResourceProfile other$unassignedResource = other.getUnassignedResource();
        if (this$unassignedResource == null ? other$unassignedResource != null : !this$unassignedResource.equals(other$unassignedResource)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getAssignedSlots(), other.getAssignedSlots())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getUnassignedSlots(), other.getUnassignedSlots())) {
            return false;
        }
        Map<String, String> this$attributes = this.getAttributes();
        Map<String, String> other$attributes = other.getAttributes();
        return !(this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WorkerProfile;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDynamicSlot() ? 79 : 97);
        Address $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        ResourceProfile $profile = this.getProfile();
        result = result * 59 + ($profile == null ? 43 : $profile.hashCode());
        ResourceProfile $unassignedResource = this.getUnassignedResource();
        result = result * 59 + ($unassignedResource == null ? 43 : $unassignedResource.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getAssignedSlots());
        result = result * 59 + Arrays.deepHashCode(this.getUnassignedSlots());
        Map<String, String> $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        return result;
    }

    public String toString() {
        return "WorkerProfile(address=" + this.getAddress() + ", profile=" + this.getProfile() + ", unassignedResource=" + this.getUnassignedResource() + ", dynamicSlot=" + this.isDynamicSlot() + ", assignedSlots=" + Arrays.deepToString(this.getAssignedSlots()) + ", unassignedSlots=" + Arrays.deepToString(this.getUnassignedSlots()) + ", attributes=" + this.getAttributes() + ")";
    }

    public WorkerProfile(Address address, ResourceProfile profile, ResourceProfile unassignedResource, boolean dynamicSlot, SlotProfile[] assignedSlots, SlotProfile[] unassignedSlots, Map<String, String> attributes) {
        this.address = address;
        this.profile = profile;
        this.unassignedResource = unassignedResource;
        this.dynamicSlot = dynamicSlot;
        this.assignedSlots = assignedSlots;
        this.unassignedSlots = unassignedSlots;
        this.attributes = attributes;
    }
}

