/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.common.utils;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class DateUtils {
    private static final Map<Formatter, DateTimeFormatter> FORMATTER_MAP = new HashMap<Formatter, DateTimeFormatter>();
    public static final Pattern[] PATTERN_ARRAY;
    public static final Map<Pattern, DateTimeFormatter> DATE_FORMATTER_MAP;

    public static DateTimeFormatter matchDateFormatter(String dateTime) {
        for (int j = 0; j < PATTERN_ARRAY.length; ++j) {
            if (!PATTERN_ARRAY[j].matcher(dateTime).matches()) continue;
            return DATE_FORMATTER_MAP.get(PATTERN_ARRAY[j]);
        }
        return null;
    }

    public static LocalDate parse(String date) {
        DateTimeFormatter dateTimeFormatter = DateUtils.matchDateFormatter(date);
        return DateUtils.parse(date, dateTimeFormatter);
    }

    public static LocalDate parse(String date, DateTimeFormatter dateTimeFormatter) {
        return LocalDate.parse(date, dateTimeFormatter);
    }

    public static LocalDate parse(String date, Formatter formatter) {
        return LocalDate.parse(date, FORMATTER_MAP.get((Object)formatter));
    }

    public static String toString(LocalDate date, Formatter formatter) {
        return date.format(FORMATTER_MAP.get((Object)formatter));
    }

    static {
        FORMATTER_MAP.put(Formatter.YYYY_MM_DD, DateTimeFormatter.ofPattern(Formatter.YYYY_MM_DD.value));
        FORMATTER_MAP.put(Formatter.YYYY_MM_DD_SPOT, DateTimeFormatter.ofPattern(Formatter.YYYY_MM_DD_SPOT.value));
        FORMATTER_MAP.put(Formatter.YYYY_MM_DD_SLASH, DateTimeFormatter.ofPattern(Formatter.YYYY_MM_DD_SLASH.value));
        PATTERN_ARRAY = new Pattern[]{Pattern.compile("\\d{4}-\\d{2}-\\d{2}"), Pattern.compile("\\d{4}\u5e74\\d{2}\u6708\\d{2}\u65e5"), Pattern.compile("\\d{4}/\\d{2}/\\d{2}"), Pattern.compile("\\d{4}\\.\\d{2}\\.\\d{2}"), Pattern.compile("\\d{8}"), Pattern.compile("\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}(\\.\\d{1,9})?Z"), Pattern.compile("\\d{2}:\\d{2}:\\d{2}\\+\\d{2}:\\d{2}"), Pattern.compile("\\d{2}:\\d{2}:\\d{2}(\\.\\d{1,9})?"), Pattern.compile("\\d{4}/\\d{1,2}/\\d{1,2}")};
        DATE_FORMATTER_MAP = new HashMap<Pattern, DateTimeFormatter>();
        DATE_FORMATTER_MAP.put(PATTERN_ARRAY[0], new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).toFormatter());
        DATE_FORMATTER_MAP.put(PATTERN_ARRAY[1], new DateTimeFormatterBuilder().parseCaseInsensitive().append(new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral("\u5e74").appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral("\u6708").appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral("\u65e5").toFormatter()).toFormatter());
        DATE_FORMATTER_MAP.put(PATTERN_ARRAY[2], new DateTimeFormatterBuilder().parseCaseInsensitive().append(new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral('/').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('/').appendValue(ChronoField.DAY_OF_MONTH, 2).toFormatter()).toFormatter());
        DATE_FORMATTER_MAP.put(PATTERN_ARRAY[3], new DateTimeFormatterBuilder().parseCaseInsensitive().append(new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral('.').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('.').appendValue(ChronoField.DAY_OF_MONTH, 2).toFormatter()).toFormatter());
        DATE_FORMATTER_MAP.put(PATTERN_ARRAY[4], new DateTimeFormatterBuilder().parseCaseInsensitive().append(new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendValue(ChronoField.MONTH_OF_YEAR, 2).appendValue(ChronoField.DAY_OF_MONTH, 2).toFormatter()).toFormatter());
        DATE_FORMATTER_MAP.put(PATTERN_ARRAY[5], new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral('T').append(new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).appendLiteral('Z').toFormatter()).toFormatter());
        DATE_FORMATTER_MAP.put(PATTERN_ARRAY[6], DateTimeFormatter.ISO_OFFSET_TIME);
        DATE_FORMATTER_MAP.put(PATTERN_ARRAY[7], DateTimeFormatter.ISO_LOCAL_TIME);
        DATE_FORMATTER_MAP.put(PATTERN_ARRAY[8], new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ofPattern("yyyy/M/d")).toFormatter());
    }

    public static enum Formatter {
        YYYY_MM_DD("yyyy-MM-dd"),
        YYYY_M_D("yyyy/M/d"),
        YYYY_MM_DD_SPOT("yyyy.MM.dd"),
        YYYY_MM_DD_SLASH("yyyy/MM/dd");

        private final String value;

        private Formatter(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static Formatter parse(String format) {
            Formatter[] formatters;
            for (Formatter formatter : formatters = Formatter.values()) {
                if (!formatter.getValue().equals(format)) continue;
                return formatter;
            }
            String errorMsg = String.format("Illegal format [%s]", format);
            throw new IllegalArgumentException(errorMsg);
        }
    }
}

