/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.table.type;

public enum CommonOptions {
    JSON("Json", false),
    METADATA("Metadata", false),
    PARTITION("Partition", true),
    DATABASE("Database", true),
    TABLE("Table", true),
    ROW_KIND("RowKind", true),
    EVENT_TIME("EventTime", true),
    DELAY("Delay", true);

    private final String name;
    private final boolean supportMetadataTrans;

    private CommonOptions(String name, boolean supportMetadataTrans) {
        this.name = name;
        this.supportMetadataTrans = supportMetadataTrans;
    }

    public static CommonOptions fromName(String name) {
        for (CommonOptions option : CommonOptions.values()) {
            if (!option.getName().equals(name)) continue;
            return option;
        }
        throw new IllegalArgumentException("Unknown option name: " + name);
    }

    public String getName() {
        return this.name;
    }

    public boolean isSupportMetadataTrans() {
        return this.supportMetadataTrans;
    }
}

