/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.table.catalog.schema;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.ConstraintKey;
import org.apache.seatunnel.api.table.catalog.PhysicalColumn;
import org.apache.seatunnel.api.table.catalog.PrimaryKey;
import org.apache.seatunnel.api.table.catalog.SeaTunnelDataTypeConvertorUtil;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.api.table.catalog.schema.TableSchemaOptions;
import org.apache.seatunnel.api.table.catalog.schema.TableSchemaParser;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.common.utils.JsonUtils;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.JsonNode;

public class ReadonlyConfigParser
implements TableSchemaParser<ReadonlyConfig> {
    private final TableSchemaParser.ColumnParser<ReadonlyConfig> columnParser = new ColumnParser();
    private final TableSchemaParser.FieldParser<ReadonlyConfig> fieldParser = new FieldParser();
    private final TableSchemaParser.ConstraintKeyParser<ReadonlyConfig> constraintKeyParser = new ConstraintKeyParser();
    private final TableSchemaParser.PrimaryKeyParser<ReadonlyConfig> primaryKeyParser = new PrimaryKeyParser();

    @Override
    public TableSchema parse(ReadonlyConfig readonlyConfig) {
        ReadonlyConfig schemaConfig = readonlyConfig.getOptional(TableSchemaOptions.SCHEMA).map(ReadonlyConfig::fromMap).orElseThrow(() -> new IllegalArgumentException("Schema config can't be null"));
        if (readonlyConfig.getOptional(TableSchemaOptions.FieldOptions.FIELDS).isPresent() && schemaConfig.getOptional(TableSchemaOptions.ColumnOptions.COLUMNS).isPresent()) {
            throw new IllegalArgumentException("Schema config can't contains both [fields] and [columns], please correct your config first");
        }
        TableSchema.Builder tableSchemaBuilder = TableSchema.builder();
        if (readonlyConfig.getOptional(TableSchemaOptions.FieldOptions.FIELDS).isPresent()) {
            tableSchemaBuilder.columns(this.fieldParser.parse(readonlyConfig));
        }
        if (schemaConfig.getOptional(TableSchemaOptions.ColumnOptions.COLUMNS).isPresent()) {
            tableSchemaBuilder.columns(this.columnParser.parse(schemaConfig));
        }
        if (schemaConfig.getOptional(TableSchemaOptions.PrimaryKeyOptions.PRIMARY_KEY).isPresent()) {
            tableSchemaBuilder.primaryKey(this.primaryKeyParser.parse(schemaConfig));
        }
        if (schemaConfig.getOptional(TableSchemaOptions.ConstraintKeyOptions.CONSTRAINT_KEYS).isPresent()) {
            tableSchemaBuilder.constraintKey(this.constraintKeyParser.parse(schemaConfig));
        }
        return tableSchemaBuilder.build();
    }

    private static class PrimaryKeyParser
    implements TableSchemaParser.PrimaryKeyParser<ReadonlyConfig> {
        private PrimaryKeyParser() {
        }

        @Override
        public PrimaryKey parse(ReadonlyConfig schemaConfig) {
            ReadonlyConfig primaryKeyConfig = ReadonlyConfig.fromMap(schemaConfig.get(TableSchemaOptions.PrimaryKeyOptions.PRIMARY_KEY));
            String primaryKeyName = primaryKeyConfig.getOptional(TableSchemaOptions.PrimaryKeyOptions.PRIMARY_KEY_NAME).orElseThrow(() -> new IllegalArgumentException("Schema config need option [primaryKey.name], please correct your config first"));
            List<String> columns = primaryKeyConfig.getOptional(TableSchemaOptions.PrimaryKeyOptions.PRIMARY_KEY_COLUMNS).orElseThrow(() -> new IllegalArgumentException("Schema config need option [primaryKey.columnNames], please correct your config first"));
            return new PrimaryKey(primaryKeyName, columns);
        }
    }

    private static class ConstraintKeyParser
    implements TableSchemaParser.ConstraintKeyParser<ReadonlyConfig> {
        private ConstraintKeyParser() {
        }

        @Override
        public List<ConstraintKey> parse(ReadonlyConfig schemaConfig) {
            return schemaConfig.get(TableSchemaOptions.ConstraintKeyOptions.CONSTRAINT_KEYS).stream().map(ReadonlyConfig::fromMap).map(constraintKeyConfig -> {
                String constraintName = constraintKeyConfig.getOptional(TableSchemaOptions.ConstraintKeyOptions.CONSTRAINT_KEY_NAME).orElseThrow(() -> new IllegalArgumentException("schema.constraintKeys.* config need option [constraintName], please correct your config first"));
                ConstraintKey.ConstraintType constraintType = constraintKeyConfig.getOptional(TableSchemaOptions.ConstraintKeyOptions.CONSTRAINT_KEY_TYPE).orElseThrow(() -> new IllegalArgumentException("schema.constraintKeys.* config need option [constraintType], please correct your config first"));
                List columns = constraintKeyConfig.getOptional(TableSchemaOptions.ConstraintKeyOptions.CONSTRAINT_KEY_COLUMNS).map(constraintColumnMapList -> constraintColumnMapList.stream().map(ReadonlyConfig::fromMap).map(constraintColumnConfig -> {
                    String columnName = constraintColumnConfig.getOptional(TableSchemaOptions.ConstraintKeyOptions.CONSTRAINT_KEY_COLUMN_NAME).orElseThrow(() -> new IllegalArgumentException("schema.constraintKeys.constraintColumns.* config need option [columnName], please correct your config first"));
                    ConstraintKey.ColumnSortType columnSortType = constraintColumnConfig.get(TableSchemaOptions.ConstraintKeyOptions.CONSTRAINT_KEY_COLUMN_SORT_TYPE);
                    return ConstraintKey.ConstraintKeyColumn.of(columnName, columnSortType);
                }).collect(Collectors.toList())).orElseThrow(() -> new IllegalArgumentException("schema.constraintKeys.* config need option [columns], please correct your config first"));
                return ConstraintKey.of(constraintType, constraintName, columns);
            }).collect(Collectors.toList());
        }
    }

    private static class ColumnParser
    implements TableSchemaParser.ColumnParser<ReadonlyConfig> {
        private ColumnParser() {
        }

        @Override
        public List<Column> parse(ReadonlyConfig schemaConfig) {
            return schemaConfig.get(TableSchemaOptions.ColumnOptions.COLUMNS).stream().map(ReadonlyConfig::fromMap).map(columnConfig -> {
                String name = columnConfig.getOptional(TableSchemaOptions.ColumnOptions.NAME).orElseThrow(() -> new IllegalArgumentException("schema.columns.* config need option [name], please correct your config first"));
                SeaTunnelDataType seaTunnelDataType = columnConfig.getOptional(TableSchemaOptions.ColumnOptions.TYPE).map(column -> SeaTunnelDataTypeConvertorUtil.deserializeSeaTunnelDataType(name, column)).orElseThrow(() -> new IllegalArgumentException("schema.columns.* config need option [type], please correct your config first"));
                Long columnLength = columnConfig.get(TableSchemaOptions.ColumnOptions.COLUMN_LENGTH);
                Integer columnScale = columnConfig.get(TableSchemaOptions.ColumnOptions.COLUMN_SCALE);
                Boolean nullable = columnConfig.get(TableSchemaOptions.ColumnOptions.NULLABLE);
                Object defaultValue = columnConfig.get(TableSchemaOptions.ColumnOptions.DEFAULT_VALUE);
                String comment = columnConfig.get(TableSchemaOptions.ColumnOptions.COMMENT);
                return PhysicalColumn.of(name, seaTunnelDataType, columnLength, columnScale, nullable, defaultValue, comment);
            }).collect(Collectors.toList());
        }
    }

    private static class FieldParser
    implements TableSchemaParser.FieldParser<ReadonlyConfig> {
        private FieldParser() {
        }

        @Override
        public List<Column> parse(ReadonlyConfig schemaConfig) {
            JsonNode jsonNode = JsonUtils.toJsonNode(schemaConfig.get(TableSchemaOptions.FieldOptions.FIELDS));
            Map fieldsMap = JsonUtils.toStringMap((JsonNode)jsonNode);
            int fieldsNum = fieldsMap.size();
            ArrayList<Column> columns = new ArrayList<Column>(fieldsNum);
            for (Map.Entry entry : fieldsMap.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                SeaTunnelDataType<?> dataType = SeaTunnelDataTypeConvertorUtil.deserializeSeaTunnelDataType(key, value);
                PhysicalColumn column = PhysicalColumn.of(key, dataType, null, null, true, null, null);
                columns.add(column);
            }
            return columns;
        }
    }
}

