/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.redis.config;

import java.util.List;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.Options;
import org.apache.seatunnel.connectors.seatunnel.redis.config.RedisDataType;

public class RedisConfig {
    public static final String CONNECTOR_IDENTITY = "Redis";
    public static final Option<String> HOST = Options.key((String)"host").stringType().noDefaultValue().withDescription("redis hostname or ip");
    public static final Option<Integer> PORT = Options.key((String)"port").intType().noDefaultValue().withDescription("redis port");
    public static final Option<String> AUTH = Options.key((String)"auth").stringType().noDefaultValue().withDescription("redis authentication password, you need it when you connect to an encrypted cluster");
    public static final Option<Integer> DB_NUM = Options.key((String)"db_num").intType().defaultValue((Object)0).withDescription("Redis  database index id, it is connected to db 0 by default");
    public static final Option<String> USER = Options.key((String)"user").stringType().noDefaultValue().withDescription("redis authentication user, you need it when you connect to an encrypted cluster");
    public static final Option<String> KEY_PATTERN = Options.key((String)"keys").stringType().noDefaultValue().withDescription("keys pattern, redis source connector support fuzzy key matching, user needs to ensure that the matched keys are the same type");
    public static final Option<String> KEY = Options.key((String)"key").stringType().noDefaultValue().withDescription("The value of key you want to write to redis.");
    public static final Option<RedisDataType> DATA_TYPE = Options.key((String)"data_type").enumType(RedisDataType.class).noDefaultValue().withDescription("redis data types, support string hash list set zset.");
    public static final Option<Format> FORMAT = Options.key((String)"format").enumType(Format.class).defaultValue((Object)Format.JSON).withDescription("the format of upstream data, now only support json and text, default json.");
    public static final Option<RedisMode> MODE = Options.key((String)"mode").enumType(RedisMode.class).defaultValue((Object)RedisMode.SINGLE).withDescription("redis mode, support single or cluster, default value is single");
    public static final Option<List<String>> NODES = Options.key((String)"nodes").listType().noDefaultValue().withDescription("redis nodes information, used in cluster mode, must like as the following format: [host1:port1, host2:port2]");
    public static final Option<HashKeyParseMode> HASH_KEY_PARSE_MODE = Options.key((String)"hash_key_parse_mode").enumType(HashKeyParseMode.class).defaultValue((Object)HashKeyParseMode.ALL).withDescription("hash key parse mode, support all or kv, default value is all");
    public static final Option<Long> EXPIRE = Options.key((String)"expire").longType().defaultValue((Object)-1L).withDescription("Set redis expiration time.");
    public static final Option<Integer> BATCH_SIZE = Options.key((String)"batch_size").intType().defaultValue((Object)10).withDescription("batch_size is used to control the size of a batch of data during read and write operations,default 10");
    public static final Option<Boolean> SUPPORT_CUSTOM_KEY = Options.key((String)"support_custom_key").booleanType().defaultValue((Object)false).withDescription("if true, the key can be customized by the field value in the upstream data.");
    public static final Option<String> VALUE_FIELD = Options.key((String)"value_field").stringType().noDefaultValue().withDescription("The field of value you want to write to redis, support string list set zset");
    public static final Option<String> HASH_KEY_FIELD = Options.key((String)"hash_key_field").stringType().noDefaultValue().withDescription("The field of hash key you want to write to redis");
    public static final Option<String> HASH_VALUE_FIELD = Options.key((String)"hash_value_field").stringType().noDefaultValue().withDescription("The field of hash value you want to write to redis");

    public static enum Format {
        JSON;

    }

    public static enum HashKeyParseMode {
        ALL,
        KV;

    }

    public static enum RedisMode {
        SINGLE,
        CLUSTER;

    }
}

