/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.rabbitmq.sink;

import java.util.Optional;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.connectors.seatunnel.common.sink.AbstractSinkWriter;
import org.apache.seatunnel.connectors.seatunnel.rabbitmq.client.RabbitmqClient;
import org.apache.seatunnel.connectors.seatunnel.rabbitmq.config.RabbitmqConfig;
import org.apache.seatunnel.format.json.JsonSerializationSchema;

public class RabbitmqSinkWriter
extends AbstractSinkWriter<SeaTunnelRow, Void> {
    private RabbitmqClient rabbitMQClient;
    private final JsonSerializationSchema jsonSerializationSchema;

    public RabbitmqSinkWriter(RabbitmqConfig config, SeaTunnelRowType seaTunnelRowType) {
        this.rabbitMQClient = new RabbitmqClient(config);
        this.jsonSerializationSchema = new JsonSerializationSchema(seaTunnelRowType);
    }

    public void write(SeaTunnelRow element) {
        this.rabbitMQClient.write(this.jsonSerializationSchema.serialize(element));
    }

    @Override
    public Optional prepareCommit() {
        return Optional.empty();
    }

    public void close() {
        if (this.rabbitMQClient != null) {
            this.rabbitMQClient.close();
        }
    }
}

