/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.format.protobuf;

import com.github.os72.protocjar.Protoc;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import org.apache.seatunnel.common.utils.FileUtils;
import org.apache.seatunnel.format.protobuf.exception.ProtobufFormatErrorCode;
import org.apache.seatunnel.format.protobuf.exception.SeaTunnelProtobufFormatException;

public class CompileDescriptor {
    /*
     * Loose catch block
     */
    public static Descriptors.Descriptor compileDescriptorTempFile(String protoContent, String messageName) throws IOException, InterruptedException, Descriptors.DescriptorValidationException {
        File tmpDir = CompileDescriptor.createTempDirectory();
        File protoFile = CompileDescriptor.createProtoFile(tmpDir, protoContent);
        String targetDescPath = CompileDescriptor.compileProtoToDescriptor(tmpDir, protoFile);
        try {
            try (FileInputStream fis = new FileInputStream(targetDescPath);){
                DescriptorProtos.FileDescriptorSet descriptorSet = DescriptorProtos.FileDescriptorSet.parseFrom(fis);
                Descriptors.FileDescriptor[] descriptorsArray = CompileDescriptor.buildFileDescriptors(descriptorSet);
                Descriptors.Descriptor descriptor = descriptorsArray[0].findMessageTypeByName(messageName);
                return descriptor;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            tmpDir.delete();
            protoFile.delete();
            new File(targetDescPath).delete();
        }
    }

    private static File createTempDirectory() throws IOException {
        File tmpDir = File.createTempFile("tmp_protobuf_", "_proto");
        tmpDir.delete();
        tmpDir.mkdirs();
        tmpDir.deleteOnExit();
        return tmpDir;
    }

    private static File createProtoFile(File tmpDir, String protoContent) throws IOException {
        File protoFile = new File(tmpDir, ".proto");
        protoFile.deleteOnExit();
        FileUtils.writeStringToFile((String)protoFile.getPath(), (String)protoContent);
        return protoFile;
    }

    private static String compileProtoToDescriptor(File tmpDir, File protoFile) throws IOException, InterruptedException {
        String targetDesc = tmpDir + "/.desc";
        new File(targetDesc).deleteOnExit();
        int exitCode = Protoc.runProtoc(new String[]{"--proto_path=" + protoFile.getParent(), "--descriptor_set_out=" + targetDesc, protoFile.getPath()});
        if (exitCode != 0) {
            throw new SeaTunnelProtobufFormatException(ProtobufFormatErrorCode.DESCRIPTOR_CONVERT_FAILED, "Protoc compile error, exit code: " + exitCode);
        }
        return targetDesc;
    }

    private static Descriptors.FileDescriptor[] buildFileDescriptors(DescriptorProtos.FileDescriptorSet descriptorSet) throws Descriptors.DescriptorValidationException {
        List<DescriptorProtos.FileDescriptorProto> fileDescriptors = descriptorSet.getFileList();
        Descriptors.FileDescriptor[] descriptorsArray = new Descriptors.FileDescriptor[fileDescriptors.size()];
        for (int i = 0; i < fileDescriptors.size(); ++i) {
            descriptorsArray[i] = Descriptors.FileDescriptor.buildFrom(fileDescriptors.get(i), new Descriptors.FileDescriptor[0]);
        }
        return descriptorsArray;
    }
}

