/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.kafka.source;

import com.google.auto.service.AutoService;
import java.io.Serializable;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.source.SeaTunnelSource;
import org.apache.seatunnel.api.source.SourceSplit;
import org.apache.seatunnel.api.table.catalog.CatalogOptions;
import org.apache.seatunnel.api.table.catalog.schema.TableSchemaOptions;
import org.apache.seatunnel.api.table.connector.TableSource;
import org.apache.seatunnel.api.table.factory.Factory;
import org.apache.seatunnel.api.table.factory.TableSourceFactory;
import org.apache.seatunnel.api.table.factory.TableSourceFactoryContext;
import org.apache.seatunnel.connectors.seatunnel.kafka.config.Config;
import org.apache.seatunnel.connectors.seatunnel.kafka.config.StartMode;
import org.apache.seatunnel.connectors.seatunnel.kafka.source.KafkaSource;

@AutoService(value={Factory.class})
public class KafkaSourceFactory
implements TableSourceFactory {
    public String factoryIdentifier() {
        return "Kafka";
    }

    public OptionRule optionRule() {
        return OptionRule.builder().required(new Option[]{Config.BOOTSTRAP_SERVERS}).exclusive(new Option[]{Config.TOPIC, TableSchemaOptions.TABLE_CONFIGS, CatalogOptions.TABLE_LIST}).optional(new Option[]{Config.START_MODE, Config.PATTERN, Config.CONSUMER_GROUP, Config.COMMIT_ON_CHECKPOINT, Config.KAFKA_CONFIG, Config.SCHEMA, Config.FORMAT, Config.DEBEZIUM_RECORD_INCLUDE_SCHEMA, Config.DEBEZIUM_RECORD_TABLE_FILTER, Config.KEY_PARTITION_DISCOVERY_INTERVAL_MILLIS}).conditional(Config.START_MODE, (Object)StartMode.TIMESTAMP, new Option[]{Config.START_MODE_TIMESTAMP}).conditional(Config.START_MODE, (Object)StartMode.SPECIFIC_OFFSETS, new Option[]{Config.START_MODE_OFFSETS}).build();
    }

    public <T, SplitT extends SourceSplit, StateT extends Serializable> TableSource<T, SplitT, StateT> createSource(TableSourceFactoryContext context) {
        return () -> new KafkaSource(context.getOptions());
    }

    public Class<? extends SeaTunnelSource> getSourceClass() {
        return KafkaSource.class;
    }
}

