/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.txn;

import org.tikv.kvproto.Kvrpcpb;
import org.tikv.shade.com.google.protobuf.ByteString;

public class Lock {
    private static final long DEFAULT_LOCK_TTL = 3000L;
    private final long txnID;
    private final long ttl;
    private final ByteString key;
    private final ByteString primary;
    private final long txnSize;
    private final Kvrpcpb.Op lockType;
    private final long lockForUpdateTs;

    public Lock(Kvrpcpb.LockInfo l) {
        this.txnID = l.getLockVersion();
        this.key = l.getKey();
        this.primary = l.getPrimaryLock();
        this.ttl = l.getLockTtl() == 0L ? 3000L : l.getLockTtl();
        this.txnSize = l.getTxnSize();
        this.lockType = l.getLockType();
        this.lockForUpdateTs = l.getLockForUpdateTs();
    }

    public long getTxnID() {
        return this.txnID;
    }

    public long getTtl() {
        return this.ttl;
    }

    public ByteString getKey() {
        return this.key;
    }

    public ByteString getPrimary() {
        return this.primary;
    }

    public long getTxnSize() {
        return this.txnSize;
    }

    public Kvrpcpb.Op getLockType() {
        return this.lockType;
    }

    public long getLockForUpdateTs() {
        return this.lockForUpdateTs;
    }
}

