/*
 * Decompiled with CFR 0.152.
 */
package org.influxdb.impl;

import org.influxdb.dto.QueryResult;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.Query;
import retrofit2.http.Streaming;
import shaded.okhttp3.RequestBody;
import shaded.okhttp3.ResponseBody;

interface InfluxDBService {
    public static final String U = "u";
    public static final String P = "p";
    public static final String Q = "q";
    public static final String DB = "db";
    public static final String RP = "rp";
    public static final String PARAMS = "params";
    public static final String PRECISION = "precision";
    public static final String CONSISTENCY = "consistency";
    public static final String EPOCH = "epoch";
    public static final String CHUNK_SIZE = "chunk_size";

    @GET(value="ping")
    public Call<ResponseBody> ping();

    @POST(value="write")
    public Call<ResponseBody> writePoints(@Query(value="db") String var1, @Query(value="rp") String var2, @Query(value="precision") String var3, @Query(value="consistency") String var4, @Body RequestBody var5);

    @GET(value="query")
    public Call<QueryResult> query(@Query(value="db") String var1, @Query(value="epoch") String var2, @Query(value="q", encoded=true) String var3);

    @POST(value="query")
    public Call<QueryResult> query(@Query(value="db") String var1, @Query(value="epoch") String var2, @Query(value="q", encoded=true) String var3, @Query(value="params", encoded=true) String var4);

    @GET(value="query")
    public Call<QueryResult> query(@Query(value="db") String var1, @Query(value="q", encoded=true) String var2);

    @POST(value="query")
    public Call<QueryResult> postQuery(@Query(value="db") String var1, @Query(value="q", encoded=true) String var2);

    @POST(value="query")
    public Call<QueryResult> postQuery(@Query(value="db") String var1, @Query(value="q", encoded=true) String var2, @Query(value="params", encoded=true) String var3);

    @GET(value="query")
    public Call<QueryResult> query(@Query(value="q", encoded=true) String var1);

    @POST(value="query")
    public Call<QueryResult> postQuery(@Query(value="q", encoded=true) String var1);

    @Streaming
    @GET(value="query?chunked=true")
    public Call<ResponseBody> query(@Query(value="db") String var1, @Query(value="q", encoded=true) String var2, @Query(value="chunk_size") int var3);

    @Streaming
    @POST(value="query?chunked=true")
    public Call<ResponseBody> query(@Query(value="db") String var1, @Query(value="q", encoded=true) String var2, @Query(value="chunk_size") int var3, @Query(value="params", encoded=true) String var4);
}

