/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.shade.connector-iceberg.org.apache.parquet.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.parquet.io.SeekableInputStream;

public abstract class DelegatingSeekableInputStream
extends SeekableInputStream {
    private final int COPY_BUFFER_SIZE = 8192;
    private final byte[] temp = new byte[8192];
    private final InputStream stream;

    public DelegatingSeekableInputStream(InputStream stream) {
        this.stream = stream;
    }

    public InputStream getStream() {
        return this.stream;
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }

    @Override
    public abstract long getPos() throws IOException;

    @Override
    public abstract void seek(long var1) throws IOException;

    @Override
    public int read() throws IOException {
        return this.stream.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.stream.read(b, off, len);
    }

    @Override
    public void readFully(byte[] bytes) throws IOException {
        DelegatingSeekableInputStream.readFully(this.stream, bytes, 0, bytes.length);
    }

    @Override
    public void readFully(byte[] bytes, int start, int len) throws IOException {
        DelegatingSeekableInputStream.readFully(this.stream, bytes, start, len);
    }

    @Override
    public int read(ByteBuffer buf) throws IOException {
        if (buf.hasArray()) {
            return DelegatingSeekableInputStream.readHeapBuffer(this.stream, buf);
        }
        return DelegatingSeekableInputStream.readDirectBuffer(this.stream, buf, this.temp);
    }

    @Override
    public void readFully(ByteBuffer buf) throws IOException {
        if (buf.hasArray()) {
            DelegatingSeekableInputStream.readFullyHeapBuffer(this.stream, buf);
        } else {
            DelegatingSeekableInputStream.readFullyDirectBuffer(this.stream, buf, this.temp);
        }
    }

    static void readFully(InputStream f, byte[] bytes, int start, int len) throws IOException {
        int offset = start;
        int remaining = len;
        while (remaining > 0) {
            int bytesRead = f.read(bytes, offset, remaining);
            if (bytesRead < 0) {
                throw new EOFException("Reached the end of stream with " + remaining + " bytes left to read");
            }
            remaining -= bytesRead;
            offset += bytesRead;
        }
    }

    static int readHeapBuffer(InputStream f, ByteBuffer buf) throws IOException {
        int bytesRead = f.read(buf.array(), buf.arrayOffset() + buf.position(), buf.remaining());
        if (bytesRead < 0) {
            return bytesRead;
        }
        buf.position(buf.position() + bytesRead);
        return bytesRead;
    }

    static void readFullyHeapBuffer(InputStream f, ByteBuffer buf) throws IOException {
        DelegatingSeekableInputStream.readFully(f, buf.array(), buf.arrayOffset() + buf.position(), buf.remaining());
        buf.position(buf.limit());
    }

    static int readDirectBuffer(InputStream f, ByteBuffer buf, byte[] temp) throws IOException {
        int bytesRead;
        int nextReadLength = Math.min(buf.remaining(), temp.length);
        int totalBytesRead = 0;
        while ((bytesRead = f.read(temp, 0, nextReadLength)) == temp.length) {
            buf.put(temp);
            totalBytesRead += bytesRead;
            nextReadLength = Math.min(buf.remaining(), temp.length);
        }
        if (bytesRead < 0) {
            return totalBytesRead == 0 ? -1 : totalBytesRead;
        }
        buf.put(temp, 0, bytesRead);
        return totalBytesRead += bytesRead;
    }

    static void readFullyDirectBuffer(InputStream f, ByteBuffer buf, byte[] temp) throws IOException {
        int nextReadLength = Math.min(buf.remaining(), temp.length);
        int bytesRead = 0;
        while (nextReadLength > 0 && (bytesRead = f.read(temp, 0, nextReadLength)) >= 0) {
            buf.put(temp, 0, bytesRead);
            nextReadLength = Math.min(buf.remaining(), temp.length);
        }
        if (bytesRead < 0 && buf.remaining() > 0) {
            throw new EOFException("Reached the end of stream with " + buf.remaining() + " bytes left to read");
        }
    }
}

