/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.shade.connector-iceberg.org.apache.parquet.filter2.compat;

import java.util.Objects;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.parquet.Preconditions;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.parquet.filter.UnboundRecordFilter;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.parquet.filter2.predicate.LogicalInverseRewriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterCompat {
    private static final Logger LOG = LoggerFactory.getLogger(FilterCompat.class);
    public static final Filter NOOP = new NoOpFilter();

    public static Filter get(FilterPredicate filterPredicate) {
        Objects.requireNonNull(filterPredicate, "filterPredicate cannot be null");
        LOG.info("Filtering using predicate: {}", (Object)filterPredicate);
        FilterPredicate collapsedPredicate = LogicalInverseRewriter.rewrite(filterPredicate);
        if (!filterPredicate.equals(collapsedPredicate)) {
            LOG.info("Predicate has been collapsed to: {}", (Object)collapsedPredicate);
        }
        return new FilterPredicateCompat(collapsedPredicate);
    }

    public static Filter get(UnboundRecordFilter unboundRecordFilter) {
        return new UnboundRecordFilterCompat(unboundRecordFilter);
    }

    public static Filter get(FilterPredicate filterPredicate, UnboundRecordFilter unboundRecordFilter) {
        Preconditions.checkArgument(filterPredicate == null || unboundRecordFilter == null, "Cannot provide both a FilterPredicate and an UnboundRecordFilter");
        if (filterPredicate != null) {
            return FilterCompat.get(filterPredicate);
        }
        if (unboundRecordFilter != null) {
            return FilterCompat.get(unboundRecordFilter);
        }
        return NOOP;
    }

    public static boolean isFilteringRequired(Filter filter) {
        return filter != null && !(filter instanceof NoOpFilter);
    }

    public static final class NoOpFilter
    implements Filter {
        private NoOpFilter() {
        }

        @Override
        public <R> R accept(Visitor<R> visitor) {
            return visitor.visit(this);
        }
    }

    public static final class UnboundRecordFilterCompat
    implements Filter {
        private final UnboundRecordFilter unboundRecordFilter;

        private UnboundRecordFilterCompat(UnboundRecordFilter unboundRecordFilter) {
            this.unboundRecordFilter = Objects.requireNonNull(unboundRecordFilter, "unboundRecordFilter cannot be null");
        }

        public UnboundRecordFilter getUnboundRecordFilter() {
            return this.unboundRecordFilter;
        }

        @Override
        public <R> R accept(Visitor<R> visitor) {
            return visitor.visit(this);
        }
    }

    public static final class FilterPredicateCompat
    implements Filter {
        private final FilterPredicate filterPredicate;

        private FilterPredicateCompat(FilterPredicate filterPredicate) {
            this.filterPredicate = Objects.requireNonNull(filterPredicate, "filterPredicate cannot be null");
        }

        public FilterPredicate getFilterPredicate() {
            return this.filterPredicate;
        }

        @Override
        public <R> R accept(Visitor<R> visitor) {
            return visitor.visit(this);
        }
    }

    public static interface Filter {
        public <R> R accept(Visitor<R> var1);
    }

    public static interface Visitor<T> {
        public T visit(FilterPredicateCompat var1);

        public T visit(UnboundRecordFilterCompat var1);

        public T visit(NoOpFilter var1);
    }
}

