/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.shade.connector-iceberg.org.apache.parquet.filter2.bloomfilterlevel;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.parquet.Preconditions;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.parquet.column.values.bloomfilter.BloomFilter;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.parquet.filter2.predicate.Operators;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.parquet.filter2.predicate.UserDefinedPredicate;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.parquet.hadoop.BloomFilterReader;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.parquet.hadoop.metadata.ColumnPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BloomFilterImpl
implements FilterPredicate.Visitor<Boolean> {
    private static final Logger LOG = LoggerFactory.getLogger(BloomFilterImpl.class);
    private static final boolean BLOCK_MIGHT_MATCH = false;
    private static final boolean BLOCK_CANNOT_MATCH = true;
    private final Map<ColumnPath, ColumnChunkMetaData> columns = new HashMap<ColumnPath, ColumnChunkMetaData>();
    private BloomFilterReader bloomFilterReader;

    public static boolean canDrop(FilterPredicate pred, List<ColumnChunkMetaData> columns, BloomFilterReader bloomFilterReader) {
        Preconditions.checkNotNull(pred, "pred");
        Preconditions.checkNotNull(columns, "columns");
        return pred.accept(new BloomFilterImpl(columns, bloomFilterReader));
    }

    private BloomFilterImpl(List<ColumnChunkMetaData> columnsList, BloomFilterReader bloomFilterReader) {
        for (ColumnChunkMetaData chunk : columnsList) {
            this.columns.put(chunk.getPath(), chunk);
        }
        this.bloomFilterReader = bloomFilterReader;
    }

    private ColumnChunkMetaData getColumnChunk(ColumnPath columnPath) {
        return this.columns.get(columnPath);
    }

    @Override
    public <T extends Comparable<T>> Boolean visit(Operators.Eq<T> eq) {
        Comparable value = eq.getValue();
        if (value == null) {
            return false;
        }
        Operators.Column filterColumn = eq.getColumn();
        ColumnChunkMetaData meta = this.getColumnChunk(filterColumn.getColumnPath());
        if (meta == null) {
            return true;
        }
        try {
            BloomFilter bloomFilter = this.bloomFilterReader.readBloomFilter(meta);
            if (bloomFilter != null && !bloomFilter.findHash(bloomFilter.hash(value))) {
                return true;
            }
        }
        catch (RuntimeException e) {
            LOG.warn(e.getMessage());
            return false;
        }
        return false;
    }

    @Override
    public <T extends Comparable<T>> Boolean visit(Operators.NotEq<T> notEq) {
        return false;
    }

    @Override
    public <T extends Comparable<T>> Boolean visit(Operators.Lt<T> lt) {
        return false;
    }

    @Override
    public <T extends Comparable<T>> Boolean visit(Operators.LtEq<T> ltEq) {
        return false;
    }

    @Override
    public <T extends Comparable<T>> Boolean visit(Operators.Gt<T> gt) {
        return false;
    }

    @Override
    public <T extends Comparable<T>> Boolean visit(Operators.GtEq<T> gtEq) {
        return false;
    }

    @Override
    public <T extends Comparable<T>> Boolean visit(Operators.In<T> in) {
        Set values = in.getValues();
        if (values.contains(null)) {
            return false;
        }
        Operators.Column filterColumn = in.getColumn();
        ColumnChunkMetaData meta = this.getColumnChunk(filterColumn.getColumnPath());
        if (meta == null) {
            return true;
        }
        BloomFilter bloomFilter = this.bloomFilterReader.readBloomFilter(meta);
        if (bloomFilter != null) {
            for (Comparable value : values) {
                if (!bloomFilter.findHash(bloomFilter.hash(value))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public <T extends Comparable<T>> Boolean visit(Operators.NotIn<T> notIn) {
        return false;
    }

    @Override
    public Boolean visit(Operators.And and) {
        return and.getLeft().accept(this) != false || and.getRight().accept(this) != false;
    }

    @Override
    public Boolean visit(Operators.Or or) {
        return or.getLeft().accept(this) != false && or.getRight().accept(this) != false;
    }

    @Override
    public Boolean visit(Operators.Not not) {
        throw new IllegalArgumentException("This predicate contains a not! Did you forget to run this predicate through LogicalInverseRewriter? " + not);
    }

    private <T extends Comparable<T>, U extends UserDefinedPredicate<T>> Boolean visit(Operators.UserDefined<T, U> ud, boolean inverted) {
        return false;
    }

    @Override
    public <T extends Comparable<T>, U extends UserDefinedPredicate<T>> Boolean visit(Operators.UserDefined<T, U> udp) {
        return this.visit(udp, false);
    }

    @Override
    public <T extends Comparable<T>, U extends UserDefinedPredicate<T>> Boolean visit(Operators.LogicalNotUserDefined<T, U> udp) {
        return this.visit(udp.getUserDefined(), true);
    }
}

