/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.shade.connector-iceberg.org.apache.parquet.column.values.factory;

import org.apache.seatunnel.shade.connector-iceberg.org.apache.parquet.column.ColumnDescriptor;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.parquet.column.Encoding;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.parquet.column.ParquetProperties;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.parquet.column.values.ValuesWriter;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.parquet.column.values.bytestreamsplit.ByteStreamSplitValuesWriter;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.parquet.column.values.factory.DefaultValuesWriterFactory;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.parquet.column.values.factory.ValuesWriterFactory;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.parquet.column.values.plain.BooleanPlainValuesWriter;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.parquet.column.values.plain.FixedLenByteArrayPlainValuesWriter;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.parquet.column.values.plain.PlainValuesWriter;

public class DefaultV1ValuesWriterFactory
implements ValuesWriterFactory {
    private ParquetProperties parquetProperties;

    @Override
    public void initialize(ParquetProperties properties) {
        this.parquetProperties = properties;
    }

    private Encoding getEncodingForDataPage() {
        return Encoding.PLAIN_DICTIONARY;
    }

    private Encoding getEncodingForDictionaryPage() {
        return Encoding.PLAIN_DICTIONARY;
    }

    @Override
    public ValuesWriter newValuesWriter(ColumnDescriptor descriptor) {
        switch (descriptor.getType()) {
            case BOOLEAN: {
                return this.getBooleanValuesWriter();
            }
            case FIXED_LEN_BYTE_ARRAY: {
                return this.getFixedLenByteArrayValuesWriter(descriptor);
            }
            case BINARY: {
                return this.getBinaryValuesWriter(descriptor);
            }
            case INT32: {
                return this.getInt32ValuesWriter(descriptor);
            }
            case INT64: {
                return this.getInt64ValuesWriter(descriptor);
            }
            case INT96: {
                return this.getInt96ValuesWriter(descriptor);
            }
            case DOUBLE: {
                return this.getDoubleValuesWriter(descriptor);
            }
            case FLOAT: {
                return this.getFloatValuesWriter(descriptor);
            }
        }
        throw new IllegalArgumentException("Unknown type " + (Object)((Object)descriptor.getType()));
    }

    private ValuesWriter getBooleanValuesWriter() {
        return new BooleanPlainValuesWriter();
    }

    private ValuesWriter getFixedLenByteArrayValuesWriter(ColumnDescriptor path) {
        return new FixedLenByteArrayPlainValuesWriter(path.getTypeLength(), this.parquetProperties.getInitialSlabSize(), this.parquetProperties.getPageSizeThreshold(), this.parquetProperties.getAllocator());
    }

    private ValuesWriter getBinaryValuesWriter(ColumnDescriptor path) {
        PlainValuesWriter fallbackWriter = new PlainValuesWriter(this.parquetProperties.getInitialSlabSize(), this.parquetProperties.getPageSizeThreshold(), this.parquetProperties.getAllocator());
        return DefaultValuesWriterFactory.dictWriterWithFallBack(path, this.parquetProperties, this.getEncodingForDictionaryPage(), this.getEncodingForDataPage(), fallbackWriter);
    }

    private ValuesWriter getInt32ValuesWriter(ColumnDescriptor path) {
        PlainValuesWriter fallbackWriter = new PlainValuesWriter(this.parquetProperties.getInitialSlabSize(), this.parquetProperties.getPageSizeThreshold(), this.parquetProperties.getAllocator());
        return DefaultValuesWriterFactory.dictWriterWithFallBack(path, this.parquetProperties, this.getEncodingForDictionaryPage(), this.getEncodingForDataPage(), fallbackWriter);
    }

    private ValuesWriter getInt64ValuesWriter(ColumnDescriptor path) {
        PlainValuesWriter fallbackWriter = new PlainValuesWriter(this.parquetProperties.getInitialSlabSize(), this.parquetProperties.getPageSizeThreshold(), this.parquetProperties.getAllocator());
        return DefaultValuesWriterFactory.dictWriterWithFallBack(path, this.parquetProperties, this.getEncodingForDictionaryPage(), this.getEncodingForDataPage(), fallbackWriter);
    }

    private ValuesWriter getInt96ValuesWriter(ColumnDescriptor path) {
        FixedLenByteArrayPlainValuesWriter fallbackWriter = new FixedLenByteArrayPlainValuesWriter(12, this.parquetProperties.getInitialSlabSize(), this.parquetProperties.getPageSizeThreshold(), this.parquetProperties.getAllocator());
        return DefaultValuesWriterFactory.dictWriterWithFallBack(path, this.parquetProperties, this.getEncodingForDictionaryPage(), this.getEncodingForDataPage(), fallbackWriter);
    }

    private ValuesWriter getDoubleValuesWriter(ColumnDescriptor path) {
        ValuesWriter fallbackWriter = null;
        fallbackWriter = this.parquetProperties.isByteStreamSplitEnabled() ? new ByteStreamSplitValuesWriter.DoubleByteStreamSplitValuesWriter(this.parquetProperties.getInitialSlabSize(), this.parquetProperties.getPageSizeThreshold(), this.parquetProperties.getAllocator()) : new PlainValuesWriter(this.parquetProperties.getInitialSlabSize(), this.parquetProperties.getPageSizeThreshold(), this.parquetProperties.getAllocator());
        return DefaultValuesWriterFactory.dictWriterWithFallBack(path, this.parquetProperties, this.getEncodingForDictionaryPage(), this.getEncodingForDataPage(), fallbackWriter);
    }

    private ValuesWriter getFloatValuesWriter(ColumnDescriptor path) {
        ValuesWriter fallbackWriter = null;
        fallbackWriter = this.parquetProperties.isByteStreamSplitEnabled() ? new ByteStreamSplitValuesWriter.FloatByteStreamSplitValuesWriter(this.parquetProperties.getInitialSlabSize(), this.parquetProperties.getPageSizeThreshold(), this.parquetProperties.getAllocator()) : new PlainValuesWriter(this.parquetProperties.getInitialSlabSize(), this.parquetProperties.getPageSizeThreshold(), this.parquetProperties.getAllocator());
        return DefaultValuesWriterFactory.dictWriterWithFallBack(path, this.parquetProperties, this.getEncodingForDictionaryPage(), this.getEncodingForDataPage(), fallbackWriter);
    }
}

