/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.shade.connector-iceberg.org.apache.orc.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.orc.CompressionCodec;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.orc.CompressionKind;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.orc.impl.DirectDecompressionCodec;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.orc.impl.HadoopShims;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.orc.impl.HadoopShimsFactory;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.orc.impl.OrcCodecPool;

public class ZlibCodec
implements CompressionCodec,
DirectDecompressionCodec {
    private static final HadoopShims SHIMS = HadoopShimsFactory.get();
    private HadoopShims.DirectDecompressor decompressShim = null;
    private Boolean direct = null;
    private static final ZlibOptions DEFAULT_OPTIONS = new ZlibOptions(-1, 0, true);

    @Override
    public CompressionCodec.Options getDefaultOptions() {
        return DEFAULT_OPTIONS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean compress(ByteBuffer in, ByteBuffer out, ByteBuffer overflow, CompressionCodec.Options options) {
        ZlibOptions zlo = (ZlibOptions)options;
        int length = in.remaining();
        int outSize = 0;
        Deflater deflater = new Deflater(zlo.level, true);
        try {
            deflater.setStrategy(zlo.strategy);
            deflater.setInput(in.array(), in.arrayOffset() + in.position(), length);
            deflater.finish();
            int offset = out.arrayOffset() + out.position();
            while (!deflater.finished() && length > outSize) {
                int size = deflater.deflate(out.array(), offset, out.remaining());
                out.position(size + out.position());
                outSize += size;
                offset += size;
                if (out.remaining() != 0) continue;
                if (overflow == null) {
                    boolean bl = false;
                    return bl;
                }
                out = overflow;
                offset = out.arrayOffset() + out.position();
            }
        }
        finally {
            deflater.end();
        }
        return length > outSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decompress(ByteBuffer in, ByteBuffer out) throws IOException {
        if (in.isDirect() && out.isDirect()) {
            this.directDecompress(in, out);
            return;
        }
        Inflater inflater = new Inflater(true);
        try {
            inflater.setInput(in.array(), in.arrayOffset() + in.position(), in.remaining());
            while (!(inflater.finished() || inflater.needsDictionary() || inflater.needsInput())) {
                try {
                    int count = inflater.inflate(out.array(), out.arrayOffset() + out.position(), out.remaining());
                    out.position(count + out.position());
                }
                catch (DataFormatException dfe) {
                    throw new IOException("Bad compression data", dfe);
                }
            }
            out.flip();
        }
        finally {
            inflater.end();
        }
        in.position(in.limit());
    }

    @Override
    public boolean isAvailable() {
        if (this.direct == null) {
            try {
                this.ensureShim();
                this.direct = this.decompressShim != null;
            }
            catch (UnsatisfiedLinkError ule) {
                this.direct = false;
            }
        }
        return this.direct;
    }

    private void ensureShim() {
        if (this.decompressShim == null) {
            this.decompressShim = SHIMS.getDirectDecompressor(HadoopShims.DirectCompressionType.ZLIB_NOHEADER);
        }
    }

    @Override
    public void directDecompress(ByteBuffer in, ByteBuffer out) throws IOException {
        this.ensureShim();
        this.decompressShim.decompress(in, out);
        out.flip();
    }

    @Override
    public void reset() {
        if (this.decompressShim != null) {
            this.decompressShim.reset();
        }
    }

    @Override
    public void destroy() {
        if (this.decompressShim != null) {
            this.decompressShim.end();
        }
    }

    @Override
    public CompressionKind getKind() {
        return CompressionKind.ZLIB;
    }

    @Override
    public void close() {
        OrcCodecPool.returnCodec(CompressionKind.ZLIB, this);
    }

    static class ZlibOptions
    implements CompressionCodec.Options {
        private int level;
        private int strategy;
        private final boolean FIXED;

        ZlibOptions(int level, int strategy, boolean fixed) {
            this.level = level;
            this.strategy = strategy;
            this.FIXED = fixed;
        }

        @Override
        public ZlibOptions copy() {
            return new ZlibOptions(this.level, this.strategy, false);
        }

        @Override
        public ZlibOptions setSpeed(CompressionCodec.SpeedModifier newValue) {
            if (this.FIXED) {
                throw new IllegalStateException("Attempt to modify the default options");
            }
            switch (newValue) {
                case FAST: {
                    this.level = 2;
                    break;
                }
                case DEFAULT: {
                    this.level = -1;
                    break;
                }
                case FASTEST: {
                    this.level = 1;
                    break;
                }
            }
            return this;
        }

        @Override
        public ZlibOptions setData(CompressionCodec.DataKind newValue) {
            if (this.FIXED) {
                throw new IllegalStateException("Attempt to modify the default options");
            }
            switch (newValue) {
                case BINARY: {
                    this.strategy = 1;
                    break;
                }
                case TEXT: {
                    this.strategy = 0;
                    break;
                }
            }
            return this;
        }

        public boolean equals(Object other) {
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            if (this == other) {
                return true;
            }
            ZlibOptions otherOpts = (ZlibOptions)other;
            return this.level == otherOpts.level && this.strategy == otherOpts.strategy;
        }

        public int hashCode() {
            return this.level + this.strategy * 101;
        }
    }
}

