/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.shade.connector-iceberg.org.apache.orc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.orc.impl.ParserUtils;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.orc.impl.TypeUtils;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.orc.storage.ql.exec.vector.VectorizedRowBatch;
import org.jetbrains.annotations.NotNull;

public class TypeDescription
implements Comparable<TypeDescription>,
Serializable,
Cloneable {
    private static final int MAX_PRECISION = 38;
    private static final int MAX_SCALE = 38;
    private static final int DEFAULT_PRECISION = 38;
    private static final int DEFAULT_SCALE = 10;
    public static final int MAX_DECIMAL64_PRECISION = 18;
    public static final long MAX_DECIMAL64 = 999999999999999999L;
    public static final long MIN_DECIMAL64 = -999999999999999999L;
    private static final int DEFAULT_LENGTH = 256;
    static final Pattern UNQUOTED_NAMES = Pattern.compile("^[a-zA-Z0-9_]+$");
    public static final String ENCRYPT_ATTRIBUTE = "encrypt";
    public static final String MASK_ATTRIBUTE = "mask";
    private int id = -1;
    private int maxId = -1;
    private TypeDescription parent;
    private final Category category;
    private final List<TypeDescription> children;
    private final List<String> fieldNames;
    private final Map<String, String> attributes = new HashMap<String, String>();
    private int maxLength = 256;
    private int precision = 38;
    private int scale = 10;

    @Override
    public int compareTo(TypeDescription other) {
        if (this == other) {
            return 0;
        }
        if (other == null) {
            return -1;
        }
        int result = this.category.compareTo(other.category);
        if (result == 0) {
            switch (this.category) {
                case CHAR: 
                case VARCHAR: {
                    return this.maxLength - other.maxLength;
                }
                case DECIMAL: {
                    if (this.precision != other.precision) {
                        return this.precision - other.precision;
                    }
                    return this.scale - other.scale;
                }
                case UNION: 
                case LIST: 
                case MAP: {
                    if (this.children.size() != other.children.size()) {
                        return this.children.size() - other.children.size();
                    }
                    for (int c = 0; result == 0 && c < this.children.size(); ++c) {
                        result = this.children.get(c).compareTo(other.children.get(c));
                    }
                    break;
                }
                case STRUCT: {
                    if (this.children.size() != other.children.size()) {
                        return this.children.size() - other.children.size();
                    }
                    for (int c = 0; result == 0 && c < this.children.size(); ++c) {
                        result = this.fieldNames.get(c).compareTo(other.fieldNames.get(c));
                        if (result != 0) continue;
                        result = this.children.get(c).compareTo(other.children.get(c));
                    }
                    break;
                }
            }
        }
        return result;
    }

    public static TypeDescription createBoolean() {
        return new TypeDescription(Category.BOOLEAN);
    }

    public static TypeDescription createByte() {
        return new TypeDescription(Category.BYTE);
    }

    public static TypeDescription createShort() {
        return new TypeDescription(Category.SHORT);
    }

    public static TypeDescription createInt() {
        return new TypeDescription(Category.INT);
    }

    public static TypeDescription createLong() {
        return new TypeDescription(Category.LONG);
    }

    public static TypeDescription createFloat() {
        return new TypeDescription(Category.FLOAT);
    }

    public static TypeDescription createDouble() {
        return new TypeDescription(Category.DOUBLE);
    }

    public static TypeDescription createString() {
        return new TypeDescription(Category.STRING);
    }

    public static TypeDescription createDate() {
        return new TypeDescription(Category.DATE);
    }

    public static TypeDescription createTimestamp() {
        return new TypeDescription(Category.TIMESTAMP);
    }

    public static TypeDescription createTimestampInstant() {
        return new TypeDescription(Category.TIMESTAMP_INSTANT);
    }

    public static TypeDescription createBinary() {
        return new TypeDescription(Category.BINARY);
    }

    public static TypeDescription createDecimal() {
        return new TypeDescription(Category.DECIMAL);
    }

    public static TypeDescription fromString(String typeName) {
        if (typeName == null) {
            return null;
        }
        ParserUtils.StringPosition source = new ParserUtils.StringPosition(typeName);
        TypeDescription result = ParserUtils.parseType(source);
        if (source.hasCharactersLeft()) {
            throw new IllegalArgumentException("Extra characters at " + source);
        }
        return result;
    }

    public TypeDescription withPrecision(int precision) {
        if (this.category != Category.DECIMAL) {
            throw new IllegalArgumentException("precision is only allowed on decimal and not " + this.category.name);
        }
        if (precision < 1 || precision > 38 || this.scale > precision) {
            throw new IllegalArgumentException("precision " + precision + " is out of range 1 .. " + this.scale);
        }
        this.precision = precision;
        return this;
    }

    public TypeDescription withScale(int scale) {
        if (this.category != Category.DECIMAL) {
            throw new IllegalArgumentException("scale is only allowed on decimal and not " + this.category.name);
        }
        if (scale < 0 || scale > 38 || scale > this.precision) {
            throw new IllegalArgumentException("scale is out of range at " + scale);
        }
        this.scale = scale;
        return this;
    }

    public TypeDescription setAttribute(@NotNull String key, @NotNull String value) {
        this.attributes.put(key, value);
        return this;
    }

    public TypeDescription removeAttribute(@NotNull String key) {
        this.attributes.remove(key);
        return this;
    }

    public static TypeDescription createVarchar() {
        return new TypeDescription(Category.VARCHAR);
    }

    public static TypeDescription createChar() {
        return new TypeDescription(Category.CHAR);
    }

    public TypeDescription withMaxLength(int maxLength) {
        if (this.category != Category.VARCHAR && this.category != Category.CHAR) {
            throw new IllegalArgumentException("maxLength is only allowed on char and varchar and not " + this.category.name);
        }
        this.maxLength = maxLength;
        return this;
    }

    public static TypeDescription createList(TypeDescription childType) {
        TypeDescription result = new TypeDescription(Category.LIST);
        result.children.add(childType);
        childType.parent = result;
        return result;
    }

    public static TypeDescription createMap(TypeDescription keyType, TypeDescription valueType) {
        TypeDescription result = new TypeDescription(Category.MAP);
        result.children.add(keyType);
        result.children.add(valueType);
        keyType.parent = result;
        valueType.parent = result;
        return result;
    }

    public static TypeDescription createUnion() {
        return new TypeDescription(Category.UNION);
    }

    public static TypeDescription createStruct() {
        return new TypeDescription(Category.STRUCT);
    }

    public TypeDescription addUnionChild(TypeDescription child) {
        if (this.category != Category.UNION) {
            throw new IllegalArgumentException("Can only add types to union type and not " + (Object)((Object)this.category));
        }
        this.addChild(child);
        return this;
    }

    public TypeDescription addField(String field, TypeDescription fieldType) {
        if (this.category != Category.STRUCT) {
            throw new IllegalArgumentException("Can only add fields to struct type and not " + (Object)((Object)this.category));
        }
        this.fieldNames.add(field);
        this.addChild(fieldType);
        return this;
    }

    public int getId() {
        if (this.id == -1) {
            TypeDescription root = this;
            while (root.parent != null) {
                root = root.parent;
            }
            root.assignIds(0);
        }
        return this.id;
    }

    public TypeDescription clone() {
        TypeDescription result = new TypeDescription(this.category);
        result.maxLength = this.maxLength;
        result.precision = this.precision;
        result.scale = this.scale;
        if (this.fieldNames != null) {
            result.fieldNames.addAll(this.fieldNames);
        }
        if (this.children != null) {
            for (TypeDescription typeDescription : this.children) {
                TypeDescription clone = typeDescription.clone();
                clone.parent = result;
                result.children.add(clone);
            }
        }
        for (Map.Entry entry : this.attributes.entrySet()) {
            result.attributes.put((String)entry.getKey(), (String)entry.getValue());
        }
        return result;
    }

    public int hashCode() {
        long result = this.category.ordinal() * 4241 + this.maxLength + this.precision * 13 + this.scale;
        if (this.children != null) {
            for (TypeDescription child : this.children) {
                result = result * 6959L + (long)child.hashCode();
            }
        }
        return (int)result;
    }

    public boolean equals(Object other) {
        return this.equals(other, true);
    }

    public boolean equals(Object other, boolean checkAttributes) {
        if (other == null || !(other instanceof TypeDescription)) {
            return false;
        }
        if (other == this) {
            return true;
        }
        TypeDescription castOther = (TypeDescription)other;
        if (this.category != castOther.category || this.maxLength != castOther.maxLength || this.scale != castOther.scale || this.precision != castOther.precision) {
            return false;
        }
        if (checkAttributes) {
            List<String> attributeNames = this.getAttributeNames();
            if (castOther.getAttributeNames().size() != attributeNames.size()) {
                return false;
            }
            for (String attribute : attributeNames) {
                if (this.getAttributeValue(attribute).equals(castOther.getAttributeValue(attribute))) continue;
                return false;
            }
        }
        if (this.children != null) {
            if (this.children.size() != castOther.children.size()) {
                return false;
            }
            for (int i = 0; i < this.children.size(); ++i) {
                if (this.children.get(i).equals(castOther.children.get(i), checkAttributes)) continue;
                return false;
            }
        }
        if (this.category == Category.STRUCT) {
            for (int i = 0; i < this.fieldNames.size(); ++i) {
                if (this.fieldNames.get(i).equals(castOther.fieldNames.get(i))) continue;
                return false;
            }
        }
        return true;
    }

    public int getMaximumId() {
        if (this.maxId == -1) {
            TypeDescription root = this;
            while (root.parent != null) {
                root = root.parent;
            }
            root.assignIds(0);
        }
        return this.maxId;
    }

    public VectorizedRowBatch createRowBatch(RowBatchVersion version, int size) {
        VectorizedRowBatch result;
        if (this.category == Category.STRUCT) {
            result = new VectorizedRowBatch(this.children.size(), size);
            for (int i = 0; i < result.cols.length; ++i) {
                result.cols[i] = TypeUtils.createColumn(this.children.get(i), version, size);
            }
        } else {
            result = new VectorizedRowBatch(1, size);
            result.cols[0] = TypeUtils.createColumn(this, version, size);
        }
        result.reset();
        return result;
    }

    public VectorizedRowBatch createRowBatchV2() {
        return this.createRowBatch(RowBatchVersion.USE_DECIMAL64, 1024);
    }

    public VectorizedRowBatch createRowBatch(int maxSize) {
        return this.createRowBatch(RowBatchVersion.ORIGINAL, maxSize);
    }

    public VectorizedRowBatch createRowBatch() {
        return this.createRowBatch(RowBatchVersion.ORIGINAL, 1024);
    }

    public Category getCategory() {
        return this.category;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    public List<String> getFieldNames() {
        return Collections.unmodifiableList(this.fieldNames);
    }

    public List<String> getAttributeNames() {
        ArrayList<String> result = new ArrayList<String>(this.attributes.size());
        result.addAll(this.attributes.keySet());
        Collections.sort(result);
        return result;
    }

    public String getAttributeValue(String attributeName) {
        return this.attributes.get(attributeName);
    }

    public TypeDescription getParent() {
        return this.parent;
    }

    public List<TypeDescription> getChildren() {
        return this.children == null ? null : Collections.unmodifiableList(this.children);
    }

    private int assignIds(int startId) {
        this.id = startId++;
        if (this.children != null) {
            for (TypeDescription child : this.children) {
                startId = child.assignIds(startId);
            }
        }
        this.maxId = startId - 1;
        return startId;
    }

    public void addChild(TypeDescription child) {
        switch (this.category) {
            case LIST: {
                if (this.children.size() >= 1) {
                    throw new IllegalArgumentException("Can't add more children to list");
                }
            }
            case MAP: {
                if (this.children.size() >= 2) {
                    throw new IllegalArgumentException("Can't add more children to map");
                }
            }
            case UNION: 
            case STRUCT: {
                this.children.add(child);
                child.parent = this;
                break;
            }
            default: {
                throw new IllegalArgumentException("Can't add children to " + (Object)((Object)this.category));
            }
        }
    }

    public TypeDescription(Category category) {
        this.category = category;
        this.children = category.isPrimitive ? null : new ArrayList<TypeDescription>();
        this.fieldNames = category == Category.STRUCT ? new ArrayList<String>() : null;
    }

    static void printFieldName(StringBuilder buffer, String name) {
        if (UNQUOTED_NAMES.matcher(name).matches()) {
            buffer.append(name);
        } else {
            buffer.append('`');
            buffer.append(name.replace("`", "``"));
            buffer.append('`');
        }
    }

    public void printToBuffer(StringBuilder buffer) {
        buffer.append(this.category.name);
        switch (this.category) {
            case DECIMAL: {
                buffer.append('(');
                buffer.append(this.precision);
                buffer.append(',');
                buffer.append(this.scale);
                buffer.append(')');
                break;
            }
            case CHAR: 
            case VARCHAR: {
                buffer.append('(');
                buffer.append(this.maxLength);
                buffer.append(')');
                break;
            }
            case UNION: 
            case LIST: 
            case MAP: {
                buffer.append('<');
                for (int i = 0; i < this.children.size(); ++i) {
                    if (i != 0) {
                        buffer.append(',');
                    }
                    this.children.get(i).printToBuffer(buffer);
                }
                buffer.append('>');
                break;
            }
            case STRUCT: {
                buffer.append('<');
                for (int i = 0; i < this.children.size(); ++i) {
                    if (i != 0) {
                        buffer.append(',');
                    }
                    TypeDescription.printFieldName(buffer, this.fieldNames.get(i));
                    buffer.append(':');
                    this.children.get(i).printToBuffer(buffer);
                }
                buffer.append('>');
                break;
            }
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.printToBuffer(buffer);
        return buffer.toString();
    }

    private void printJsonToBuffer(String prefix, StringBuilder buffer, int indent) {
        int i;
        for (i = 0; i < indent; ++i) {
            buffer.append(' ');
        }
        buffer.append(prefix);
        buffer.append("{\"category\": \"");
        buffer.append(this.category.name);
        buffer.append("\", \"id\": ");
        buffer.append(this.getId());
        buffer.append(", \"max\": ");
        buffer.append(this.maxId);
        switch (this.category) {
            case DECIMAL: {
                buffer.append(", \"precision\": ");
                buffer.append(this.precision);
                buffer.append(", \"scale\": ");
                buffer.append(this.scale);
                break;
            }
            case CHAR: 
            case VARCHAR: {
                buffer.append(", \"length\": ");
                buffer.append(this.maxLength);
                break;
            }
            case UNION: 
            case LIST: 
            case MAP: {
                buffer.append(", \"children\": [");
                for (i = 0; i < this.children.size(); ++i) {
                    buffer.append('\n');
                    this.children.get(i).printJsonToBuffer("", buffer, indent + 2);
                    if (i == this.children.size() - 1) continue;
                    buffer.append(',');
                }
                buffer.append("]");
                break;
            }
            case STRUCT: {
                buffer.append(", \"fields\": [");
                for (i = 0; i < this.children.size(); ++i) {
                    buffer.append('\n');
                    buffer.append('{');
                    this.children.get(i).printJsonToBuffer("\"" + this.fieldNames.get(i) + "\": ", buffer, indent + 2);
                    buffer.append('}');
                    if (i == this.children.size() - 1) continue;
                    buffer.append(',');
                }
                buffer.append(']');
                break;
            }
        }
        buffer.append('}');
    }

    public String toJson() {
        StringBuilder buffer = new StringBuilder();
        this.printJsonToBuffer("", buffer, 0);
        return buffer.toString();
    }

    public TypeDescription findSubtype(int goal) {
        ParserUtils.TypeFinder result = new ParserUtils.TypeFinder(this);
        ParserUtils.findSubtype(this, goal, result);
        return result.current;
    }

    public TypeDescription findSubtype(String columnName) {
        return this.findSubtype(columnName, true);
    }

    public TypeDescription findSubtype(String columnName, boolean isSchemaEvolutionCaseAware) {
        ParserUtils.StringPosition source = new ParserUtils.StringPosition(columnName);
        TypeDescription result = ParserUtils.findSubtype(this, source, isSchemaEvolutionCaseAware);
        if (source.hasCharactersLeft()) {
            throw new IllegalArgumentException("Remaining text in parsing field name " + source);
        }
        return result;
    }

    public List<TypeDescription> findSubtypes(String columnNameList) {
        ParserUtils.StringPosition source = new ParserUtils.StringPosition(columnNameList);
        List<TypeDescription> result = ParserUtils.findSubtypeList(this, source);
        if (source.hasCharactersLeft()) {
            throw new IllegalArgumentException("Remaining text in parsing field name " + source);
        }
        return result;
    }

    public void annotateEncryption(String encryption, String masks) {
        ParserUtils.StringPosition source = new ParserUtils.StringPosition(encryption);
        ParserUtils.parseKeys(source, this);
        if (source.hasCharactersLeft()) {
            throw new IllegalArgumentException("Remaining text in parsing encryption keys " + source);
        }
        source = new ParserUtils.StringPosition(masks);
        ParserUtils.parseMasks(source, this);
        if (source.hasCharactersLeft()) {
            throw new IllegalArgumentException("Remaining text in parsing encryption masks " + source);
        }
    }

    private int getChildIndex(TypeDescription child) {
        for (int i = this.children.size() - 1; i >= 0; --i) {
            if (this.children.get(i) != child) continue;
            return i;
        }
        throw new IllegalArgumentException("Child not found");
    }

    private String getPartialName(TypeDescription child) {
        switch (this.category) {
            case LIST: {
                return "_elem";
            }
            case MAP: {
                return this.getChildIndex(child) == 0 ? "_key" : "_value";
            }
            case STRUCT: {
                return this.fieldNames.get(this.getChildIndex(child));
            }
            case UNION: {
                return Integer.toString(this.getChildIndex(child));
            }
        }
        throw new IllegalArgumentException("Can't get the field name of a primitive type");
    }

    public String getFullFieldName() {
        ArrayList<String> parts = new ArrayList<String>(this.getId());
        TypeDescription current = this;
        TypeDescription parent = current.getParent();
        if (parent == null) {
            return Integer.toString(current.getId());
        }
        while (parent != null) {
            parts.add(parent.getPartialName(current));
            current = parent;
            parent = current.getParent();
        }
        StringBuilder buffer = new StringBuilder();
        for (int part = parts.size() - 1; part >= 0; --part) {
            buffer.append((String)parts.get(part));
            if (part == 0) continue;
            buffer.append('.');
        }
        return buffer.toString();
    }

    public static enum RowBatchVersion {
        ORIGINAL,
        USE_DECIMAL64;

    }

    public static enum Category {
        BOOLEAN("boolean", true),
        BYTE("tinyint", true),
        SHORT("smallint", true),
        INT("int", true),
        LONG("bigint", true),
        FLOAT("float", true),
        DOUBLE("double", true),
        STRING("string", true),
        DATE("date", true),
        TIMESTAMP("timestamp", true),
        BINARY("binary", true),
        DECIMAL("decimal", true),
        VARCHAR("varchar", true),
        CHAR("char", true),
        LIST("array", false),
        MAP("map", false),
        STRUCT("struct", false),
        UNION("uniontype", false),
        TIMESTAMP_INSTANT("timestamp with local time zone", true);

        final boolean isPrimitive;
        final String name;

        private Category(String name, boolean isPrimitive) {
            this.name = name;
            this.isPrimitive = isPrimitive;
        }

        public boolean isPrimitive() {
            return this.isPrimitive;
        }

        public String getName() {
            return this.name;
        }
    }
}

