/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.util.validation;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.JSQLParserException;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.parser.CCJSqlParserUtil;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.statement.Statements;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.util.validation.ParseException;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.util.validation.ValidationCapability;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.util.validation.ValidationContext;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.util.validation.ValidationException;

final class ParseCapability
implements ValidationCapability {
    public static final String NAME = "parsing";
    private String statements;
    private Statements parsedStatement;

    public ParseCapability(String statements) {
        this.statements = statements;
    }

    public String getStatements() {
        return this.statements;
    }

    public Statements getParsedStatements() {
        return this.parsedStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validate(ValidationContext context, Consumer<ValidationException> errorConsumer) {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        try {
            this.parsedStatement = CCJSqlParserUtil.parseStatements(CCJSqlParserUtil.newParser(this.statements).withConfiguration(context.getConfiguration()), executorService);
        }
        catch (JSQLParserException e) {
            errorConsumer.accept(new ParseException("Cannot parse statement: " + e.getMessage(), e));
        }
        finally {
            executorService.shutdown();
        }
    }

    @Override
    public String getName() {
        return NAME;
    }
}

