/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.util.deparser;

import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.expression.ExpressionVisitor;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.statement.select.LateralSubSelect;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.statement.select.Offset;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.statement.select.ParenthesedSelect;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.statement.select.PlainSelect;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.statement.select.SelectVisitor;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.statement.select.SetOperationList;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.statement.select.TableStatement;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.statement.select.Values;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.statement.select.WithItem;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.util.deparser.AbstractDeParser;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.util.deparser.LimitDeparser;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.util.deparser.OrderByDeParser;

public class TableStatementDeParser
extends AbstractDeParser<TableStatement>
implements SelectVisitor {
    private final ExpressionVisitor expressionVisitor;

    public TableStatementDeParser(ExpressionVisitor expressionVisitor, StringBuilder buffer) {
        super(buffer);
        this.expressionVisitor = expressionVisitor;
    }

    @Override
    public void deParse(TableStatement tableStatement) {
        tableStatement.accept(this);
    }

    public void visit(Offset offset) {
        this.buffer.append(" OFFSET ");
        offset.getOffset().accept(this.expressionVisitor);
        if (offset.getOffsetParam() != null) {
            this.buffer.append(" ").append(offset.getOffsetParam());
        }
    }

    @Override
    public void visit(ParenthesedSelect parenthesedSelect) {
    }

    @Override
    public void visit(PlainSelect plainSelect) {
    }

    @Override
    public void visit(SetOperationList setOpList) {
    }

    @Override
    public void visit(WithItem withItem) {
    }

    @Override
    public void visit(Values aThis) {
    }

    @Override
    public void visit(LateralSubSelect lateralSubSelect) {
    }

    @Override
    public void visit(TableStatement tableStatement) {
        this.buffer.append("TABLE ");
        this.buffer.append(tableStatement.getTable());
        if (tableStatement.getOrderByElements() != null) {
            new OrderByDeParser(this.expressionVisitor, this.buffer).deParse(tableStatement.getOrderByElements());
        }
        if (tableStatement.getLimit() != null) {
            new LimitDeparser(this.expressionVisitor, this.buffer).deParse(tableStatement.getLimit());
        }
        if (tableStatement.getOffset() != null) {
            this.visit(tableStatement.getOffset());
        }
    }
}

