/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.statement.create.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.schema.Table;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.statement.Statement;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.statement.StatementVisitor;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.statement.select.PlainSelect;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.statement.select.Select;

public class AlterView
implements Statement {
    private Table view;
    private Select select;
    private boolean useReplace = false;
    private List<String> columnNames = null;

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    public Table getView() {
        return this.view;
    }

    public void setView(Table view) {
        this.view = view;
    }

    public Select getSelect() {
        return this.select;
    }

    public void setSelect(Select select) {
        this.select = select;
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public void setColumnNames(List<String> columnNames) {
        this.columnNames = columnNames;
    }

    public boolean isUseReplace() {
        return this.useReplace;
    }

    public void setUseReplace(boolean useReplace) {
        this.useReplace = useReplace;
    }

    public String toString() {
        StringBuilder sql = this.useReplace ? new StringBuilder("REPLACE ") : new StringBuilder("ALTER ");
        sql.append("VIEW ");
        sql.append(this.view);
        if (this.columnNames != null) {
            sql.append(PlainSelect.getStringList(this.columnNames, true, true));
        }
        sql.append(" AS ").append(this.select);
        return sql.toString();
    }

    public AlterView withView(Table view) {
        this.setView(view);
        return this;
    }

    public AlterView withSelect(Select select) {
        this.setSelect(select);
        return this;
    }

    public AlterView withUseReplace(boolean useReplace) {
        this.setUseReplace(useReplace);
        return this;
    }

    public AlterView withColumnNames(List<String> columnNames) {
        this.setColumnNames(columnNames);
        return this;
    }

    public AlterView addColumnNames(String ... columnNames) {
        List collection = Optional.ofNullable(this.getColumnNames()).orElseGet(ArrayList::new);
        Collections.addAll(collection, columnNames);
        return this.withColumnNames(collection);
    }

    public AlterView addColumnNames(Collection<String> columnNames) {
        List collection = Optional.ofNullable(this.getColumnNames()).orElseGet(ArrayList::new);
        collection.addAll(columnNames);
        return this.withColumnNames(collection);
    }

    public <E extends Select> E getSelectBody(Class<E> type) {
        return (E)((Select)type.cast(this.getSelect()));
    }
}

