/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.statement.alter;

import java.util.List;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.statement.Statement;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.statement.StatementVisitor;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.statement.alter.AlterSessionOperation;

public class AlterSession
implements Statement {
    private AlterSessionOperation operation;
    private List<String> parameters;

    public AlterSession(AlterSessionOperation operation, List<String> parameters) {
        this.operation = operation;
        this.parameters = parameters;
    }

    public AlterSessionOperation getOperation() {
        return this.operation;
    }

    public void setOperation(AlterSessionOperation operation) {
        this.operation = operation;
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<String> parameters) {
        this.parameters = parameters;
    }

    private static void appendParamaters(StringBuilder builder, List<String> parameters) {
        for (String s2 : parameters) {
            builder.append(" ").append(s2);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ALTER SESSION ");
        switch (this.operation) {
            case ADVISE_COMMIT: {
                builder.append("ADVISE COMMIT");
                break;
            }
            case ADVISE_ROLLBACK: {
                builder.append("ADVISE ROLLBACK");
                break;
            }
            case ADVISE_NOTHING: {
                builder.append("ADVISE NOTHING");
                break;
            }
            case CLOSE_DATABASE_LINK: {
                builder.append("CLOSE DATABASE LINK ");
                AlterSession.appendParamaters(builder, this.parameters);
                break;
            }
            case ENABLE_COMMIT_IN_PROCEDURE: {
                builder.append("ENABLE COMMIT IN PROCEDURE");
                break;
            }
            case DISABLE_COMMIT_IN_PROCEDURE: {
                builder.append("DISABLE COMMIT IN PROCEDURE");
                break;
            }
            case ENABLE_GUARD: {
                builder.append("ENABLE GUARD");
                break;
            }
            case DISABLE_GUARD: {
                builder.append("DISABLE GUARD");
                break;
            }
            case ENABLE_PARALLEL_DML: {
                builder.append("ENABLE PARALLEL DML");
                AlterSession.appendParamaters(builder, this.parameters);
                break;
            }
            case DISABLE_PARALLEL_DML: {
                builder.append("DISABLE PARALLEL DML");
                AlterSession.appendParamaters(builder, this.parameters);
                break;
            }
            case FORCE_PARALLEL_DML: {
                builder.append("FORCE PARALLEL DML");
                AlterSession.appendParamaters(builder, this.parameters);
                break;
            }
            case ENABLE_PARALLEL_DDL: {
                builder.append("ENABLE PARALLEL DDL");
                AlterSession.appendParamaters(builder, this.parameters);
                break;
            }
            case DISABLE_PARALLEL_DDL: {
                builder.append("DISABLE PARALLEL DDL");
                break;
            }
            case FORCE_PARALLEL_DDL: {
                builder.append("FORCE PARALLEL DDL");
                AlterSession.appendParamaters(builder, this.parameters);
                break;
            }
            case ENABLE_PARALLEL_QUERY: {
                builder.append("ENABLE PARALLEL QUERY");
                AlterSession.appendParamaters(builder, this.parameters);
                break;
            }
            case DISABLE_PARALLEL_QUERY: {
                builder.append("DISABLE PARALLEL QUERY");
                break;
            }
            case FORCE_PARALLEL_QUERY: {
                builder.append("FORCE PARALLEL QUERY");
                AlterSession.appendParamaters(builder, this.parameters);
                break;
            }
            case ENABLE_RESUMABLE: {
                builder.append("ENABLE RESUMABLE");
                AlterSession.appendParamaters(builder, this.parameters);
                break;
            }
            case DISABLE_RESUMABLE: {
                builder.append("DISABLE RESUMABLE");
                break;
            }
            case SET: {
                builder.append("SET");
                AlterSession.appendParamaters(builder, this.parameters);
                break;
            }
        }
        return builder.toString();
    }

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }
}

