/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.statement;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.statement.Statement;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.statement.StatementVisitor;

public abstract class CreateFunctionalStatement
implements Statement {
    private String kind;
    private boolean orReplace = false;
    private List<String> functionDeclarationParts;

    protected CreateFunctionalStatement(String kind) {
        this.kind = kind;
    }

    protected CreateFunctionalStatement(String kind, List<String> functionDeclarationParts) {
        this(false, kind, functionDeclarationParts);
    }

    protected CreateFunctionalStatement(boolean orReplace, String kind, List<String> functionDeclarationParts) {
        this.orReplace = orReplace;
        this.kind = kind;
        this.functionDeclarationParts = functionDeclarationParts;
    }

    public void setFunctionDeclarationParts(List<String> functionDeclarationParts) {
        this.functionDeclarationParts = functionDeclarationParts;
    }

    public List<String> getFunctionDeclarationParts() {
        return this.functionDeclarationParts;
    }

    public String getKind() {
        return this.kind;
    }

    public void setOrReplace(boolean orReplace) {
        this.orReplace = orReplace;
    }

    public String formatDeclaration() {
        StringBuilder declaration = new StringBuilder();
        for (int currIndex = 0; currIndex < this.functionDeclarationParts.size(); ++currIndex) {
            String nextToken;
            String token = this.functionDeclarationParts.get(currIndex);
            declaration.append(token);
            if (currIndex + 1 >= this.functionDeclarationParts.size() || (nextToken = this.functionDeclarationParts.get(currIndex + 1)).equals(";")) continue;
            declaration.append(" ");
        }
        return declaration.toString();
    }

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    public String toString() {
        return "CREATE " + (this.orReplace ? "OR REPLACE " : "") + this.kind + " " + this.formatDeclaration();
    }

    public CreateFunctionalStatement withFunctionDeclarationParts(List<String> functionDeclarationParts) {
        this.setFunctionDeclarationParts(functionDeclarationParts);
        return this;
    }

    public CreateFunctionalStatement addFunctionDeclarationParts(String ... functionDeclarationParts) {
        List collection = Optional.ofNullable(this.getFunctionDeclarationParts()).orElseGet(ArrayList::new);
        Collections.addAll(collection, functionDeclarationParts);
        return this.withFunctionDeclarationParts(collection);
    }

    public CreateFunctionalStatement addFunctionDeclarationParts(Collection<String> functionDeclarationParts) {
        List collection = Optional.ofNullable(this.getFunctionDeclarationParts()).orElseGet(ArrayList::new);
        collection.addAll(functionDeclarationParts);
        return this.withFunctionDeclarationParts(collection);
    }
}

