/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.expression;

import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.expression.Expression;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.expression.ExpressionVisitor;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.parser.ASTNodeAccessImpl;

public class NotExpression
extends ASTNodeAccessImpl
implements Expression {
    private Expression expression;
    private boolean exclamationMark = false;

    public NotExpression() {
    }

    public NotExpression(Expression expression) {
        this(expression, false);
    }

    public NotExpression(Expression expression, boolean useExclamationMark) {
        this.setExpression(expression);
        this.exclamationMark = useExclamationMark;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public final void setExpression(Expression expression) {
        this.expression = expression;
    }

    @Override
    public void accept(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }

    public String toString() {
        return (this.exclamationMark ? "! " : "NOT ") + this.expression.toString();
    }

    public boolean isExclamationMark() {
        return this.exclamationMark;
    }

    public void setExclamationMark(boolean exclamationMark) {
        this.exclamationMark = exclamationMark;
    }

    public NotExpression withExpression(Expression expression) {
        this.setExpression(expression);
        return this;
    }

    public NotExpression withExclamationMark(boolean exclamationMark) {
        this.setExclamationMark(exclamationMark);
        return this;
    }

    public <E extends Expression> E getExpression(Class<E> type) {
        return (E)((Expression)type.cast(this.getExpression()));
    }
}

