/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.iceberg.utils;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iceberg.Schema;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.DateTimeUtil;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.JSQLParserException;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.expression.DoubleValue;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.expression.Expression;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.expression.LongValue;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.expression.Parenthesis;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.expression.StringValue;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.expression.operators.relational.GreaterThan;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.expression.operators.relational.GreaterThanEquals;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.expression.operators.relational.InExpression;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.expression.operators.relational.IsBooleanExpression;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.expression.operators.relational.IsNullExpression;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.expression.operators.relational.MinorThan;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.expression.operators.relational.MinorThanEquals;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.expression.operators.relational.NotEqualsTo;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.parser.CCJSqlParserUtil;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.schema.Column;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.statement.Statement;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.statement.delete.Delete;

public class ExpressionUtils {
    private static final DateTimeFormatter LOCAL_DATE_TIME_FORMATTER = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral(' ').append(DateTimeFormatter.ISO_LOCAL_TIME).toFormatter();

    public static org.apache.iceberg.expressions.Expression convertDeleteSQL(String sql) throws JSQLParserException {
        Statement statement = CCJSqlParserUtil.parse(sql);
        Delete delete = (Delete)statement;
        return ExpressionUtils.convert(delete.getWhere(), null);
    }

    public static org.apache.iceberg.expressions.Expression convert(Expression condition) {
        return ExpressionUtils.convert(condition, null);
    }

    public static org.apache.iceberg.expressions.Expression convert(Expression condition, Schema schema) {
        if (condition == null) {
            return Expressions.alwaysTrue();
        }
        if (condition instanceof AndExpression) {
            return Expressions.and(ExpressionUtils.convert(((AndExpression)condition).getLeftExpression(), schema), ExpressionUtils.convert(((AndExpression)condition).getRightExpression(), schema));
        }
        if (condition instanceof OrExpression) {
            return Expressions.or(ExpressionUtils.convert(((OrExpression)condition).getLeftExpression(), schema), ExpressionUtils.convert(((OrExpression)condition).getRightExpression(), schema));
        }
        if (condition instanceof Parenthesis) {
            return ExpressionUtils.convert(((Parenthesis)condition).getExpression(), schema);
        }
        if (condition instanceof EqualsTo) {
            EqualsTo equalsTo = (EqualsTo)condition;
            Column column = (Column)equalsTo.getLeftExpression();
            Object value = schema == null ? ExpressionUtils.convertValueExpression(equalsTo.getRightExpression()) : ExpressionUtils.convertValueExpression(equalsTo.getRightExpression(), schema.findField(column.getColumnName()));
            return Expressions.equal(column.getColumnName(), value);
        }
        if (condition instanceof NotEqualsTo) {
            NotEqualsTo notEqualsTo = (NotEqualsTo)condition;
            Column column = (Column)notEqualsTo.getLeftExpression();
            Object value = schema == null ? ExpressionUtils.convertValueExpression(notEqualsTo.getRightExpression()) : ExpressionUtils.convertValueExpression(notEqualsTo.getRightExpression(), schema.findField(column.getColumnName()));
            return Expressions.notEqual(column.getColumnName(), value);
        }
        if (condition instanceof GreaterThan) {
            GreaterThan greaterThan = (GreaterThan)condition;
            Column column = (Column)greaterThan.getLeftExpression();
            Object value = schema == null ? ExpressionUtils.convertValueExpression(greaterThan.getRightExpression()) : ExpressionUtils.convertValueExpression(greaterThan.getRightExpression(), schema.findField(column.getColumnName()));
            return Expressions.greaterThan(column.getColumnName(), value);
        }
        if (condition instanceof GreaterThanEquals) {
            GreaterThanEquals greaterThanEquals = (GreaterThanEquals)condition;
            Column column = (Column)greaterThanEquals.getLeftExpression();
            Object value = schema == null ? ExpressionUtils.convertValueExpression(greaterThanEquals.getRightExpression()) : ExpressionUtils.convertValueExpression(greaterThanEquals.getRightExpression(), schema.findField(column.getColumnName()));
            return Expressions.greaterThanOrEqual(column.getColumnName(), value);
        }
        if (condition instanceof MinorThan) {
            MinorThan minorThan = (MinorThan)condition;
            Column column = (Column)minorThan.getLeftExpression();
            Object value = schema == null ? ExpressionUtils.convertValueExpression(minorThan.getRightExpression()) : ExpressionUtils.convertValueExpression(minorThan.getRightExpression(), schema.findField(column.getColumnName()));
            return Expressions.lessThan(column.getColumnName(), value);
        }
        if (condition instanceof MinorThanEquals) {
            MinorThanEquals minorThanEquals = (MinorThanEquals)condition;
            Column column = (Column)minorThanEquals.getLeftExpression();
            Object value = schema == null ? ExpressionUtils.convertValueExpression(minorThanEquals.getRightExpression()) : ExpressionUtils.convertValueExpression(minorThanEquals.getRightExpression(), schema.findField(column.getColumnName()));
            return Expressions.lessThanOrEqual(column.getColumnName(), value);
        }
        if (condition instanceof IsNullExpression) {
            IsNullExpression isNullExpression = (IsNullExpression)condition;
            Column column = (Column)isNullExpression.getLeftExpression();
            if (isNullExpression.isNot()) {
                return Expressions.notNull(column.getColumnName());
            }
            return Expressions.isNull(column.getColumnName());
        }
        if (condition instanceof InExpression) {
            InExpression inExpression = (InExpression)condition;
            Column column = (Column)inExpression.getLeftExpression();
            ExpressionList itemsList = (ExpressionList)inExpression.getRightExpression();
            List values = itemsList.getExpressions().stream().map(e -> schema == null ? ExpressionUtils.convertValueExpression(e) : ExpressionUtils.convertValueExpression(e, schema.findField(column.getColumnName()))).collect(Collectors.toList());
            if (inExpression.isNot()) {
                return Expressions.notIn(column.getColumnName(), values);
            }
            return Expressions.in(column.getColumnName(), values);
        }
        if (condition instanceof IsBooleanExpression) {
            IsBooleanExpression booleanExpression = (IsBooleanExpression)condition;
            Column column = (Column)booleanExpression.getLeftExpression();
            if (booleanExpression.isNot()) {
                return Expressions.notEqual(column.getColumnName(), Boolean.valueOf(booleanExpression.isTrue()));
            }
            return Expressions.equal(column.getColumnName(), Boolean.valueOf(booleanExpression.isTrue()));
        }
        throw new UnsupportedOperationException("Unsupported condition: " + condition.getClass().getName());
    }

    private static Object convertValueExpression(Expression valueExpression, Types.NestedField icebergColumn) {
        switch (icebergColumn.type().typeId()) {
            case DECIMAL: {
                return new BigDecimal(valueExpression.toString());
            }
            case DATE: {
                if (valueExpression instanceof StringValue) {
                    LocalDate date = LocalDate.parse(((StringValue)valueExpression).getValue(), DateTimeFormatter.ISO_LOCAL_DATE);
                    return DateTimeUtil.daysFromDate(date);
                }
            }
            case TIME: {
                if (valueExpression instanceof StringValue) {
                    LocalTime time = LocalTime.parse(((StringValue)valueExpression).getValue(), DateTimeFormatter.ISO_LOCAL_TIME);
                    return DateTimeUtil.microsFromTime(time);
                }
            }
            case TIMESTAMP: {
                if (!(valueExpression instanceof StringValue)) break;
                LocalDateTime dateTime = LocalDateTime.parse(((StringValue)valueExpression).getValue(), LOCAL_DATE_TIME_FORMATTER);
                return DateTimeUtil.microsFromTimestamp(dateTime);
            }
        }
        return ExpressionUtils.convertValueExpression(valueExpression);
    }

    private static Object convertValueExpression(Expression valueExpression) {
        if (valueExpression instanceof LongValue) {
            return ((LongValue)valueExpression).getValue();
        }
        if (valueExpression instanceof DoubleValue) {
            return ((DoubleValue)valueExpression).getValue();
        }
        if (valueExpression instanceof StringValue) {
            return ((StringValue)valueExpression).getValue();
        }
        return valueExpression.toString();
    }
}

