/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.iceberg.source.enumerator.scan;

import org.apache.iceberg.Schema;
import org.apache.iceberg.expressions.Expression;
import org.apache.seatunnel.connectors.seatunnel.iceberg.config.SourceConfig;
import org.apache.seatunnel.connectors.seatunnel.iceberg.source.enumerator.scan.IcebergStreamScanStrategy;

public class IcebergScanContext {
    private final boolean streaming;
    private final IcebergStreamScanStrategy streamScanStrategy;
    private final Long startSnapshotId;
    private final Long startSnapshotTimestamp;
    private final Long endSnapshotId;
    private final Long useSnapshotId;
    private final Long useSnapshotTimestamp;
    private final boolean caseSensitive;
    private final Schema schema;
    private final Expression filter;
    private final Long splitSize;
    private final Integer splitLookback;
    private final Long splitOpenFileCost;

    public IcebergScanContext copyWithAppendsBetween(Long newStartSnapshotId, long newEndSnapshotId) {
        return this.toBuilder().useSnapshotId(null).useSnapshotTimestamp(null).startSnapshotId(newStartSnapshotId).endSnapshotId(newEndSnapshotId).build();
    }

    public static IcebergScanContext scanContext(SourceConfig sourceConfig, Schema schema) {
        return IcebergScanContext.builder().startSnapshotTimestamp(sourceConfig.getStartSnapshotTimestamp()).startSnapshotId(sourceConfig.getStartSnapshotId()).endSnapshotId(sourceConfig.getEndSnapshotId()).useSnapshotId(sourceConfig.getUseSnapshotId()).useSnapshotTimestamp(sourceConfig.getUseSnapshotTimestamp()).caseSensitive(sourceConfig.isCaseSensitive()).schema(schema).filter(sourceConfig.getFilter()).splitSize(sourceConfig.getSplitSize()).splitLookback(sourceConfig.getSplitLookback()).splitOpenFileCost(sourceConfig.getSplitOpenFileCost()).build();
    }

    public static IcebergScanContext streamScanContext(SourceConfig sourceConfig, Schema schema) {
        return IcebergScanContext.scanContext(sourceConfig, schema).toBuilder().streaming(true).streamScanStrategy(sourceConfig.getStreamScanStrategy()).build();
    }

    IcebergScanContext(boolean streaming, IcebergStreamScanStrategy streamScanStrategy, Long startSnapshotId, Long startSnapshotTimestamp, Long endSnapshotId, Long useSnapshotId, Long useSnapshotTimestamp, boolean caseSensitive, Schema schema, Expression filter, Long splitSize, Integer splitLookback, Long splitOpenFileCost) {
        this.streaming = streaming;
        this.streamScanStrategy = streamScanStrategy;
        this.startSnapshotId = startSnapshotId;
        this.startSnapshotTimestamp = startSnapshotTimestamp;
        this.endSnapshotId = endSnapshotId;
        this.useSnapshotId = useSnapshotId;
        this.useSnapshotTimestamp = useSnapshotTimestamp;
        this.caseSensitive = caseSensitive;
        this.schema = schema;
        this.filter = filter;
        this.splitSize = splitSize;
        this.splitLookback = splitLookback;
        this.splitOpenFileCost = splitOpenFileCost;
    }

    public static IcebergScanContextBuilder builder() {
        return new IcebergScanContextBuilder();
    }

    public IcebergScanContextBuilder toBuilder() {
        return new IcebergScanContextBuilder().streaming(this.streaming).streamScanStrategy(this.streamScanStrategy).startSnapshotId(this.startSnapshotId).startSnapshotTimestamp(this.startSnapshotTimestamp).endSnapshotId(this.endSnapshotId).useSnapshotId(this.useSnapshotId).useSnapshotTimestamp(this.useSnapshotTimestamp).caseSensitive(this.caseSensitive).schema(this.schema).filter(this.filter).splitSize(this.splitSize).splitLookback(this.splitLookback).splitOpenFileCost(this.splitOpenFileCost);
    }

    public boolean isStreaming() {
        return this.streaming;
    }

    public IcebergStreamScanStrategy getStreamScanStrategy() {
        return this.streamScanStrategy;
    }

    public Long getStartSnapshotId() {
        return this.startSnapshotId;
    }

    public Long getStartSnapshotTimestamp() {
        return this.startSnapshotTimestamp;
    }

    public Long getEndSnapshotId() {
        return this.endSnapshotId;
    }

    public Long getUseSnapshotId() {
        return this.useSnapshotId;
    }

    public Long getUseSnapshotTimestamp() {
        return this.useSnapshotTimestamp;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public Expression getFilter() {
        return this.filter;
    }

    public Long getSplitSize() {
        return this.splitSize;
    }

    public Integer getSplitLookback() {
        return this.splitLookback;
    }

    public Long getSplitOpenFileCost() {
        return this.splitOpenFileCost;
    }

    public String toString() {
        return "IcebergScanContext(streaming=" + this.isStreaming() + ", streamScanStrategy=" + (Object)((Object)this.getStreamScanStrategy()) + ", startSnapshotId=" + this.getStartSnapshotId() + ", startSnapshotTimestamp=" + this.getStartSnapshotTimestamp() + ", endSnapshotId=" + this.getEndSnapshotId() + ", useSnapshotId=" + this.getUseSnapshotId() + ", useSnapshotTimestamp=" + this.getUseSnapshotTimestamp() + ", caseSensitive=" + this.isCaseSensitive() + ", schema=" + this.getSchema() + ", filter=" + this.getFilter() + ", splitSize=" + this.getSplitSize() + ", splitLookback=" + this.getSplitLookback() + ", splitOpenFileCost=" + this.getSplitOpenFileCost() + ")";
    }

    public static class IcebergScanContextBuilder {
        private boolean streaming;
        private IcebergStreamScanStrategy streamScanStrategy;
        private Long startSnapshotId;
        private Long startSnapshotTimestamp;
        private Long endSnapshotId;
        private Long useSnapshotId;
        private Long useSnapshotTimestamp;
        private boolean caseSensitive;
        private Schema schema;
        private Expression filter;
        private Long splitSize;
        private Integer splitLookback;
        private Long splitOpenFileCost;

        IcebergScanContextBuilder() {
        }

        public IcebergScanContextBuilder streaming(boolean streaming) {
            this.streaming = streaming;
            return this;
        }

        public IcebergScanContextBuilder streamScanStrategy(IcebergStreamScanStrategy streamScanStrategy) {
            this.streamScanStrategy = streamScanStrategy;
            return this;
        }

        public IcebergScanContextBuilder startSnapshotId(Long startSnapshotId) {
            this.startSnapshotId = startSnapshotId;
            return this;
        }

        public IcebergScanContextBuilder startSnapshotTimestamp(Long startSnapshotTimestamp) {
            this.startSnapshotTimestamp = startSnapshotTimestamp;
            return this;
        }

        public IcebergScanContextBuilder endSnapshotId(Long endSnapshotId) {
            this.endSnapshotId = endSnapshotId;
            return this;
        }

        public IcebergScanContextBuilder useSnapshotId(Long useSnapshotId) {
            this.useSnapshotId = useSnapshotId;
            return this;
        }

        public IcebergScanContextBuilder useSnapshotTimestamp(Long useSnapshotTimestamp) {
            this.useSnapshotTimestamp = useSnapshotTimestamp;
            return this;
        }

        public IcebergScanContextBuilder caseSensitive(boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
            return this;
        }

        public IcebergScanContextBuilder schema(Schema schema) {
            this.schema = schema;
            return this;
        }

        public IcebergScanContextBuilder filter(Expression filter) {
            this.filter = filter;
            return this;
        }

        public IcebergScanContextBuilder splitSize(Long splitSize) {
            this.splitSize = splitSize;
            return this;
        }

        public IcebergScanContextBuilder splitLookback(Integer splitLookback) {
            this.splitLookback = splitLookback;
            return this;
        }

        public IcebergScanContextBuilder splitOpenFileCost(Long splitOpenFileCost) {
            this.splitOpenFileCost = splitOpenFileCost;
            return this;
        }

        public IcebergScanContext build() {
            return new IcebergScanContext(this.streaming, this.streamScanStrategy, this.startSnapshotId, this.startSnapshotTimestamp, this.endSnapshotId, this.useSnapshotId, this.useSnapshotTimestamp, this.caseSensitive, this.schema, this.filter, this.splitSize, this.splitLookback, this.splitOpenFileCost);
        }

        public String toString() {
            return "IcebergScanContext.IcebergScanContextBuilder(streaming=" + this.streaming + ", streamScanStrategy=" + (Object)((Object)this.streamScanStrategy) + ", startSnapshotId=" + this.startSnapshotId + ", startSnapshotTimestamp=" + this.startSnapshotTimestamp + ", endSnapshotId=" + this.endSnapshotId + ", useSnapshotId=" + this.useSnapshotId + ", useSnapshotTimestamp=" + this.useSnapshotTimestamp + ", caseSensitive=" + this.caseSensitive + ", schema=" + this.schema + ", filter=" + this.filter + ", splitSize=" + this.splitSize + ", splitLookback=" + this.splitLookback + ", splitOpenFileCost=" + this.splitOpenFileCost + ")";
        }
    }
}

