/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.iceberg.source.enumerator;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import lombok.NonNull;
import org.apache.iceberg.Table;
import org.apache.seatunnel.api.source.SourceSplitEnumerator;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.connectors.seatunnel.iceberg.config.SourceConfig;
import org.apache.seatunnel.connectors.seatunnel.iceberg.source.enumerator.AbstractSplitEnumerator;
import org.apache.seatunnel.connectors.seatunnel.iceberg.source.enumerator.IcebergSplitEnumeratorState;
import org.apache.seatunnel.connectors.seatunnel.iceberg.source.enumerator.scan.IcebergScanContext;
import org.apache.seatunnel.connectors.seatunnel.iceberg.source.enumerator.scan.IcebergScanSplitPlanner;
import org.apache.seatunnel.connectors.seatunnel.iceberg.source.split.IcebergFileScanTaskSplit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcebergBatchSplitEnumerator
extends AbstractSplitEnumerator {
    private static final Logger log = LoggerFactory.getLogger(IcebergBatchSplitEnumerator.class);
    private final IcebergScanContext icebergScanContext;

    public IcebergBatchSplitEnumerator(@NonNull SourceSplitEnumerator.Context<IcebergFileScanTaskSplit> context, @NonNull IcebergScanContext icebergScanContext, @NonNull SourceConfig sourceConfig, IcebergSplitEnumeratorState restoreState, CatalogTable catalogTable) {
        super(context, sourceConfig, restoreState != null ? restoreState.getPendingSplits() : Collections.emptyMap(), catalogTable);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (icebergScanContext == null) {
            throw new NullPointerException("icebergScanContext is marked non-null but is null");
        }
        if (sourceConfig == null) {
            throw new NullPointerException("sourceConfig is marked non-null but is null");
        }
        this.icebergScanContext = icebergScanContext;
    }

    @Override
    public void run() {
        super.run();
        Set readers = this.context.registeredReaders();
        log.debug("No more splits to assign. Sending NoMoreSplitsEvent to reader {}.", (Object)readers);
        readers.forEach(arg_0 -> ((SourceSplitEnumerator.Context)this.context).signalNoMoreSplits(arg_0));
    }

    public IcebergSplitEnumeratorState snapshotState(long checkpointId) {
        return new IcebergSplitEnumeratorState(null, this.pendingSplits);
    }

    public void handleSplitRequest(int subtaskId) {
    }

    @Override
    protected List<IcebergFileScanTaskSplit> loadNewSplits(Table table) {
        return IcebergScanSplitPlanner.planSplits(table, this.icebergScanContext);
    }
}

