/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.iceberg.sink.schema;

import java.util.Collection;
import java.util.Map;
import org.apache.iceberg.types.Type;
import org.apache.seatunnel.connectors.seatunnel.iceberg.sink.schema.SchemaAddColumn;
import org.apache.seatunnel.connectors.seatunnel.iceberg.sink.schema.SchemaChangeColumn;
import org.apache.seatunnel.connectors.seatunnel.iceberg.sink.schema.SchemaDeleteColumn;
import org.apache.seatunnel.connectors.seatunnel.iceberg.sink.schema.SchemaModifyColumn;
import org.apache.seatunnel.shade.com.google.common.collect.Maps;

public class SchemaChangeWrapper {
    private final Map<String, SchemaAddColumn> addColumns = Maps.newHashMap();
    private final Map<String, SchemaDeleteColumn> deleteColumns = Maps.newHashMap();
    private final Map<String, SchemaModifyColumn> modifyColumns = Maps.newHashMap();
    private final Map<String, SchemaChangeColumn> changeColumns = Maps.newHashMap();

    public Collection<SchemaAddColumn> addColumns() {
        return this.addColumns.values();
    }

    public Collection<SchemaModifyColumn> modifyColumns() {
        return this.modifyColumns.values();
    }

    public Collection<SchemaDeleteColumn> deleteColumns() {
        return this.deleteColumns.values();
    }

    public Collection<SchemaChangeColumn> changeColumns() {
        return this.changeColumns.values();
    }

    public boolean empty() {
        return this.addColumns.isEmpty() && this.modifyColumns.isEmpty() && this.deleteColumns.isEmpty() && this.changeColumns.isEmpty();
    }

    public void addColumn(String parentName, String name, Type type) {
        SchemaAddColumn addCol = new SchemaAddColumn(parentName, name, type);
        this.addColumns.put(addCol.key(), addCol);
    }

    public void modifyColumn(String name, Type.PrimitiveType type) {
        this.modifyColumns.put(name, new SchemaModifyColumn(name, type));
    }

    public void deleteColumn(String name) {
        this.deleteColumns.put(name, new SchemaDeleteColumn(name));
    }

    public void changeColumn(String oldName, String newName) {
        this.changeColumns.put(newName, new SchemaChangeColumn(oldName, newName));
    }
}

