/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.iceberg;

import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.iceberg.CachingCatalog;
import org.apache.iceberg.Table;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.connectors.seatunnel.iceberg.IcebergCatalogLoader;
import org.apache.seatunnel.connectors.seatunnel.iceberg.config.CommonConfig;
import org.apache.seatunnel.shade.com.google.common.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcebergTableLoader
implements Closeable,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(IcebergTableLoader.class);
    private static final long serialVersionUID = 9061073826700804273L;
    private final IcebergCatalogLoader icebergCatalogFactory;
    private final String tableIdentifierStr;
    private transient Catalog catalog;

    public IcebergTableLoader(@NonNull IcebergCatalogLoader icebergCatalogFactory, @NonNull TableIdentifier tableIdentifier) {
        if (icebergCatalogFactory == null) {
            throw new NullPointerException("icebergCatalogFactory is marked non-null but is null");
        }
        if (tableIdentifier == null) {
            throw new NullPointerException("tableIdentifier is marked non-null but is null");
        }
        this.icebergCatalogFactory = icebergCatalogFactory;
        this.tableIdentifierStr = tableIdentifier.toString();
    }

    public Catalog getCatalog() {
        return this.catalog;
    }

    public TableIdentifier getTableIdentifier() {
        return TableIdentifier.parse(this.tableIdentifierStr);
    }

    public IcebergTableLoader open() {
        this.catalog = CachingCatalog.wrap(this.icebergCatalogFactory.loadCatalog());
        return this;
    }

    public Table loadTable() {
        TableIdentifier tableIdentifier = TableIdentifier.parse(this.tableIdentifierStr);
        if (this.catalog == null) {
            this.open();
        }
        return this.catalog.loadTable(tableIdentifier);
    }

    @Override
    public void close() throws IOException {
        if (this.catalog != null && this.catalog instanceof Closeable) {
            ((Closeable)((Object)this.catalog)).close();
        }
    }

    @VisibleForTesting
    public static IcebergTableLoader create(CommonConfig config) {
        return IcebergTableLoader.create(config, null);
    }

    public static IcebergTableLoader create(CommonConfig config, CatalogTable catalogTable) {
        String table;
        IcebergCatalogLoader catalogFactory = new IcebergCatalogLoader(config);
        if (Objects.nonNull(catalogTable) && StringUtils.isNotEmpty(catalogTable.getTableId().getTableName())) {
            log.info("Config table name is empty, use catalog table name: {}", (Object)catalogTable.getTableId().getTableName());
            table = catalogTable.getTableId().getTableName();
        } else if (StringUtils.isNotEmpty(config.getTable())) {
            table = config.getTable();
        } else {
            throw new IllegalArgumentException("Table name is empty");
        }
        return new IcebergTableLoader(catalogFactory, TableIdentifier.of(Namespace.of(config.getNamespace()), table));
    }
}

