/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.transforms;

import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.UUID;
import org.apache.iceberg.expressions.BoundPredicate;
import org.apache.iceberg.expressions.BoundTerm;
import org.apache.iceberg.expressions.BoundTransform;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.UnboundPredicate;
import org.apache.iceberg.relocated.com.google.common.base.Objects;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.transforms.ProjectionUtil;
import org.apache.iceberg.transforms.Transform;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.BucketUtil;
import org.apache.iceberg.util.SerializableFunction;

class Bucket<T>
implements Transform<T, Integer>,
Serializable {
    private final int numBuckets;

    static <T> Bucket<T> get(int numBuckets) {
        Preconditions.checkArgument(numBuckets > 0, "Invalid number of buckets: %s (must be > 0)", numBuckets);
        return new Bucket<T>(numBuckets);
    }

    static <T, B extends Bucket<T>> B get(Type type, int numBuckets) {
        Preconditions.checkArgument(numBuckets > 0, "Invalid number of buckets: %s (must be > 0)", numBuckets);
        switch (type.typeId()) {
            case DATE: 
            case INTEGER: {
                return (B)new BucketInteger(numBuckets);
            }
            case TIME: 
            case TIMESTAMP: 
            case LONG: {
                return (B)new BucketLong(numBuckets);
            }
            case DECIMAL: {
                return (B)new BucketDecimal(numBuckets);
            }
            case STRING: {
                return (B)new BucketString(numBuckets);
            }
            case FIXED: 
            case BINARY: {
                return (B)new BucketByteBuffer(numBuckets);
            }
            case UUID: {
                return (B)new BucketUUID(numBuckets);
            }
        }
        throw new IllegalArgumentException("Cannot bucket by type: " + type);
    }

    private Bucket(int numBuckets) {
        this.numBuckets = numBuckets;
    }

    public Integer numBuckets() {
        return this.numBuckets;
    }

    @Override
    public SerializableFunction<T, Integer> bind(Type type) {
        Preconditions.checkArgument(this.canTransform(type), "Cannot bucket by type: %s", (Object)type);
        return (SerializableFunction)Bucket.get(type, this.numBuckets);
    }

    protected int hash(T value) {
        throw new UnsupportedOperationException("hash(value) is not supported on the base Bucket class");
    }

    @Override
    public Integer apply(T value) {
        if (value == null) {
            return null;
        }
        return (this.hash(value) & Integer.MAX_VALUE) % this.numBuckets;
    }

    @Override
    public boolean canTransform(Type type) {
        switch (type.typeId()) {
            case DATE: 
            case INTEGER: 
            case TIME: 
            case TIMESTAMP: 
            case LONG: 
            case DECIMAL: 
            case STRING: 
            case FIXED: 
            case BINARY: 
            case UUID: {
                return true;
            }
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Bucket)) {
            return false;
        }
        Bucket bucket = (Bucket)o;
        return this.numBuckets == bucket.numBuckets;
    }

    public int hashCode() {
        return Objects.hashCode(this.numBuckets);
    }

    public String toString() {
        return "bucket[" + this.numBuckets + "]";
    }

    @Override
    public UnboundPredicate<Integer> project(String name, BoundPredicate<T> predicate) {
        SerializableFunction<T, Integer> function = this.bind(((BoundTerm)predicate.term()).type());
        if (predicate.term() instanceof BoundTransform) {
            return ProjectionUtil.projectTransformPredicate(this, name, predicate);
        }
        if (predicate.isUnaryPredicate()) {
            return Expressions.predicate(predicate.op(), name);
        }
        if (predicate.isLiteralPredicate() && predicate.op() == Expression.Operation.EQ) {
            return Expressions.predicate(predicate.op(), name, (Integer)function.apply((Integer)predicate.asLiteralPredicate().literal().value()));
        }
        if (predicate.isSetPredicate() && predicate.op() == Expression.Operation.IN) {
            return ProjectionUtil.transformSet(name, predicate.asSetPredicate(), function);
        }
        return null;
    }

    @Override
    public UnboundPredicate<Integer> projectStrict(String name, BoundPredicate<T> predicate) {
        SerializableFunction<T, Integer> function = this.bind(((BoundTerm)predicate.term()).type());
        if (predicate.term() instanceof BoundTransform) {
            return ProjectionUtil.projectTransformPredicate(this, name, predicate);
        }
        if (predicate.isUnaryPredicate()) {
            return Expressions.predicate(predicate.op(), name);
        }
        if (predicate.isLiteralPredicate() && predicate.op() == Expression.Operation.NOT_EQ) {
            return Expressions.predicate(predicate.op(), name, (Integer)function.apply((Integer)predicate.asLiteralPredicate().literal().value()));
        }
        if (predicate.isSetPredicate() && predicate.op() == Expression.Operation.NOT_IN) {
            return ProjectionUtil.transformSet(name, predicate.asSetPredicate(), function);
        }
        return null;
    }

    @Override
    public Type getResultType(Type sourceType) {
        return Types.IntegerType.get();
    }

    private static class BucketDecimal
    extends Bucket<BigDecimal>
    implements SerializableFunction<BigDecimal, Integer> {
        private BucketDecimal(int numBuckets) {
            super(numBuckets);
        }

        @Override
        protected int hash(BigDecimal value) {
            return BucketUtil.hash(value);
        }
    }

    private static class BucketUUID
    extends Bucket<UUID>
    implements SerializableFunction<UUID, Integer> {
        private BucketUUID(int numBuckets) {
            super(numBuckets);
        }

        @Override
        public int hash(UUID value) {
            return BucketUtil.hash(value);
        }
    }

    private static class BucketByteBuffer
    extends Bucket<ByteBuffer>
    implements SerializableFunction<ByteBuffer, Integer> {
        private BucketByteBuffer(int numBuckets) {
            super(numBuckets);
        }

        @Override
        protected int hash(ByteBuffer value) {
            return BucketUtil.hash(value);
        }
    }

    private static class BucketString
    extends Bucket<CharSequence>
    implements SerializableFunction<CharSequence, Integer> {
        private BucketString(int numBuckets) {
            super(numBuckets);
        }

        @Override
        protected int hash(CharSequence value) {
            return BucketUtil.hash(value);
        }
    }

    private static class BucketLong
    extends Bucket<Long>
    implements SerializableFunction<Long, Integer> {
        private BucketLong(int numBuckets) {
            super(numBuckets);
        }

        @Override
        protected int hash(Long value) {
            return BucketUtil.hash(value);
        }
    }

    private static class BucketInteger
    extends Bucket<Integer>
    implements SerializableFunction<Integer, Integer> {
        private BucketInteger(int numBuckets) {
            super(numBuckets);
        }

        @Override
        protected int hash(Integer value) {
            return BucketUtil.hash(value);
        }
    }
}

