/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest.responses;

import java.util.Collection;
import java.util.List;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.rest.RESTResponse;

public class UpdateNamespacePropertiesResponse
implements RESTResponse {
    private List<String> removed;
    private List<String> updated;
    private List<String> missing;

    public UpdateNamespacePropertiesResponse() {
    }

    private UpdateNamespacePropertiesResponse(List<String> removed, List<String> updated, List<String> missing) {
        this.removed = removed;
        this.updated = updated;
        this.missing = missing;
        this.validate();
    }

    @Override
    public void validate() {
    }

    public List<String> removed() {
        return this.removed != null ? this.removed : ImmutableList.of();
    }

    public List<String> updated() {
        return this.updated != null ? this.updated : ImmutableList.of();
    }

    public List<String> missing() {
        return this.missing != null ? this.missing : ImmutableList.of();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("removed", this.removed).add("updates", this.updated).add("missing", this.missing).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final ImmutableSet.Builder<String> removedBuilder = ImmutableSet.builder();
        private final ImmutableSet.Builder<String> updatedBuilder = ImmutableSet.builder();
        private final ImmutableSet.Builder<String> missingBuilder = ImmutableSet.builder();

        private Builder() {
        }

        public Builder addMissing(String key) {
            Preconditions.checkNotNull(key, "Invalid missing property: null");
            this.missingBuilder.add((Object)key);
            return this;
        }

        public Builder addMissing(Collection<String> missing) {
            Preconditions.checkNotNull(missing, "Invalid missing property list: null");
            Preconditions.checkArgument(!missing.contains(null), "Invalid missing property: null");
            this.missingBuilder.addAll(missing);
            return this;
        }

        public Builder addRemoved(String key) {
            Preconditions.checkNotNull(key, "Invalid removed property: null");
            this.removedBuilder.add((Object)key);
            return this;
        }

        public Builder addRemoved(Collection<String> removed) {
            Preconditions.checkNotNull(removed, "Invalid removed property list: null");
            Preconditions.checkArgument(!removed.contains(null), "Invalid removed property: null");
            this.removedBuilder.addAll(removed);
            return this;
        }

        public Builder addUpdated(String key) {
            Preconditions.checkNotNull(key, "Invalid updated property: null");
            this.updatedBuilder.add((Object)key);
            return this;
        }

        public Builder addUpdated(Collection<String> updated) {
            Preconditions.checkNotNull(updated, "Invalid updated property list: null");
            Preconditions.checkArgument(!updated.contains(null), "Invalid updated property: null");
            this.updatedBuilder.addAll(updated);
            return this;
        }

        public UpdateNamespacePropertiesResponse build() {
            ImmutableList removed = this.removedBuilder.build().asList();
            ImmutableList updated = this.updatedBuilder.build().asList();
            ImmutableList missing = this.missingBuilder.build().asList();
            return new UpdateNamespacePropertiesResponse(removed, updated, missing);
        }
    }
}

