/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest.responses;

import java.util.Collection;
import java.util.List;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.rest.RESTResponse;

public class ListNamespacesResponse
implements RESTResponse {
    private List<Namespace> namespaces;

    public ListNamespacesResponse() {
    }

    private ListNamespacesResponse(List<Namespace> namespaces) {
        this.namespaces = namespaces;
        this.validate();
    }

    @Override
    public void validate() {
        Preconditions.checkArgument(this.namespaces != null, "Invalid namespace: null");
    }

    public List<Namespace> namespaces() {
        return this.namespaces != null ? this.namespaces : ImmutableList.of();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("namespaces", this.namespaces()).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final ImmutableList.Builder<Namespace> namespaces = ImmutableList.builder();

        private Builder() {
        }

        public Builder add(Namespace toAdd) {
            Preconditions.checkNotNull(toAdd, "Invalid namespace: null");
            this.namespaces.add((Object)toAdd);
            return this;
        }

        public Builder addAll(Collection<Namespace> toAdd) {
            Preconditions.checkNotNull(toAdd, "Invalid namespace list: null");
            Preconditions.checkArgument(!toAdd.contains(null), "Invalid namespace: null");
            this.namespaces.addAll(toAdd);
            return this;
        }

        public ListNamespacesResponse build() {
            return new ListNamespacesResponse((List)((Object)this.namespaces.build()));
        }
    }
}

