/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest.requests;

import java.util.List;
import java.util.Set;
import org.apache.iceberg.MetadataUpdate;
import org.apache.iceberg.SnapshotRef;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.rest.RESTRequest;

public class UpdateTableRequest
implements RESTRequest {
    private TableIdentifier identifier;
    private List<org.apache.iceberg.UpdateRequirement> requirements;
    private List<MetadataUpdate> updates;

    public UpdateTableRequest() {
    }

    public UpdateTableRequest(List<org.apache.iceberg.UpdateRequirement> requirements, List<MetadataUpdate> updates) {
        this.requirements = requirements;
        this.updates = updates;
    }

    UpdateTableRequest(TableIdentifier identifier, List<org.apache.iceberg.UpdateRequirement> requirements, List<MetadataUpdate> updates) {
        this(requirements, updates);
        this.identifier = identifier;
    }

    @Override
    public void validate() {
    }

    public List<org.apache.iceberg.UpdateRequirement> requirements() {
        return this.requirements != null ? this.requirements : ImmutableList.of();
    }

    public List<MetadataUpdate> updates() {
        return this.updates != null ? this.updates : ImmutableList.of();
    }

    public TableIdentifier identifier() {
        return this.identifier;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("requirements", this.requirements).add("updates", this.updates).toString();
    }

    public static UpdateTableRequest create(TableIdentifier identifier, List<org.apache.iceberg.UpdateRequirement> requirements, List<MetadataUpdate> updates) {
        return new UpdateTableRequest(identifier, requirements, updates);
    }

    @Deprecated
    public static Builder builderForCreate() {
        return new Builder(null, false).requireCreate();
    }

    @Deprecated
    public static Builder builderForReplace(TableMetadata base) {
        Preconditions.checkNotNull(base, "Cannot create a builder from table metadata: null");
        return new Builder(base, true).requireTableUUID(base.uuid());
    }

    @Deprecated
    public static Builder builderFor(TableMetadata base) {
        Preconditions.checkNotNull(base, "Cannot create a builder from table metadata: null");
        return new Builder(base, false).requireTableUUID(base.uuid());
    }

    @Deprecated
    public static interface UpdateRequirement
    extends org.apache.iceberg.UpdateRequirement {

        public static class AssertDefaultSortOrderID
        implements UpdateRequirement {
            private final int sortOrderId;

            AssertDefaultSortOrderID(int sortOrderId) {
                this.sortOrderId = sortOrderId;
            }

            public int sortOrderId() {
                return this.sortOrderId;
            }

            @Override
            public void validate(TableMetadata base) {
                if (this.sortOrderId != base.defaultSortOrderId()) {
                    throw new CommitFailedException("Requirement failed: default sort order changed: expected id %s != %s", this.sortOrderId, base.defaultSortOrderId());
                }
            }
        }

        public static class AssertDefaultSpecID
        implements UpdateRequirement {
            private final int specId;

            AssertDefaultSpecID(int specId) {
                this.specId = specId;
            }

            public int specId() {
                return this.specId;
            }

            @Override
            public void validate(TableMetadata base) {
                if (this.specId != base.defaultSpecId()) {
                    throw new CommitFailedException("Requirement failed: default partition spec changed: expected id %s != %s", this.specId, base.defaultSpecId());
                }
            }
        }

        public static class AssertLastAssignedPartitionId
        implements UpdateRequirement {
            private final int lastAssignedPartitionId;

            public AssertLastAssignedPartitionId(int lastAssignedPartitionId) {
                this.lastAssignedPartitionId = lastAssignedPartitionId;
            }

            public int lastAssignedPartitionId() {
                return this.lastAssignedPartitionId;
            }

            @Override
            public void validate(TableMetadata base) {
                if (base != null && base.lastAssignedPartitionId() != this.lastAssignedPartitionId) {
                    throw new CommitFailedException("Requirement failed: last assigned partition id changed: expected id %s != %s", this.lastAssignedPartitionId, base.lastAssignedPartitionId());
                }
            }
        }

        public static class AssertCurrentSchemaID
        implements UpdateRequirement {
            private final int schemaId;

            AssertCurrentSchemaID(int schemaId) {
                this.schemaId = schemaId;
            }

            public int schemaId() {
                return this.schemaId;
            }

            @Override
            public void validate(TableMetadata base) {
                if (this.schemaId != base.currentSchemaId()) {
                    throw new CommitFailedException("Requirement failed: current schema changed: expected id %s != %s", this.schemaId, base.currentSchemaId());
                }
            }
        }

        public static class AssertLastAssignedFieldId
        implements UpdateRequirement {
            private final int lastAssignedFieldId;

            public AssertLastAssignedFieldId(int lastAssignedFieldId) {
                this.lastAssignedFieldId = lastAssignedFieldId;
            }

            public int lastAssignedFieldId() {
                return this.lastAssignedFieldId;
            }

            @Override
            public void validate(TableMetadata base) {
                if (base != null && base.lastColumnId() != this.lastAssignedFieldId) {
                    throw new CommitFailedException("Requirement failed: last assigned field id changed: expected id %s != %s", this.lastAssignedFieldId, base.lastColumnId());
                }
            }
        }

        public static class AssertRefSnapshotID
        implements UpdateRequirement {
            private final String name;
            private final Long snapshotId;

            AssertRefSnapshotID(String name, Long snapshotId) {
                this.name = name;
                this.snapshotId = snapshotId;
            }

            public String refName() {
                return this.name;
            }

            public Long snapshotId() {
                return this.snapshotId;
            }

            @Override
            public void validate(TableMetadata base) {
                SnapshotRef ref = base.ref(this.name);
                if (ref != null) {
                    String type;
                    String string = type = ref.isBranch() ? "branch" : "tag";
                    if (this.snapshotId == null) {
                        throw new CommitFailedException("Requirement failed: %s %s was created concurrently", type, this.name);
                    }
                    if (this.snapshotId.longValue() != ref.snapshotId()) {
                        throw new CommitFailedException("Requirement failed: %s %s has changed: expected id %s != %s", type, this.name, this.snapshotId, ref.snapshotId());
                    }
                } else if (this.snapshotId != null) {
                    throw new CommitFailedException("Requirement failed: branch or tag %s is missing, expected %s", this.name, this.snapshotId);
                }
            }
        }

        public static class AssertTableUUID
        implements UpdateRequirement {
            private final String uuid;

            AssertTableUUID(String uuid) {
                this.uuid = uuid;
            }

            public String uuid() {
                return this.uuid;
            }

            @Override
            public void validate(TableMetadata base) {
                if (!this.uuid.equalsIgnoreCase(base.uuid())) {
                    throw new CommitFailedException("Requirement failed: UUID does not match: expected %s != %s", base.uuid(), this.uuid);
                }
            }
        }

        public static class AssertTableDoesNotExist
        implements UpdateRequirement {
            AssertTableDoesNotExist() {
            }

            @Override
            public void validate(TableMetadata base) {
                if (base != null) {
                    throw new CommitFailedException("Requirement failed: table already exists", new Object[0]);
                }
            }
        }
    }

    @Deprecated
    public static class Builder {
        private final TableMetadata base;
        private final ImmutableList.Builder<org.apache.iceberg.UpdateRequirement> requirements = ImmutableList.builder();
        private final List<MetadataUpdate> updates = Lists.newArrayList();
        private final Set<String> changedRefs = Sets.newHashSet();
        private final boolean isReplace;
        private boolean addedSchema = false;
        private boolean setSchemaId = false;
        private boolean addedSpec = false;
        private boolean setSpecId = false;
        private boolean setOrderId = false;

        public Builder(TableMetadata base, boolean isReplace) {
            this.base = base;
            this.isReplace = isReplace;
        }

        private Builder require(UpdateRequirement requirement) {
            Preconditions.checkArgument(requirement != null, "Invalid requirement: null");
            this.requirements.add((Object)requirement);
            return this;
        }

        private Builder requireCreate() {
            return this.require(new UpdateRequirement.AssertTableDoesNotExist());
        }

        private Builder requireTableUUID(String uuid) {
            Preconditions.checkArgument(uuid != null, "Invalid required UUID: null");
            return this.require(new UpdateRequirement.AssertTableUUID(uuid));
        }

        private Builder requireRefSnapshotId(String ref, Long snapshotId) {
            return this.require(new UpdateRequirement.AssertRefSnapshotID(ref, snapshotId));
        }

        private Builder requireLastAssignedFieldId(int fieldId) {
            return this.require(new UpdateRequirement.AssertLastAssignedFieldId(fieldId));
        }

        private Builder requireCurrentSchemaId(int schemaId) {
            return this.require(new UpdateRequirement.AssertCurrentSchemaID(schemaId));
        }

        private Builder requireLastAssignedPartitionId(int partitionId) {
            return this.require(new UpdateRequirement.AssertLastAssignedPartitionId(partitionId));
        }

        private Builder requireDefaultSpecId(int specId) {
            return this.require(new UpdateRequirement.AssertDefaultSpecID(specId));
        }

        private Builder requireDefaultSortOrderId(int orderId) {
            return this.require(new UpdateRequirement.AssertDefaultSortOrderID(orderId));
        }

        public Builder update(MetadataUpdate update) {
            Preconditions.checkArgument(update != null, "Invalid update: null");
            this.updates.add(update);
            if (update instanceof MetadataUpdate.SetSnapshotRef) {
                this.update((MetadataUpdate.SetSnapshotRef)update);
            } else if (update instanceof MetadataUpdate.AddSchema) {
                this.update((MetadataUpdate.AddSchema)update);
            } else if (update instanceof MetadataUpdate.SetCurrentSchema) {
                this.update((MetadataUpdate.SetCurrentSchema)update);
            } else if (update instanceof MetadataUpdate.AddPartitionSpec) {
                this.update((MetadataUpdate.AddPartitionSpec)update);
            } else if (update instanceof MetadataUpdate.SetDefaultPartitionSpec) {
                this.update((MetadataUpdate.SetDefaultPartitionSpec)update);
            } else if (update instanceof MetadataUpdate.SetDefaultSortOrder) {
                this.update((MetadataUpdate.SetDefaultSortOrder)update);
            }
            return this;
        }

        private void update(MetadataUpdate.SetSnapshotRef setRef) {
            String name = setRef.name();
            boolean added = this.changedRefs.add(name);
            if (added && this.base != null && !this.isReplace) {
                SnapshotRef baseRef = this.base.ref(name);
                this.requireRefSnapshotId(name, baseRef != null ? Long.valueOf(baseRef.snapshotId()) : null);
            }
        }

        private void update(MetadataUpdate.AddSchema update) {
            if (!this.addedSchema) {
                if (this.base != null) {
                    this.requireLastAssignedFieldId(this.base.lastColumnId());
                }
                this.addedSchema = true;
            }
        }

        private void update(MetadataUpdate.SetCurrentSchema update) {
            if (!this.setSchemaId) {
                if (this.base != null && !this.isReplace) {
                    this.requireCurrentSchemaId(this.base.currentSchemaId());
                }
                this.setSchemaId = true;
            }
        }

        private void update(MetadataUpdate.AddPartitionSpec update) {
            if (!this.addedSpec) {
                if (this.base != null) {
                    this.requireLastAssignedPartitionId(this.base.lastAssignedPartitionId());
                }
                this.addedSpec = true;
            }
        }

        private void update(MetadataUpdate.SetDefaultPartitionSpec update) {
            if (!this.setSpecId) {
                if (this.base != null && !this.isReplace) {
                    this.requireDefaultSpecId(this.base.defaultSpecId());
                }
                this.setSpecId = true;
            }
        }

        private void update(MetadataUpdate.SetDefaultSortOrder update) {
            if (!this.setOrderId) {
                if (this.base != null && !this.isReplace) {
                    this.requireDefaultSortOrderId(this.base.defaultSortOrderId());
                }
                this.setOrderId = true;
            }
        }

        public UpdateTableRequest build() {
            return new UpdateTableRequest((List<org.apache.iceberg.UpdateRequirement>)((Object)this.requirements.build()), ImmutableList.copyOf(this.updates));
        }
    }
}

