/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest.requests;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iceberg.metrics.MetricsReport;
import org.apache.iceberg.rest.requests.ReportMetricsRequest;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ReportMetricsRequest", generator="Immutables")
@Immutable
public final class ImmutableReportMetricsRequest
implements ReportMetricsRequest {
    private final ReportMetricsRequest.ReportType reportType;
    private final MetricsReport report;

    private ImmutableReportMetricsRequest(ReportMetricsRequest.ReportType reportType, MetricsReport report) {
        this.reportType = reportType;
        this.report = report;
    }

    @Override
    public ReportMetricsRequest.ReportType reportType() {
        return this.reportType;
    }

    @Override
    public MetricsReport report() {
        return this.report;
    }

    public final ImmutableReportMetricsRequest withReportType(ReportMetricsRequest.ReportType value) {
        ReportMetricsRequest.ReportType newValue = Objects.requireNonNull(value, "reportType");
        if (this.reportType == newValue) {
            return this;
        }
        return new ImmutableReportMetricsRequest(newValue, this.report);
    }

    public final ImmutableReportMetricsRequest withReport(MetricsReport value) {
        if (this.report == value) {
            return this;
        }
        MetricsReport newValue = Objects.requireNonNull(value, "report");
        return new ImmutableReportMetricsRequest(this.reportType, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableReportMetricsRequest && this.equalTo(0, (ImmutableReportMetricsRequest)another);
    }

    private boolean equalTo(int synthetic, ImmutableReportMetricsRequest another) {
        return this.reportType.equals((Object)another.reportType) && this.report.equals(another.report);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.reportType.hashCode();
        h2 += (h2 << 5) + this.report.hashCode();
        return h2;
    }

    public String toString() {
        return "ReportMetricsRequest{reportType=" + (Object)((Object)this.reportType) + ", report=" + this.report + "}";
    }

    public static ImmutableReportMetricsRequest copyOf(ReportMetricsRequest instance) {
        if (instance instanceof ImmutableReportMetricsRequest) {
            return (ImmutableReportMetricsRequest)instance;
        }
        return ImmutableReportMetricsRequest.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ReportMetricsRequest", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_REPORT_TYPE = 1L;
        private static final long INIT_BIT_REPORT = 2L;
        private long initBits = 3L;
        @Nullable
        private ReportMetricsRequest.ReportType reportType;
        @Nullable
        private MetricsReport report;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ReportMetricsRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.reportType(instance.reportType());
            this.report(instance.report());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder reportType(ReportMetricsRequest.ReportType reportType) {
            this.reportType = Objects.requireNonNull(reportType, "reportType");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder report(MetricsReport report) {
            this.report = Objects.requireNonNull(report, "report");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableReportMetricsRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableReportMetricsRequest(this.reportType, this.report);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("reportType");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("report");
            }
            return "Cannot build ReportMetricsRequest, some of required attributes are not set " + attributes;
        }
    }
}

