/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import org.apache.iceberg.rest.RESTSerializers;

class RESTObjectMapper {
    private static final JsonFactory FACTORY = new JsonFactory();
    private static final ObjectMapper MAPPER = new ObjectMapper(FACTORY);
    private static volatile boolean isInitialized = false;

    private RESTObjectMapper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static ObjectMapper mapper() {
        if (isInitialized) return MAPPER;
        Class<RESTObjectMapper> clazz = RESTObjectMapper.class;
        synchronized (RESTObjectMapper.class) {
            if (isInitialized) return MAPPER;
            MAPPER.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            MAPPER.setPropertyNamingStrategy(new PropertyNamingStrategy.KebabCaseStrategy());
            RESTSerializers.registerAll(MAPPER);
            isInitialized = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return MAPPER;
        }
    }
}

