/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.hadoop.HadoopInputFile;
import org.apache.iceberg.hadoop.HadoopOutputFile;
import org.apache.iceberg.io.DelegatingInputStream;
import org.apache.iceberg.io.DelegatingOutputStream;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.PositionOutputStream;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.parquet.hadoop.util.HadoopStreams;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.parquet.io.DelegatingPositionOutputStream;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.parquet.io.DelegatingSeekableInputStream;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.parquet.io.OutputFile;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.parquet.io.SeekableInputStream;

class ParquetIO {
    private ParquetIO() {
    }

    static org.apache.seatunnel.shade.connector-iceberg.org.apache.parquet.io.InputFile file(InputFile file) {
        if (file instanceof HadoopInputFile) {
            HadoopInputFile hfile = (HadoopInputFile)file;
            try {
                return org.apache.seatunnel.shade.connector-iceberg.org.apache.parquet.hadoop.util.HadoopInputFile.fromStatus(hfile.getStat(), hfile.getConf());
            }
            catch (IOException e) {
                throw new RuntimeIOException(e, "Failed to create Parquet input file for %s", file);
            }
        }
        return new ParquetInputFile(file);
    }

    static OutputFile file(org.apache.iceberg.io.OutputFile file) {
        if (file instanceof HadoopOutputFile) {
            HadoopOutputFile hfile = (HadoopOutputFile)file;
            try {
                return org.apache.seatunnel.shade.connector-iceberg.org.apache.parquet.hadoop.util.HadoopOutputFile.fromPath(hfile.getPath(), hfile.getConf());
            }
            catch (IOException e) {
                throw new RuntimeIOException(e, "Failed to create Parquet output file for %s", file);
            }
        }
        return new ParquetOutputFile(file);
    }

    static OutputFile file(org.apache.iceberg.io.OutputFile file, Configuration conf) {
        if (file instanceof HadoopOutputFile) {
            HadoopOutputFile hfile = (HadoopOutputFile)file;
            try {
                return org.apache.seatunnel.shade.connector-iceberg.org.apache.parquet.hadoop.util.HadoopOutputFile.fromPath(hfile.getPath(), conf);
            }
            catch (IOException e) {
                throw new RuntimeIOException(e, "Failed to create Parquet output file for %s", file);
            }
        }
        return new ParquetOutputFile(file);
    }

    static SeekableInputStream stream(org.apache.iceberg.io.SeekableInputStream stream) {
        InputStream wrapped;
        if (stream instanceof DelegatingInputStream && (wrapped = ((DelegatingInputStream)((Object)stream)).getDelegate()) instanceof FSDataInputStream) {
            return HadoopStreams.wrap((FSDataInputStream)wrapped);
        }
        return new ParquetInputStreamAdapter(stream);
    }

    static org.apache.seatunnel.shade.connector-iceberg.org.apache.parquet.io.PositionOutputStream stream(PositionOutputStream stream) {
        OutputStream wrapped;
        if (stream instanceof DelegatingOutputStream && (wrapped = ((DelegatingOutputStream)((Object)stream)).getDelegate()) instanceof FSDataOutputStream) {
            return HadoopStreams.wrap((FSDataOutputStream)wrapped);
        }
        return new ParquetOutputStreamAdapter(stream);
    }

    private static class ParquetInputFile
    implements org.apache.seatunnel.shade.connector-iceberg.org.apache.parquet.io.InputFile {
        private final InputFile file;

        private ParquetInputFile(InputFile file) {
            this.file = file;
        }

        @Override
        public long getLength() throws IOException {
            return this.file.getLength();
        }

        @Override
        public SeekableInputStream newStream() throws IOException {
            return ParquetIO.stream(this.file.newStream());
        }
    }

    private static class ParquetOutputFile
    implements OutputFile {
        private final org.apache.iceberg.io.OutputFile file;

        private ParquetOutputFile(org.apache.iceberg.io.OutputFile file) {
            this.file = file;
        }

        @Override
        public org.apache.seatunnel.shade.connector-iceberg.org.apache.parquet.io.PositionOutputStream create(long ignored) throws IOException {
            return ParquetIO.stream(this.file.create());
        }

        @Override
        public org.apache.seatunnel.shade.connector-iceberg.org.apache.parquet.io.PositionOutputStream createOrOverwrite(long ignored) throws IOException {
            return ParquetIO.stream(this.file.createOrOverwrite());
        }

        @Override
        public boolean supportsBlockSize() {
            return false;
        }

        @Override
        public long defaultBlockSize() {
            return 0L;
        }
    }

    private static class ParquetOutputStreamAdapter
    extends DelegatingPositionOutputStream {
        private final PositionOutputStream delegate;

        private ParquetOutputStreamAdapter(PositionOutputStream delegate) {
            super(delegate);
            this.delegate = delegate;
        }

        @Override
        public long getPos() throws IOException {
            return this.delegate.getPos();
        }
    }

    private static class ParquetInputStreamAdapter
    extends DelegatingSeekableInputStream {
        private final org.apache.iceberg.io.SeekableInputStream delegate;

        private ParquetInputStreamAdapter(org.apache.iceberg.io.SeekableInputStream delegate) {
            super(delegate);
            this.delegate = delegate;
        }

        @Override
        public long getPos() throws IOException {
            return this.delegate.getPos();
        }

        @Override
        public void seek(long newPos) throws IOException {
            this.delegate.seek(newPos);
        }
    }
}

