/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import java.io.IOException;
import org.apache.iceberg.parquet.BasePageIterator;
import org.apache.iceberg.parquet.TripleIterator;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.parquet.CorruptDeltaByteArrays;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.parquet.bytes.ByteBufferInputStream;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.parquet.column.ColumnDescriptor;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.parquet.column.Encoding;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.parquet.column.ValuesType;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.parquet.column.page.DataPage;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.parquet.column.page.DataPageV1;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.parquet.column.page.DataPageV2;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.parquet.column.values.RequiresPreviousReader;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.parquet.column.values.ValuesReader;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.parquet.io.ParquetDecodingException;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.parquet.io.api.Binary;

abstract class PageIterator<T>
extends BasePageIterator
implements TripleIterator<T> {
    static <T> PageIterator<T> newIterator(ColumnDescriptor desc, String writerVersion) {
        switch (desc.getPrimitiveType().getPrimitiveTypeName()) {
            case BOOLEAN: {
                return new PageIterator<Boolean>(desc, writerVersion){

                    @Override
                    public Boolean next() {
                        return this.nextBoolean();
                    }
                };
            }
            case INT32: {
                return new PageIterator<Integer>(desc, writerVersion){

                    @Override
                    public Integer next() {
                        return this.nextInteger();
                    }
                };
            }
            case INT64: {
                return new PageIterator<Long>(desc, writerVersion){

                    @Override
                    public Long next() {
                        return this.nextLong();
                    }
                };
            }
            case INT96: {
                return new PageIterator<Binary>(desc, writerVersion){

                    @Override
                    public Binary next() {
                        return this.nextBinary();
                    }
                };
            }
            case FLOAT: {
                return new PageIterator<Float>(desc, writerVersion){

                    @Override
                    public Float next() {
                        return Float.valueOf(this.nextFloat());
                    }
                };
            }
            case DOUBLE: {
                return new PageIterator<Double>(desc, writerVersion){

                    @Override
                    public Double next() {
                        return this.nextDouble();
                    }
                };
            }
            case FIXED_LEN_BYTE_ARRAY: 
            case BINARY: {
                return new PageIterator<Binary>(desc, writerVersion){

                    @Override
                    public Binary next() {
                        return this.nextBinary();
                    }
                };
            }
        }
        throw new UnsupportedOperationException("Unsupported primitive type: " + (Object)((Object)desc.getPrimitiveType().getPrimitiveTypeName()));
    }

    private PageIterator(ColumnDescriptor desc, String writerVersion) {
        super(desc, writerVersion);
    }

    @Override
    public void setPage(DataPage page) {
        super.setPage(page);
        this.advance();
    }

    @Override
    public int currentDefinitionLevel() {
        Preconditions.checkArgument(this.currentDL >= 0, "Should not read definition, past page end");
        return this.currentDL;
    }

    @Override
    public int currentRepetitionLevel() {
        return this.currentRL;
    }

    @Override
    public boolean nextBoolean() {
        this.advance();
        try {
            return this.values.readBoolean();
        }
        catch (RuntimeException e) {
            throw this.handleRuntimeException(e);
        }
    }

    @Override
    public int nextInteger() {
        this.advance();
        try {
            return this.values.readInteger();
        }
        catch (RuntimeException e) {
            throw this.handleRuntimeException(e);
        }
    }

    @Override
    public long nextLong() {
        this.advance();
        try {
            return this.values.readLong();
        }
        catch (RuntimeException e) {
            throw this.handleRuntimeException(e);
        }
    }

    @Override
    public float nextFloat() {
        this.advance();
        try {
            return this.values.readFloat();
        }
        catch (RuntimeException e) {
            throw this.handleRuntimeException(e);
        }
    }

    @Override
    public double nextDouble() {
        this.advance();
        try {
            return this.values.readDouble();
        }
        catch (RuntimeException e) {
            throw this.handleRuntimeException(e);
        }
    }

    @Override
    public Binary nextBinary() {
        this.advance();
        try {
            return this.values.readBytes();
        }
        catch (RuntimeException e) {
            throw this.handleRuntimeException(e);
        }
    }

    @Override
    public <V> V nextNull() {
        this.advance();
        return null;
    }

    private void advance() {
        if (this.triplesRead < this.triplesCount) {
            this.currentDL = this.definitionLevels.nextInt();
            this.currentRL = this.repetitionLevels.nextInt();
            ++this.triplesRead;
            this.hasNext = true;
        } else {
            this.currentDL = -1;
            this.currentRL = -1;
            this.hasNext = false;
        }
    }

    RuntimeException handleRuntimeException(RuntimeException exception) {
        if (CorruptDeltaByteArrays.requiresSequentialReads(this.writerVersion, this.valueEncoding) && exception instanceof ArrayIndexOutOfBoundsException) {
            throw new ParquetDecodingException("Read failure possibly due to PARQUET-246: try setting parquet.split.files to false", new ParquetDecodingException(String.format("Can't read value in column %s at value %d out of %d in current page. repetition level: %d, definition level: %d", this.desc, this.triplesRead, this.triplesCount, this.currentRL, this.currentDL), exception));
        }
        throw new ParquetDecodingException(String.format("Can't read value in column %s at value %d out of %d in current page. repetition level: %d, definition level: %d", this.desc, this.triplesRead, this.triplesCount, this.currentRL, this.currentDL), exception);
    }

    @Override
    protected void initDataReader(Encoding dataEncoding, ByteBufferInputStream in, int valueCount) {
        ValuesReader previousReader = this.values;
        this.valueEncoding = dataEncoding;
        if (dataEncoding.usesDictionary()) {
            if (this.dictionary == null) {
                throw new ParquetDecodingException("could not read page in col " + this.desc + " as the dictionary was missing for encoding " + (Object)((Object)dataEncoding));
            }
            this.values = dataEncoding.getDictionaryBasedValuesReader(this.desc, ValuesType.VALUES, this.dictionary);
        } else {
            this.values = dataEncoding.getValuesReader(this.desc, ValuesType.VALUES);
        }
        try {
            this.values.initFromPage(valueCount, in);
        }
        catch (IOException e) {
            throw new ParquetDecodingException("could not read page in col " + this.desc, e);
        }
        if (CorruptDeltaByteArrays.requiresSequentialReads(this.writerVersion, dataEncoding) && previousReader instanceof RequiresPreviousReader) {
            ((RequiresPreviousReader)((Object)this.values)).setPreviousReader(previousReader);
        }
    }

    @Override
    protected void initDefinitionLevelsReader(DataPageV1 dataPageV1, ColumnDescriptor desc, ByteBufferInputStream in, int triplesCount) throws IOException {
        ValuesReader dlReader = dataPageV1.getDlEncoding().getValuesReader(desc, ValuesType.DEFINITION_LEVEL);
        this.definitionLevels = new BasePageIterator.ValuesReaderIntIterator(dlReader);
        dlReader.initFromPage(triplesCount, in);
    }

    @Override
    protected void initDefinitionLevelsReader(DataPageV2 dataPageV2, ColumnDescriptor desc) {
        this.definitionLevels = this.newRLEIterator(desc.getMaxDefinitionLevel(), dataPageV2.getDefinitionLevels());
    }
}

