/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.iceberg.mapping.MappedField;
import org.apache.iceberg.mapping.NameMapping;
import org.apache.iceberg.parquet.ParquetSchemaUtil;
import org.apache.iceberg.parquet.ParquetTypeVisitor;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.parquet.schema.GroupType;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.parquet.schema.MessageType;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.parquet.schema.PrimitiveType;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.parquet.schema.Type;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.parquet.schema.Types;

class ApplyNameMapping
extends ParquetTypeVisitor<Type> {
    private static final String LIST_ELEMENT_NAME = "element";
    private static final String MAP_KEY_NAME = "key";
    private static final String MAP_VALUE_NAME = "value";
    private final NameMapping nameMapping;
    private final Deque<String> fieldNames = Lists.newLinkedList();

    ApplyNameMapping(NameMapping nameMapping) {
        this.nameMapping = nameMapping;
    }

    @Override
    public Type message(MessageType message, List<Type> fields) {
        Types.MessageTypeBuilder builder = Types.buildMessage();
        fields.stream().filter(Objects::nonNull).forEach(builder::addField);
        return builder.named(message.getName());
    }

    @Override
    public Type struct(GroupType struct, List<Type> types) {
        MappedField field = this.nameMapping.find(this.currentPath());
        List<Type> actualTypes = types.stream().filter(Objects::nonNull).collect(Collectors.toList());
        GroupType structType = struct.withNewFields(actualTypes);
        return field == null ? structType : ((Type)structType).withId(field.id());
    }

    @Override
    public Type list(GroupType list, Type elementType) {
        Preconditions.checkArgument(elementType != null, "List type must have element field");
        Type listElement = ParquetSchemaUtil.determineListElementType(list);
        MappedField field = this.nameMapping.find(this.currentPath());
        Types.GroupBuilder listBuilder = (Types.GroupBuilder)Types.buildGroup(list.getRepetition()).as(LogicalTypeAnnotation.listType());
        if (listElement.isRepetition(Type.Repetition.REPEATED)) {
            listBuilder.addFields(elementType);
        } else {
            ((Types.GroupBuilder)listBuilder.repeatedGroup().addFields(elementType)).named(list.getFieldName(0));
        }
        Type listType = (Type)listBuilder.named(list.getName());
        return field == null ? listType : listType.withId(field.id());
    }

    @Override
    public Type map(GroupType map, Type keyType, Type valueType) {
        Preconditions.checkArgument(keyType != null && valueType != null, "Map type must have both key field and value field");
        MappedField field = this.nameMapping.find(this.currentPath());
        Type mapType = (Type)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildGroup(map.getRepetition()).as(LogicalTypeAnnotation.mapType())).repeatedGroup().addFields(keyType, valueType)).named(map.getFieldName(0))).named(map.getName());
        return field == null ? mapType : mapType.withId(field.id());
    }

    @Override
    public Type primitive(PrimitiveType primitive) {
        MappedField field = this.nameMapping.find(this.currentPath());
        return field == null ? primitive : primitive.withId(field.id());
    }

    @Override
    public void beforeField(Type type) {
        this.fieldNames.push(type.getName());
    }

    @Override
    public void afterField(Type type) {
        this.fieldNames.pop();
    }

    @Override
    public void beforeElementField(Type element) {
        this.fieldNames.push(LIST_ELEMENT_NAME);
    }

    @Override
    public void beforeKeyField(Type key) {
        this.fieldNames.push(MAP_KEY_NAME);
    }

    @Override
    public void beforeValueField(Type key) {
        this.fieldNames.push(MAP_VALUE_NAME);
    }

    @Override
    public void beforeRepeatedElement(Type element) {
    }

    @Override
    public void afterRepeatedElement(Type element) {
    }

    @Override
    public void beforeRepeatedKeyValue(Type keyValue) {
    }

    @Override
    public void afterRepeatedKeyValue(Type keyValue) {
    }

    @Override
    protected String[] currentPath() {
        return Lists.newArrayList(this.fieldNames.descendingIterator()).toArray(new String[0]);
    }

    @Override
    protected String[] path(String name) {
        ArrayList<String> list = Lists.newArrayList(this.fieldNames.descendingIterator());
        list.add(name);
        return list.toArray(new String[0]);
    }
}

