/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.avro;

import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.avro.LogicalMap;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.util.Pair;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.avro.Schema;

public abstract class AvroWithPartnerByStructureVisitor<P, T> {
    private Deque<String> recordLevels = Lists.newLinkedList();

    public static <P, T> T visit(P partner, Schema schema, AvroWithPartnerByStructureVisitor<P, T> visitor) {
        switch (schema.getType()) {
            case RECORD: {
                return AvroWithPartnerByStructureVisitor.visitRecord(partner, schema, visitor);
            }
            case UNION: {
                return AvroWithPartnerByStructureVisitor.visitUnion(partner, schema, visitor);
            }
            case ARRAY: {
                return AvroWithPartnerByStructureVisitor.visitArray(partner, schema, visitor);
            }
            case MAP: {
                P keyType = visitor.mapKeyType(partner);
                Preconditions.checkArgument(visitor.isStringType(keyType), "Invalid map: %s is not a string", keyType);
                return visitor.map(partner, schema, AvroWithPartnerByStructureVisitor.visit(visitor.mapValueType(partner), schema.getValueType(), visitor));
            }
        }
        return visitor.primitive(partner, schema);
    }

    private static <P, T> T visitRecord(P struct, Schema record, AvroWithPartnerByStructureVisitor<P, T> visitor) {
        String name = record.getFullName();
        Preconditions.checkState(!visitor.recordLevels.contains(name), "Cannot process recursive Avro record %s", (Object)name);
        List<Schema.Field> fields = record.getFields();
        visitor.recordLevels.push(name);
        ArrayList<String> names = Lists.newArrayListWithExpectedSize(fields.size());
        ArrayList<T> results = Lists.newArrayListWithExpectedSize(fields.size());
        for (int i = 0; i < fields.size(); ++i) {
            Pair<String, P> nameAndType = visitor.fieldNameAndType(struct, i);
            String fieldName = nameAndType.first();
            Schema.Field field = fields.get(i);
            Preconditions.checkArgument(AvroSchemaUtil.makeCompatibleName(fieldName).equals(field.name()), "Structs do not match: field %s != %s", (Object)fieldName, (Object)field.name());
            results.add(AvroWithPartnerByStructureVisitor.visit(nameAndType.second(), field.schema(), visitor));
            names.add(fieldName);
        }
        visitor.recordLevels.pop();
        return visitor.record(struct, record, names, results);
    }

    private static <P, T> T visitUnion(P type, Schema union, AvroWithPartnerByStructureVisitor<P, T> visitor) {
        List<Schema> types = union.getTypes();
        Preconditions.checkArgument(AvroSchemaUtil.isOptionSchema(union), "Cannot visit non-option union: %s", (Object)union);
        ArrayList<T> options = Lists.newArrayListWithExpectedSize(types.size());
        for (Schema branch : types) {
            if (branch.getType() == Schema.Type.NULL) {
                options.add(AvroWithPartnerByStructureVisitor.visit(visitor.nullType(), branch, visitor));
                continue;
            }
            options.add(AvroWithPartnerByStructureVisitor.visit(type, branch, visitor));
        }
        return visitor.union(type, union, options);
    }

    private static <P, T> T visitArray(P type, Schema array, AvroWithPartnerByStructureVisitor<P, T> visitor) {
        if (array.getLogicalType() instanceof LogicalMap || visitor.isMapType(type)) {
            Preconditions.checkState(AvroSchemaUtil.isKeyValueSchema(array.getElementType()), "Cannot visit invalid logical map type: %s", (Object)array);
            List<Schema.Field> keyValueFields = array.getElementType().getFields();
            return visitor.map(type, array, AvroWithPartnerByStructureVisitor.visit(visitor.mapKeyType(type), keyValueFields.get(0).schema(), visitor), AvroWithPartnerByStructureVisitor.visit(visitor.mapValueType(type), keyValueFields.get(1).schema(), visitor));
        }
        return visitor.array(type, array, AvroWithPartnerByStructureVisitor.visit(visitor.arrayElementType(type), array.getElementType(), visitor));
    }

    protected abstract boolean isMapType(P var1);

    protected abstract boolean isStringType(P var1);

    protected abstract P arrayElementType(P var1);

    protected abstract P mapKeyType(P var1);

    protected abstract P mapValueType(P var1);

    protected abstract Pair<String, P> fieldNameAndType(P var1, int var2);

    protected abstract P nullType();

    public T record(P struct, Schema record, List<String> names, List<T> fields) {
        return null;
    }

    public T union(P type, Schema union, List<T> options) {
        return null;
    }

    public T array(P sArray, Schema array, T element) {
        return null;
    }

    public T map(P sMap, Schema map, T key, T value) {
        return null;
    }

    public T map(P sMap, Schema map, T value) {
        return null;
    }

    public T primitive(P type, Schema primitive) {
        return null;
    }
}

