/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.iceberg.MetadataUpdate;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.SnapshotParser;
import org.apache.iceberg.SnapshotRefType;
import org.apache.iceberg.SortOrderParser;
import org.apache.iceberg.StatisticsFile;
import org.apache.iceberg.StatisticsFileParser;
import org.apache.iceberg.UnboundPartitionSpec;
import org.apache.iceberg.UnboundSortOrder;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.util.JsonUtil;
import org.apache.iceberg.view.ViewVersionParser;

public class MetadataUpdateParser {
    private static final String ACTION = "action";
    static final String ASSIGN_UUID = "assign-uuid";
    static final String UPGRADE_FORMAT_VERSION = "upgrade-format-version";
    static final String ADD_SCHEMA = "add-schema";
    static final String SET_CURRENT_SCHEMA = "set-current-schema";
    static final String ADD_PARTITION_SPEC = "add-spec";
    static final String SET_DEFAULT_PARTITION_SPEC = "set-default-spec";
    static final String ADD_SORT_ORDER = "add-sort-order";
    static final String SET_DEFAULT_SORT_ORDER = "set-default-sort-order";
    static final String ADD_SNAPSHOT = "add-snapshot";
    static final String REMOVE_SNAPSHOTS = "remove-snapshots";
    static final String REMOVE_SNAPSHOT_REF = "remove-snapshot-ref";
    static final String SET_SNAPSHOT_REF = "set-snapshot-ref";
    static final String SET_PROPERTIES = "set-properties";
    static final String REMOVE_PROPERTIES = "remove-properties";
    static final String SET_LOCATION = "set-location";
    static final String SET_STATISTICS = "set-statistics";
    static final String REMOVE_STATISTICS = "remove-statistics";
    static final String ADD_VIEW_VERSION = "add-view-version";
    static final String SET_CURRENT_VIEW_VERSION = "set-current-view-version";
    private static final String UUID = "uuid";
    private static final String FORMAT_VERSION = "format-version";
    private static final String SCHEMA = "schema";
    private static final String LAST_COLUMN_ID = "last-column-id";
    private static final String SCHEMA_ID = "schema-id";
    private static final String SPEC = "spec";
    private static final String SPEC_ID = "spec-id";
    private static final String SORT_ORDER = "sort-order";
    private static final String SORT_ORDER_ID = "sort-order-id";
    private static final String STATISTICS = "statistics";
    private static final String SNAPSHOT = "snapshot";
    private static final String SNAPSHOT_IDS = "snapshot-ids";
    private static final String REF_NAME = "ref-name";
    private static final String SNAPSHOT_ID = "snapshot-id";
    private static final String TYPE = "type";
    private static final String MIN_SNAPSHOTS_TO_KEEP = "min-snapshots-to-keep";
    private static final String MAX_SNAPSHOT_AGE_MS = "max-snapshot-age-ms";
    private static final String MAX_REF_AGE_MS = "max-ref-age-ms";
    private static final String UPDATED = "updated";
    private static final String UPDATES = "updates";
    private static final String REMOVED = "removed";
    private static final String REMOVALS = "removals";
    private static final String LOCATION = "location";
    private static final String VIEW_VERSION = "view-version";
    private static final String VIEW_VERSION_ID = "view-version-id";
    private static final Map<Class<? extends MetadataUpdate>, String> ACTIONS = ImmutableMap.builder().put(MetadataUpdate.AssignUUID.class, "assign-uuid").put(MetadataUpdate.UpgradeFormatVersion.class, "upgrade-format-version").put(MetadataUpdate.AddSchema.class, "add-schema").put(MetadataUpdate.SetCurrentSchema.class, "set-current-schema").put(MetadataUpdate.AddPartitionSpec.class, "add-spec").put(MetadataUpdate.SetDefaultPartitionSpec.class, "set-default-spec").put(MetadataUpdate.AddSortOrder.class, "add-sort-order").put(MetadataUpdate.SetDefaultSortOrder.class, "set-default-sort-order").put(MetadataUpdate.SetStatistics.class, "set-statistics").put(MetadataUpdate.RemoveStatistics.class, "remove-statistics").put(MetadataUpdate.AddSnapshot.class, "add-snapshot").put(MetadataUpdate.RemoveSnapshot.class, "remove-snapshots").put(MetadataUpdate.RemoveSnapshotRef.class, "remove-snapshot-ref").put(MetadataUpdate.SetSnapshotRef.class, "set-snapshot-ref").put(MetadataUpdate.SetProperties.class, "set-properties").put(MetadataUpdate.RemoveProperties.class, "remove-properties").put(MetadataUpdate.SetLocation.class, "set-location").put(MetadataUpdate.AddViewVersion.class, "add-view-version").put(MetadataUpdate.SetCurrentViewVersion.class, "set-current-view-version").buildOrThrow();

    private MetadataUpdateParser() {
    }

    public static String toJson(MetadataUpdate metadataUpdate) {
        return MetadataUpdateParser.toJson(metadataUpdate, false);
    }

    public static String toJson(MetadataUpdate metadataUpdate, boolean pretty) {
        return JsonUtil.generate(gen -> MetadataUpdateParser.toJson(metadataUpdate, gen), pretty);
    }

    public static void toJson(MetadataUpdate metadataUpdate, JsonGenerator generator) throws IOException {
        String updateAction = ACTIONS.get(metadataUpdate.getClass());
        Preconditions.checkArgument(updateAction != null, "Cannot convert metadata update to json. Unrecognized metadata update type: %s", (Object)metadataUpdate.getClass().getName());
        generator.writeStartObject();
        generator.writeStringField(ACTION, updateAction);
        switch (updateAction) {
            case "assign-uuid": {
                MetadataUpdateParser.writeAssignUUID((MetadataUpdate.AssignUUID)metadataUpdate, generator);
                break;
            }
            case "upgrade-format-version": {
                MetadataUpdateParser.writeUpgradeFormatVersion((MetadataUpdate.UpgradeFormatVersion)metadataUpdate, generator);
                break;
            }
            case "add-schema": {
                MetadataUpdateParser.writeAddSchema((MetadataUpdate.AddSchema)metadataUpdate, generator);
                break;
            }
            case "set-current-schema": {
                MetadataUpdateParser.writeSetCurrentSchema((MetadataUpdate.SetCurrentSchema)metadataUpdate, generator);
                break;
            }
            case "add-spec": {
                MetadataUpdateParser.writeAddPartitionSpec((MetadataUpdate.AddPartitionSpec)metadataUpdate, generator);
                break;
            }
            case "set-default-spec": {
                MetadataUpdateParser.writeSetDefaultPartitionSpec((MetadataUpdate.SetDefaultPartitionSpec)metadataUpdate, generator);
                break;
            }
            case "add-sort-order": {
                MetadataUpdateParser.writeAddSortOrder((MetadataUpdate.AddSortOrder)metadataUpdate, generator);
                break;
            }
            case "set-default-sort-order": {
                MetadataUpdateParser.writeSetDefaultSortOrder((MetadataUpdate.SetDefaultSortOrder)metadataUpdate, generator);
                break;
            }
            case "set-statistics": {
                MetadataUpdateParser.writeSetStatistics((MetadataUpdate.SetStatistics)metadataUpdate, generator);
                break;
            }
            case "remove-statistics": {
                MetadataUpdateParser.writeRemoveStatistics((MetadataUpdate.RemoveStatistics)metadataUpdate, generator);
                break;
            }
            case "add-snapshot": {
                MetadataUpdateParser.writeAddSnapshot((MetadataUpdate.AddSnapshot)metadataUpdate, generator);
                break;
            }
            case "remove-snapshots": {
                MetadataUpdateParser.writeRemoveSnapshots((MetadataUpdate.RemoveSnapshot)metadataUpdate, generator);
                break;
            }
            case "remove-snapshot-ref": {
                MetadataUpdateParser.writeRemoveSnapshotRef((MetadataUpdate.RemoveSnapshotRef)metadataUpdate, generator);
                break;
            }
            case "set-snapshot-ref": {
                MetadataUpdateParser.writeSetSnapshotRef((MetadataUpdate.SetSnapshotRef)metadataUpdate, generator);
                break;
            }
            case "set-properties": {
                MetadataUpdateParser.writeSetProperties((MetadataUpdate.SetProperties)metadataUpdate, generator);
                break;
            }
            case "remove-properties": {
                MetadataUpdateParser.writeRemoveProperties((MetadataUpdate.RemoveProperties)metadataUpdate, generator);
                break;
            }
            case "set-location": {
                MetadataUpdateParser.writeSetLocation((MetadataUpdate.SetLocation)metadataUpdate, generator);
                break;
            }
            case "add-view-version": {
                MetadataUpdateParser.writeAddViewVersion((MetadataUpdate.AddViewVersion)metadataUpdate, generator);
                break;
            }
            case "set-current-view-version": {
                MetadataUpdateParser.writeSetCurrentViewVersionId((MetadataUpdate.SetCurrentViewVersion)metadataUpdate, generator);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Cannot convert metadata update to json. Unrecognized action: %s", updateAction));
            }
        }
        generator.writeEndObject();
    }

    public static MetadataUpdate fromJson(String json) {
        return JsonUtil.parse(json, MetadataUpdateParser::fromJson);
    }

    public static MetadataUpdate fromJson(JsonNode jsonNode) {
        String action;
        Preconditions.checkArgument(jsonNode != null && jsonNode.isObject(), "Cannot parse metadata update from non-object value: %s", (Object)jsonNode);
        Preconditions.checkArgument(jsonNode.hasNonNull(ACTION), "Cannot parse metadata update. Missing field: action");
        switch (action = JsonUtil.getString(ACTION, jsonNode).toLowerCase(Locale.ROOT)) {
            case "assign-uuid": {
                return MetadataUpdateParser.readAssignUUID(jsonNode);
            }
            case "upgrade-format-version": {
                return MetadataUpdateParser.readUpgradeFormatVersion(jsonNode);
            }
            case "add-schema": {
                return MetadataUpdateParser.readAddSchema(jsonNode);
            }
            case "set-current-schema": {
                return MetadataUpdateParser.readSetCurrentSchema(jsonNode);
            }
            case "add-spec": {
                return MetadataUpdateParser.readAddPartitionSpec(jsonNode);
            }
            case "set-default-spec": {
                return MetadataUpdateParser.readSetDefaultPartitionSpec(jsonNode);
            }
            case "add-sort-order": {
                return MetadataUpdateParser.readAddSortOrder(jsonNode);
            }
            case "set-default-sort-order": {
                return MetadataUpdateParser.readSetDefaultSortOrder(jsonNode);
            }
            case "set-statistics": {
                return MetadataUpdateParser.readSetStatistics(jsonNode);
            }
            case "remove-statistics": {
                return MetadataUpdateParser.readRemoveStatistics(jsonNode);
            }
            case "add-snapshot": {
                return MetadataUpdateParser.readAddSnapshot(jsonNode);
            }
            case "remove-snapshots": {
                return MetadataUpdateParser.readRemoveSnapshots(jsonNode);
            }
            case "remove-snapshot-ref": {
                return MetadataUpdateParser.readRemoveSnapshotRef(jsonNode);
            }
            case "set-snapshot-ref": {
                return MetadataUpdateParser.readSetSnapshotRef(jsonNode);
            }
            case "set-properties": {
                return MetadataUpdateParser.readSetProperties(jsonNode);
            }
            case "remove-properties": {
                return MetadataUpdateParser.readRemoveProperties(jsonNode);
            }
            case "set-location": {
                return MetadataUpdateParser.readSetLocation(jsonNode);
            }
            case "add-view-version": {
                return MetadataUpdateParser.readAddViewVersion(jsonNode);
            }
            case "set-current-view-version": {
                return MetadataUpdateParser.readCurrentViewVersionId(jsonNode);
            }
        }
        throw new UnsupportedOperationException(String.format("Cannot convert metadata update action to json: %s", action));
    }

    private static void writeAssignUUID(MetadataUpdate.AssignUUID update, JsonGenerator gen) throws IOException {
        gen.writeStringField(UUID, update.uuid());
    }

    private static void writeUpgradeFormatVersion(MetadataUpdate.UpgradeFormatVersion update, JsonGenerator gen) throws IOException {
        gen.writeNumberField(FORMAT_VERSION, update.formatVersion());
    }

    private static void writeAddSchema(MetadataUpdate.AddSchema update, JsonGenerator gen) throws IOException {
        gen.writeFieldName(SCHEMA);
        SchemaParser.toJson(update.schema(), gen);
        gen.writeNumberField(LAST_COLUMN_ID, update.lastColumnId());
    }

    private static void writeSetCurrentSchema(MetadataUpdate.SetCurrentSchema update, JsonGenerator gen) throws IOException {
        gen.writeNumberField(SCHEMA_ID, update.schemaId());
    }

    private static void writeAddPartitionSpec(MetadataUpdate.AddPartitionSpec update, JsonGenerator gen) throws IOException {
        gen.writeFieldName(SPEC);
        PartitionSpecParser.toJson(update.spec(), gen);
    }

    private static void writeSetDefaultPartitionSpec(MetadataUpdate.SetDefaultPartitionSpec update, JsonGenerator gen) throws IOException {
        gen.writeNumberField(SPEC_ID, update.specId());
    }

    private static void writeAddSortOrder(MetadataUpdate.AddSortOrder update, JsonGenerator gen) throws IOException {
        gen.writeFieldName(SORT_ORDER);
        SortOrderParser.toJson(update.sortOrder(), gen);
    }

    private static void writeSetDefaultSortOrder(MetadataUpdate.SetDefaultSortOrder update, JsonGenerator gen) throws IOException {
        gen.writeNumberField(SORT_ORDER_ID, update.sortOrderId());
    }

    private static void writeSetStatistics(MetadataUpdate.SetStatistics update, JsonGenerator gen) throws IOException {
        gen.writeNumberField(SNAPSHOT_ID, update.snapshotId());
        gen.writeFieldName(STATISTICS);
        StatisticsFileParser.toJson(update.statisticsFile(), gen);
    }

    private static void writeRemoveStatistics(MetadataUpdate.RemoveStatistics update, JsonGenerator gen) throws IOException {
        gen.writeNumberField(SNAPSHOT_ID, update.snapshotId());
    }

    private static void writeAddSnapshot(MetadataUpdate.AddSnapshot update, JsonGenerator gen) throws IOException {
        gen.writeFieldName(SNAPSHOT);
        SnapshotParser.toJson(update.snapshot(), gen);
    }

    private static void writeRemoveSnapshots(MetadataUpdate.RemoveSnapshot update, JsonGenerator gen) throws IOException {
        JsonUtil.writeLongArray(SNAPSHOT_IDS, ImmutableSet.of(Long.valueOf(update.snapshotId())), gen);
    }

    private static void writeSetSnapshotRef(MetadataUpdate.SetSnapshotRef update, JsonGenerator gen) throws IOException {
        gen.writeStringField(REF_NAME, update.name());
        gen.writeNumberField(SNAPSHOT_ID, update.snapshotId());
        gen.writeStringField(TYPE, update.type());
        JsonUtil.writeIntegerFieldIf(update.minSnapshotsToKeep() != null, MIN_SNAPSHOTS_TO_KEEP, update.minSnapshotsToKeep(), gen);
        JsonUtil.writeLongFieldIf(update.maxSnapshotAgeMs() != null, MAX_SNAPSHOT_AGE_MS, update.maxSnapshotAgeMs(), gen);
        JsonUtil.writeLongFieldIf(update.maxRefAgeMs() != null, MAX_REF_AGE_MS, update.maxRefAgeMs(), gen);
    }

    private static void writeRemoveSnapshotRef(MetadataUpdate.RemoveSnapshotRef update, JsonGenerator gen) throws IOException {
        gen.writeStringField(REF_NAME, update.name());
    }

    private static void writeSetProperties(MetadataUpdate.SetProperties update, JsonGenerator gen) throws IOException {
        gen.writeFieldName(UPDATES);
        gen.writeObject(update.updated());
    }

    private static void writeRemoveProperties(MetadataUpdate.RemoveProperties update, JsonGenerator gen) throws IOException {
        gen.writeFieldName(REMOVALS);
        gen.writeObject(update.removed());
    }

    private static void writeSetLocation(MetadataUpdate.SetLocation update, JsonGenerator gen) throws IOException {
        gen.writeStringField(LOCATION, update.location());
    }

    private static void writeAddViewVersion(MetadataUpdate.AddViewVersion metadataUpdate, JsonGenerator gen) throws IOException {
        gen.writeFieldName(VIEW_VERSION);
        ViewVersionParser.toJson(metadataUpdate.viewVersion(), gen);
    }

    private static void writeSetCurrentViewVersionId(MetadataUpdate.SetCurrentViewVersion metadataUpdate, JsonGenerator gen) throws IOException {
        gen.writeNumberField(VIEW_VERSION_ID, metadataUpdate.versionId());
    }

    private static MetadataUpdate readAssignUUID(JsonNode node) {
        String uuid = JsonUtil.getString(UUID, node);
        return new MetadataUpdate.AssignUUID(uuid);
    }

    private static MetadataUpdate readUpgradeFormatVersion(JsonNode node) {
        int formatVersion = JsonUtil.getInt(FORMAT_VERSION, node);
        return new MetadataUpdate.UpgradeFormatVersion(formatVersion);
    }

    private static MetadataUpdate readAddSchema(JsonNode node) {
        JsonNode schemaNode = JsonUtil.get(SCHEMA, node);
        Schema schema = SchemaParser.fromJson(schemaNode);
        int lastColumnId = node.has(LAST_COLUMN_ID) ? JsonUtil.getInt(LAST_COLUMN_ID, node) : schema.highestFieldId();
        return new MetadataUpdate.AddSchema(schema, lastColumnId);
    }

    private static MetadataUpdate readSetCurrentSchema(JsonNode node) {
        int schemaId = JsonUtil.getInt(SCHEMA_ID, node);
        return new MetadataUpdate.SetCurrentSchema(schemaId);
    }

    private static MetadataUpdate readAddPartitionSpec(JsonNode node) {
        JsonNode specNode = JsonUtil.get(SPEC, node);
        UnboundPartitionSpec spec = PartitionSpecParser.fromJson(specNode);
        return new MetadataUpdate.AddPartitionSpec(spec);
    }

    private static MetadataUpdate readSetDefaultPartitionSpec(JsonNode node) {
        int specId = JsonUtil.getInt(SPEC_ID, node);
        return new MetadataUpdate.SetDefaultPartitionSpec(specId);
    }

    private static MetadataUpdate readAddSortOrder(JsonNode node) {
        JsonNode sortOrderNode = JsonUtil.get(SORT_ORDER, node);
        UnboundSortOrder sortOrder = SortOrderParser.fromJson(sortOrderNode);
        return new MetadataUpdate.AddSortOrder(sortOrder);
    }

    private static MetadataUpdate readSetDefaultSortOrder(JsonNode node) {
        int sortOrderId = JsonUtil.getInt(SORT_ORDER_ID, node);
        return new MetadataUpdate.SetDefaultSortOrder(sortOrderId);
    }

    private static MetadataUpdate readSetStatistics(JsonNode node) {
        long snapshotId = JsonUtil.getLong(SNAPSHOT_ID, node);
        JsonNode statisticsFileNode = JsonUtil.get(STATISTICS, node);
        StatisticsFile statisticsFile = StatisticsFileParser.fromJson(statisticsFileNode);
        return new MetadataUpdate.SetStatistics(snapshotId, statisticsFile);
    }

    private static MetadataUpdate readRemoveStatistics(JsonNode node) {
        long snapshotId = JsonUtil.getLong(SNAPSHOT_ID, node);
        return new MetadataUpdate.RemoveStatistics(snapshotId);
    }

    private static MetadataUpdate readAddSnapshot(JsonNode node) {
        Snapshot snapshot = SnapshotParser.fromJson(JsonUtil.get(SNAPSHOT, node));
        return new MetadataUpdate.AddSnapshot(snapshot);
    }

    private static MetadataUpdate readRemoveSnapshots(JsonNode node) {
        Set<Long> snapshotIds = JsonUtil.getLongSetOrNull(SNAPSHOT_IDS, node);
        Preconditions.checkArgument(snapshotIds != null && snapshotIds.size() == 1, "Invalid set of snapshot ids to remove. Expected one value but received: %s", snapshotIds);
        Long snapshotId = Iterables.getOnlyElement(snapshotIds);
        return new MetadataUpdate.RemoveSnapshot(snapshotId);
    }

    private static MetadataUpdate readSetSnapshotRef(JsonNode node) {
        String refName = JsonUtil.getString(REF_NAME, node);
        long snapshotId = JsonUtil.getLong(SNAPSHOT_ID, node);
        SnapshotRefType type = SnapshotRefType.fromString(JsonUtil.getString(TYPE, node));
        Integer minSnapshotsToKeep = JsonUtil.getIntOrNull(MIN_SNAPSHOTS_TO_KEEP, node);
        Long maxSnapshotAgeMs = JsonUtil.getLongOrNull(MAX_SNAPSHOT_AGE_MS, node);
        Long maxRefAgeMs = JsonUtil.getLongOrNull(MAX_REF_AGE_MS, node);
        return new MetadataUpdate.SetSnapshotRef(refName, snapshotId, type, minSnapshotsToKeep, maxSnapshotAgeMs, maxRefAgeMs);
    }

    private static MetadataUpdate readRemoveSnapshotRef(JsonNode node) {
        String refName = JsonUtil.getString(REF_NAME, node);
        return new MetadataUpdate.RemoveSnapshotRef(refName);
    }

    private static MetadataUpdate readSetProperties(JsonNode node) {
        boolean hasLegacyField = node.has(UPDATED);
        boolean hasUpdatesField = node.has(UPDATES);
        Map<String, String> updates = hasLegacyField && hasUpdatesField ? JsonUtil.getStringMap(UPDATES, node) : (hasLegacyField ? JsonUtil.getStringMap(UPDATED, node) : JsonUtil.getStringMap(UPDATES, node));
        return new MetadataUpdate.SetProperties(updates);
    }

    private static MetadataUpdate readRemoveProperties(JsonNode node) {
        boolean hasLegacyField = node.has(REMOVED);
        boolean hasRemovalsField = node.has(REMOVALS);
        Set<String> removals = hasLegacyField && hasRemovalsField ? JsonUtil.getStringSet(REMOVALS, node) : (hasLegacyField ? JsonUtil.getStringSet(REMOVED, node) : JsonUtil.getStringSet(REMOVALS, node));
        return new MetadataUpdate.RemoveProperties(removals);
    }

    private static MetadataUpdate readSetLocation(JsonNode node) {
        String location = JsonUtil.getString(LOCATION, node);
        return new MetadataUpdate.SetLocation(location);
    }

    private static MetadataUpdate readAddViewVersion(JsonNode node) {
        return new MetadataUpdate.AddViewVersion(ViewVersionParser.fromJson(JsonUtil.get(VIEW_VERSION, node)));
    }

    private static MetadataUpdate readCurrentViewVersionId(JsonNode node) {
        return new MetadataUpdate.SetCurrentViewVersion(JsonUtil.getInt(VIEW_VERSION_ID, node));
    }
}

