/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.FileStatus;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileContent;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.GenericDeleteFile;
import org.apache.iceberg.Metrics;
import org.apache.iceberg.PartitionData;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.encryption.EncryptedOutputFile;
import org.apache.iceberg.encryption.EncryptionKeyMetadata;
import org.apache.iceberg.hadoop.HadoopInputFile;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.util.ByteBuffers;

public class FileMetadata {
    private FileMetadata() {
    }

    public static Builder deleteFileBuilder(PartitionSpec spec) {
        return new Builder(spec);
    }

    public static class Builder {
        private final PartitionSpec spec;
        private final boolean isPartitioned;
        private final int specId;
        private FileContent content = null;
        private int[] equalityFieldIds = null;
        private PartitionData partitionData;
        private String filePath = null;
        private FileFormat format = null;
        private long recordCount = -1L;
        private long fileSizeInBytes = -1L;
        private Map<Integer, Long> columnSizes = null;
        private Map<Integer, Long> valueCounts = null;
        private Map<Integer, Long> nullValueCounts = null;
        private Map<Integer, Long> nanValueCounts = null;
        private Map<Integer, ByteBuffer> lowerBounds = null;
        private Map<Integer, ByteBuffer> upperBounds = null;
        private ByteBuffer keyMetadata = null;
        private Integer sortOrderId = null;
        private List<Long> splitOffsets = null;

        Builder(PartitionSpec spec) {
            this.spec = spec;
            this.specId = spec.specId();
            this.isPartitioned = spec.isPartitioned();
            this.partitionData = this.isPartitioned ? DataFiles.newPartitionData(spec) : null;
        }

        public void clear() {
            if (this.isPartitioned) {
                this.partitionData.clear();
            }
            this.filePath = null;
            this.format = null;
            this.recordCount = -1L;
            this.fileSizeInBytes = -1L;
            this.columnSizes = null;
            this.valueCounts = null;
            this.nullValueCounts = null;
            this.nanValueCounts = null;
            this.lowerBounds = null;
            this.upperBounds = null;
            this.sortOrderId = null;
        }

        public Builder copy(DeleteFile toCopy) {
            if (this.isPartitioned) {
                Preconditions.checkState(this.specId == toCopy.specId(), "Cannot copy a DeleteFile with a different spec");
                this.partitionData = DataFiles.copyPartitionData(this.spec, toCopy.partition(), this.partitionData);
            }
            this.content = toCopy.content();
            this.filePath = toCopy.path().toString();
            this.format = toCopy.format();
            this.recordCount = toCopy.recordCount();
            this.fileSizeInBytes = toCopy.fileSizeInBytes();
            this.columnSizes = toCopy.columnSizes();
            this.valueCounts = toCopy.valueCounts();
            this.nullValueCounts = toCopy.nullValueCounts();
            this.nanValueCounts = toCopy.nanValueCounts();
            this.lowerBounds = toCopy.lowerBounds();
            this.upperBounds = toCopy.upperBounds();
            this.keyMetadata = toCopy.keyMetadata() == null ? null : ByteBuffers.copy(toCopy.keyMetadata());
            this.sortOrderId = toCopy.sortOrderId();
            return this;
        }

        public Builder ofPositionDeletes() {
            this.content = FileContent.POSITION_DELETES;
            this.equalityFieldIds = null;
            return this;
        }

        public Builder ofEqualityDeletes(int ... fieldIds) {
            this.content = FileContent.EQUALITY_DELETES;
            this.equalityFieldIds = fieldIds;
            return this;
        }

        public Builder withStatus(FileStatus stat) {
            this.filePath = stat.getPath().toString();
            this.fileSizeInBytes = stat.getLen();
            return this;
        }

        public Builder withInputFile(InputFile file) {
            if (file instanceof HadoopInputFile) {
                return this.withStatus(((HadoopInputFile)file).getStat());
            }
            this.filePath = file.location();
            this.fileSizeInBytes = file.getLength();
            return this;
        }

        public Builder withEncryptedOutputFile(EncryptedOutputFile newEncryptedFile) {
            this.withInputFile(newEncryptedFile.encryptingOutputFile().toInputFile());
            this.withEncryptionKeyMetadata(newEncryptedFile.keyMetadata());
            return this;
        }

        public Builder withPath(String newFilePath) {
            this.filePath = newFilePath;
            return this;
        }

        public Builder withFormat(String newFormat) {
            this.format = FileFormat.fromString(newFormat);
            return this;
        }

        public Builder withFormat(FileFormat newFormat) {
            this.format = newFormat;
            return this;
        }

        public Builder withPartition(StructLike newPartition) {
            if (this.isPartitioned) {
                this.partitionData = DataFiles.copyPartitionData(this.spec, newPartition, this.partitionData);
            }
            return this;
        }

        public Builder withRecordCount(long newRecordCount) {
            this.recordCount = newRecordCount;
            return this;
        }

        public Builder withFileSizeInBytes(long newFileSizeInBytes) {
            this.fileSizeInBytes = newFileSizeInBytes;
            return this;
        }

        public Builder withPartitionPath(String newPartitionPath) {
            Preconditions.checkArgument(this.isPartitioned || newPartitionPath.isEmpty(), "Cannot add partition data for an unpartitioned table");
            if (!newPartitionPath.isEmpty()) {
                this.partitionData = DataFiles.fillFromPath(this.spec, newPartitionPath, this.partitionData);
            }
            return this;
        }

        public Builder withMetrics(Metrics metrics) {
            this.recordCount = metrics.recordCount() == null ? -1L : metrics.recordCount();
            this.columnSizes = metrics.columnSizes();
            this.valueCounts = metrics.valueCounts();
            this.nullValueCounts = metrics.nullValueCounts();
            this.nanValueCounts = metrics.nanValueCounts();
            this.lowerBounds = metrics.lowerBounds();
            this.upperBounds = metrics.upperBounds();
            return this;
        }

        public Builder withSplitOffsets(List<Long> offsets) {
            this.splitOffsets = offsets != null ? ImmutableList.copyOf(offsets) : null;
            return this;
        }

        public Builder withEncryptionKeyMetadata(ByteBuffer newKeyMetadata) {
            this.keyMetadata = newKeyMetadata;
            return this;
        }

        public Builder withEncryptionKeyMetadata(EncryptionKeyMetadata newKeyMetadata) {
            return this.withEncryptionKeyMetadata(newKeyMetadata.buffer());
        }

        public Builder withSortOrder(SortOrder newSortOrder) {
            if (newSortOrder != null) {
                this.sortOrderId = newSortOrder.orderId();
            }
            return this;
        }

        public DeleteFile build() {
            Preconditions.checkArgument(this.filePath != null, "File path is required");
            if (this.format == null) {
                this.format = FileFormat.fromFileName(this.filePath);
            }
            Preconditions.checkArgument(this.content != null, "Delete type is required");
            Preconditions.checkArgument(this.format != null, "File format is required");
            Preconditions.checkArgument(this.fileSizeInBytes >= 0L, "File size is required");
            Preconditions.checkArgument(this.recordCount >= 0L, "Record count is required");
            switch (this.content) {
                case POSITION_DELETES: {
                    Preconditions.checkArgument(this.sortOrderId == null, "Position delete file should not have sort order");
                    break;
                }
                case EQUALITY_DELETES: {
                    if (this.sortOrderId != null) break;
                    this.sortOrderId = SortOrder.unsorted().orderId();
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown content type " + (Object)((Object)this.content));
                }
            }
            return new GenericDeleteFile(this.specId, this.content, this.filePath, this.format, this.isPartitioned ? DataFiles.copy(this.spec, this.partitionData) : null, this.fileSizeInBytes, new Metrics(this.recordCount, this.columnSizes, this.valueCounts, this.nullValueCounts, this.nanValueCounts, this.lowerBounds, this.upperBounds), this.equalityFieldIds, this.sortOrderId, this.splitOffsets, this.keyMetadata);
        }
    }
}

