/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.compress.bzip2;

import io.airlift.compress.bzip2.Crc32;
import java.io.IOException;
import java.io.OutputStream;

class CBZip2OutputStream
extends OutputStream {
    private static final int MAX_BLOCK_SIZE = 9;
    private static final int[] R_NUMS = new int[]{619, 720, 127, 481, 931, 816, 813, 233, 566, 247, 985, 724, 205, 454, 863, 491, 741, 242, 949, 214, 733, 859, 335, 708, 621, 574, 73, 654, 730, 472, 419, 436, 278, 496, 867, 210, 399, 680, 480, 51, 878, 465, 811, 169, 869, 675, 611, 697, 867, 561, 862, 687, 507, 283, 482, 129, 807, 591, 733, 623, 150, 238, 59, 379, 684, 877, 625, 169, 643, 105, 170, 607, 520, 932, 727, 476, 693, 425, 174, 647, 73, 122, 335, 530, 442, 853, 695, 249, 445, 515, 909, 545, 703, 919, 874, 474, 882, 500, 594, 612, 641, 801, 220, 162, 819, 984, 589, 513, 495, 799, 161, 604, 958, 533, 221, 400, 386, 867, 600, 782, 382, 596, 414, 171, 516, 375, 682, 485, 911, 276, 98, 553, 163, 354, 666, 933, 424, 341, 533, 870, 227, 730, 475, 186, 263, 647, 537, 686, 600, 224, 469, 68, 770, 919, 190, 373, 294, 822, 808, 206, 184, 943, 795, 384, 383, 461, 404, 758, 839, 887, 715, 67, 618, 276, 204, 918, 873, 777, 604, 560, 951, 160, 578, 722, 79, 804, 96, 409, 713, 940, 652, 934, 970, 447, 318, 353, 859, 672, 112, 785, 645, 863, 803, 350, 139, 93, 354, 99, 820, 908, 609, 772, 154, 274, 580, 184, 79, 626, 630, 742, 653, 282, 762, 623, 680, 81, 927, 626, 789, 125, 411, 521, 938, 300, 821, 78, 343, 175, 128, 250, 170, 774, 972, 275, 999, 639, 495, 78, 352, 126, 857, 956, 358, 619, 580, 124, 737, 594, 701, 612, 669, 112, 134, 694, 363, 992, 809, 743, 168, 974, 944, 375, 748, 52, 600, 747, 642, 182, 862, 81, 344, 805, 988, 739, 511, 655, 814, 334, 249, 515, 897, 955, 664, 981, 649, 113, 974, 459, 893, 228, 433, 837, 553, 268, 926, 240, 102, 654, 459, 51, 686, 754, 806, 760, 493, 403, 415, 394, 687, 700, 946, 670, 656, 610, 738, 392, 760, 799, 887, 653, 978, 321, 576, 617, 626, 502, 894, 679, 243, 440, 680, 879, 194, 572, 640, 724, 926, 56, 204, 700, 707, 151, 457, 449, 797, 195, 791, 558, 945, 679, 297, 59, 87, 824, 713, 663, 412, 693, 342, 606, 134, 108, 571, 364, 631, 212, 174, 643, 304, 329, 343, 97, 430, 751, 497, 314, 983, 374, 822, 928, 140, 206, 73, 263, 980, 736, 876, 478, 430, 305, 170, 514, 364, 692, 829, 82, 855, 953, 676, 246, 369, 970, 294, 750, 807, 827, 150, 790, 288, 923, 804, 378, 215, 828, 592, 281, 565, 555, 710, 82, 896, 831, 547, 261, 524, 462, 293, 465, 502, 56, 661, 821, 976, 991, 658, 869, 905, 758, 745, 193, 768, 550, 608, 933, 378, 286, 215, 979, 792, 961, 61, 688, 793, 644, 986, 403, 106, 366, 905, 644, 372, 567, 466, 434, 645, 210, 389, 550, 919, 135, 780, 773, 635, 389, 707, 100, 626, 958, 165, 504, 920, 176, 193, 713, 857, 265, 203, 50, 668, 108, 645, 990, 626, 197, 510, 357, 358, 850, 858, 364, 936, 638};
    private static final int N_ITERS = 4;
    private static final int NUM_OVERSHOOT_BYTES = 20;
    private static final int SET_MASK = 0x200000;
    private static final int CLEAR_MASK = -2097153;
    private static final int GREATER_ICOST = 15;
    private static final int LESSER_ICOST = 0;
    private static final int SMALL_THRESH = 20;
    private static final int DEPTH_THRESH = 10;
    private static final int WORK_FACTOR = 30;
    private static final int QSORT_STACK_SIZE = 1000;
    private static final int[] INCS = new int[]{1, 4, 13, 40, 121, 364, 1093, 3280, 9841, 29524, 88573, 265720, 797161, 2391484};
    private int last;
    private int origPtr;
    private final int blockSize100k;
    private boolean blockRandomised;
    private int bsBuff;
    private int bsLive;
    private final Crc32 crc32 = new Crc32();
    private int nInUse;
    private int nMTF;
    private int workDone;
    private int workLimit;
    private boolean firstAttempt;
    private int currentChar = -1;
    private int runLength;
    private int combinedCRC;
    private int allowableBlockSize;
    private Data data;
    private OutputStream out;

    private static void hbMakeCodeLengths(byte[] len, int[] freq, Data dat, int alphaSize, int maxLen) {
        int[] heap = dat.heap;
        int[] weight = dat.weight;
        int[] parent = dat.parent;
        int i = alphaSize;
        while (--i >= 0) {
            weight[i + 1] = (freq[i] == 0 ? 1 : freq[i]) << 8;
        }
        boolean tooLong = true;
        while (tooLong) {
            int j;
            int i2;
            tooLong = false;
            int nNodes = alphaSize;
            int nHeap = 0;
            heap[0] = 0;
            weight[0] = 0;
            parent[0] = -2;
            for (i2 = 1; i2 <= alphaSize; ++i2) {
                parent[i2] = -1;
                heap[++nHeap] = i2;
                int zz = nHeap;
                int tmp = heap[zz];
                while (weight[tmp] < weight[heap[zz >> 1]]) {
                    heap[zz] = heap[zz >> 1];
                    zz >>= 1;
                }
                heap[zz] = tmp;
            }
            while (nHeap > 1) {
                int yy;
                int n1 = heap[1];
                heap[1] = heap[nHeap];
                --nHeap;
                int zz = 1;
                int tmp = heap[1];
                while ((yy = zz << 1) <= nHeap) {
                    if (yy < nHeap && weight[heap[yy + 1]] < weight[heap[yy]]) {
                        ++yy;
                    }
                    if (weight[tmp] < weight[heap[yy]]) break;
                    heap[zz] = heap[yy];
                    zz = yy;
                }
                heap[zz] = tmp;
                int n2 = heap[1];
                heap[1] = heap[nHeap];
                --nHeap;
                zz = 1;
                tmp = heap[1];
                while ((yy = zz << 1) <= nHeap) {
                    if (yy < nHeap && weight[heap[yy + 1]] < weight[heap[yy]]) {
                        ++yy;
                    }
                    if (weight[tmp] < weight[heap[yy]]) break;
                    heap[zz] = heap[yy];
                    zz = yy;
                }
                heap[zz] = tmp;
                parent[n1] = ++nNodes;
                parent[n2] = nNodes;
                int weightN1 = weight[n1];
                int weightN2 = weight[n2];
                weight[nNodes] = (weightN1 & 0xFFFFFF00) + (weightN2 & 0xFFFFFF00) | 1 + Math.max(weightN1 & 0xFF, weightN2 & 0xFF);
                parent[nNodes] = -1;
                heap[++nHeap] = nNodes;
                zz = nHeap;
                tmp = heap[zz];
                int weightTmp = weight[tmp];
                while (weightTmp < weight[heap[zz >> 1]]) {
                    heap[zz] = heap[zz >> 1];
                    zz >>= 1;
                }
                heap[zz] = tmp;
            }
            for (i2 = 1; i2 <= alphaSize; ++i2) {
                int parentK;
                j = 0;
                int k = i2;
                while ((parentK = parent[k]) >= 0) {
                    k = parentK;
                    ++j;
                }
                len[i2 - 1] = (byte)j;
                if (j <= maxLen) continue;
                tooLong = true;
            }
            if (!tooLong) continue;
            for (i2 = 1; i2 < alphaSize; ++i2) {
                j = weight[i2] >> 8;
                j = 1 + (j >> 1);
                weight[i2] = j << 8;
            }
        }
    }

    public CBZip2OutputStream(OutputStream out) throws IOException {
        this(out, 9);
    }

    private CBZip2OutputStream(OutputStream out, int blockSize) throws IOException {
        if (blockSize < 1) {
            throw new IllegalArgumentException("blockSize(" + blockSize + ") < 1");
        }
        if (blockSize > 9) {
            throw new IllegalArgumentException("blockSize(" + blockSize + ") > 9");
        }
        this.blockSize100k = blockSize;
        this.out = out;
        this.init();
    }

    @Override
    public void write(int b) throws IOException {
        if (this.out == null) {
            throw new IOException("closed");
        }
        this.write0(b);
    }

    private void writeRun() throws IOException {
        int lastShadow = this.last;
        if (lastShadow < this.allowableBlockSize) {
            int currentCharShadow = this.currentChar;
            Data dataShadow = this.data;
            dataShadow.inUse[currentCharShadow] = true;
            byte ch = (byte)currentCharShadow;
            int runLengthShadow = this.runLength;
            this.crc32.updateCRC(currentCharShadow, runLengthShadow);
            switch (runLengthShadow) {
                case 1: {
                    dataShadow.block[lastShadow + 2] = ch;
                    this.last = lastShadow + 1;
                    break;
                }
                case 2: {
                    dataShadow.block[lastShadow + 2] = ch;
                    dataShadow.block[lastShadow + 3] = ch;
                    this.last = lastShadow + 2;
                    break;
                }
                case 3: {
                    byte[] block = dataShadow.block;
                    block[lastShadow + 2] = ch;
                    block[lastShadow + 3] = ch;
                    block[lastShadow + 4] = ch;
                    this.last = lastShadow + 3;
                    break;
                }
                default: {
                    dataShadow.inUse[runLengthShadow -= 4] = true;
                    byte[] block = dataShadow.block;
                    block[lastShadow + 2] = ch;
                    block[lastShadow + 3] = ch;
                    block[lastShadow + 4] = ch;
                    block[lastShadow + 5] = ch;
                    block[lastShadow + 6] = (byte)runLengthShadow;
                    this.last = lastShadow + 5;
                    break;
                }
            }
        } else {
            this.endBlock();
            this.initBlock();
            this.writeRun();
        }
    }

    protected void finalize() throws Throwable {
        this.finish();
        super.finalize();
    }

    public void finish() throws IOException {
        if (this.out != null) {
            try {
                if (this.runLength > 0) {
                    this.writeRun();
                }
                this.currentChar = -1;
                this.endBlock();
                this.endCompression();
            }
            finally {
                this.out = null;
                this.data = null;
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.out != null) {
            try (OutputStream outShadow = this.out;){
                this.finish();
                outShadow.close();
                outShadow = null;
            }
        }
    }

    @Override
    public void flush() throws IOException {
        OutputStream outShadow = this.out;
        if (outShadow != null) {
            outShadow.flush();
        }
    }

    private void init() throws IOException {
        this.data = new Data(this.blockSize100k);
        this.bsPutUByte(104);
        this.bsPutUByte(48 + this.blockSize100k);
        this.combinedCRC = 0;
        this.initBlock();
    }

    private void initBlock() {
        this.crc32.initialiseCRC();
        this.last = -1;
        boolean[] inUse = this.data.inUse;
        int i = 256;
        while (--i >= 0) {
            inUse[i] = false;
        }
        this.allowableBlockSize = this.blockSize100k * 100000 - 20;
    }

    private void endBlock() throws IOException {
        int blockCRC = this.crc32.getFinalCRC();
        this.combinedCRC = this.combinedCRC << 1 | this.combinedCRC >>> 31;
        this.combinedCRC ^= blockCRC;
        if (this.last == -1) {
            return;
        }
        this.blockSort();
        this.bsPutUByte(49);
        this.bsPutUByte(65);
        this.bsPutUByte(89);
        this.bsPutUByte(38);
        this.bsPutUByte(83);
        this.bsPutUByte(89);
        this.bsPutInt(blockCRC);
        if (this.blockRandomised) {
            this.bsW(1, 1);
        } else {
            this.bsW(1, 0);
        }
        this.moveToFrontCodeAndSend();
    }

    private void endCompression() throws IOException {
        this.bsPutUByte(23);
        this.bsPutUByte(114);
        this.bsPutUByte(69);
        this.bsPutUByte(56);
        this.bsPutUByte(80);
        this.bsPutUByte(144);
        this.bsPutInt(this.combinedCRC);
        this.bsFinishedWithStream();
    }

    @Override
    public void write(byte[] buf, int offs, int len) throws IOException {
        if (offs < 0) {
            throw new IndexOutOfBoundsException("offs(" + offs + ") < 0.");
        }
        if (len < 0) {
            throw new IndexOutOfBoundsException("len(" + len + ") < 0.");
        }
        if (offs + len > buf.length) {
            throw new IndexOutOfBoundsException("offs(" + offs + ") + len(" + len + ") > buf.length(" + buf.length + ").");
        }
        if (this.out == null) {
            throw new IOException("stream closed");
        }
        int hi = offs + len;
        while (offs < hi) {
            this.write0(buf[offs++]);
        }
    }

    private void write0(int b) throws IOException {
        if (this.currentChar != -1) {
            if (this.currentChar == (b &= 0xFF)) {
                if (++this.runLength > 254) {
                    this.writeRun();
                    this.currentChar = -1;
                    this.runLength = 0;
                }
            } else {
                this.writeRun();
                this.runLength = 1;
                this.currentChar = b;
            }
        } else {
            this.currentChar = b & 0xFF;
            ++this.runLength;
        }
    }

    private static void hbAssignCodes(int[] code, byte[] length, int minLen, int maxLen, int alphaSize) {
        int vec = 0;
        for (int n = minLen; n <= maxLen; ++n) {
            for (int i = 0; i < alphaSize; ++i) {
                if ((length[i] & 0xFF) != n) continue;
                code[i] = vec++;
            }
            vec <<= 1;
        }
    }

    private void bsFinishedWithStream() throws IOException {
        while (this.bsLive > 0) {
            int ch = this.bsBuff >> 24;
            this.out.write(ch);
            this.bsBuff <<= 8;
            this.bsLive -= 8;
        }
    }

    private void bsW(int n, int v) throws IOException {
        int bsLiveShadow;
        OutputStream outShadow = this.out;
        int bsBuffShadow = this.bsBuff;
        for (bsLiveShadow = this.bsLive; bsLiveShadow >= 8; bsLiveShadow -= 8) {
            outShadow.write(bsBuffShadow >> 24);
            bsBuffShadow <<= 8;
        }
        this.bsBuff = bsBuffShadow | v << 32 - bsLiveShadow - n;
        this.bsLive = bsLiveShadow + n;
    }

    private void bsPutUByte(int c) throws IOException {
        this.bsW(8, c);
    }

    private void bsPutInt(int u) throws IOException {
        this.bsW(8, u >> 24 & 0xFF);
        this.bsW(8, u >> 16 & 0xFF);
        this.bsW(8, u >> 8 & 0xFF);
        this.bsW(8, u & 0xFF);
    }

    private void sendMTFValues() throws IOException {
        byte[][] len = this.data.sendMTFValuesLen;
        int alphaSize = this.nInUse + 2;
        int t = 6;
        while (--t >= 0) {
            byte[] lenT = len[t];
            int v = alphaSize;
            while (--v >= 0) {
                lenT[v] = 15;
            }
        }
        int nGroups = this.nMTF < 200 ? 2 : (this.nMTF < 600 ? 3 : (this.nMTF < 1200 ? 4 : (this.nMTF < 2400 ? 5 : 6)));
        this.sendMTFValues0(nGroups, alphaSize);
        int nSelectors = this.sendMTFValues1(nGroups, alphaSize);
        this.sendMTFValues2(nGroups, nSelectors);
        this.sendMTFValues3(nGroups, alphaSize);
        this.sendMTFValues4();
        this.sendMTFValues5(nGroups, nSelectors);
        this.sendMTFValues6(nGroups, alphaSize);
        this.sendMTFValues7();
    }

    private void sendMTFValues0(int nGroups, int alphaSize) {
        byte[][] len = this.data.sendMTFValuesLen;
        int[] mtfFreq = this.data.mtfFreq;
        int remF = this.nMTF;
        int gs = 0;
        for (int nPart = nGroups; nPart > 0; --nPart) {
            int aFreq;
            int tFreq = remF / nPart;
            int ge = gs - 1;
            int a = alphaSize - 1;
            for (aFreq = 0; aFreq < tFreq && ge < a; aFreq += mtfFreq[++ge]) {
            }
            if (ge > gs && nPart != nGroups && nPart != 1 && (nGroups - nPart & 1) != 0) {
                aFreq -= mtfFreq[ge--];
            }
            byte[] lenNp = len[nPart - 1];
            int v = alphaSize;
            while (--v >= 0) {
                if (v >= gs && v <= ge) {
                    lenNp[v] = 0;
                    continue;
                }
                lenNp[v] = 15;
            }
            gs = ge + 1;
            remF -= aFreq;
        }
    }

    private int sendMTFValues1(int nGroups, int alphaSize) {
        Data dataShadow = this.data;
        int[][] rfreq = dataShadow.sendMTFValuesRfreq;
        int[] fave = dataShadow.sendMTFValuesFave;
        short[] cost = dataShadow.sendMTFValuesCost;
        char[] sfmap = dataShadow.sfmap;
        byte[] selector = dataShadow.selector;
        byte[][] len = dataShadow.sendMTFValuesLen;
        byte[] len0 = len[0];
        byte[] len1 = len[1];
        byte[] len2 = len[2];
        byte[] len3 = len[3];
        byte[] len4 = len[4];
        byte[] len5 = len[5];
        int nMTFShadow = this.nMTF;
        int nSelectors = 0;
        for (int iter = 0; iter < 4; ++iter) {
            int i;
            int t = nGroups;
            while (--t >= 0) {
                fave[t] = 0;
                int[] rfreqt = rfreq[t];
                i = alphaSize;
                while (--i >= 0) {
                    rfreqt[i] = 0;
                }
            }
            nSelectors = 0;
            int gs = 0;
            while (gs < this.nMTF) {
                int n;
                int ge = Math.min(gs + 50 - 1, nMTFShadow - 1);
                if (nGroups == 6) {
                    short cost0 = 0;
                    short cost1 = 0;
                    n = 0;
                    short cost3 = 0;
                    short cost4 = 0;
                    short cost5 = 0;
                    for (int i2 = gs; i2 <= ge; ++i2) {
                        char icv = sfmap[i2];
                        cost0 = (short)(cost0 + (len0[icv] & 0xFF));
                        cost1 = (short)(cost1 + (len1[icv] & 0xFF));
                        n = (short)(n + (len2[icv] & 0xFF));
                        cost3 = (short)(cost3 + (len3[icv] & 0xFF));
                        cost4 = (short)(cost4 + (len4[icv] & 0xFF));
                        cost5 = (short)(cost5 + (len5[icv] & 0xFF));
                    }
                    cost[0] = cost0;
                    cost[1] = cost1;
                    cost[2] = n;
                    cost[3] = cost3;
                    cost[4] = cost4;
                    cost[5] = cost5;
                } else {
                    int t2 = nGroups;
                    while (--t2 >= 0) {
                        cost[t2] = 0;
                    }
                    for (i = gs; i <= ge; ++i) {
                        char icv = sfmap[i];
                        n = nGroups;
                        while (--n >= 0) {
                            int n2 = n;
                            cost[n2] = (short)(cost[n2] + (len[n][icv] & 0xFF));
                        }
                    }
                }
                int bt = -1;
                int t4 = nGroups;
                n = 999999999;
                while (--t4 >= 0) {
                    int costT = cost[t4];
                    if (costT >= n) continue;
                    n = costT;
                    bt = t4;
                }
                int n3 = bt;
                fave[n3] = fave[n3] + 1;
                selector[nSelectors] = (byte)bt;
                ++nSelectors;
                int[] rfreqBt = rfreq[bt];
                for (n = gs; n <= ge; ++n) {
                    char c = sfmap[n];
                    rfreqBt[c] = rfreqBt[c] + 1;
                }
                gs = ge + 1;
            }
            for (t = 0; t < nGroups; ++t) {
                CBZip2OutputStream.hbMakeCodeLengths(len[t], rfreq[t], this.data, alphaSize, 20);
            }
        }
        return nSelectors;
    }

    private void sendMTFValues2(int nGroups, int nSelectors) {
        Data dataShadow = this.data;
        byte[] pos = dataShadow.sendMTFValues2Pos;
        int i = nGroups;
        while (--i >= 0) {
            pos[i] = (byte)i;
        }
        for (i = 0; i < nSelectors; ++i) {
            byte llI = dataShadow.selector[i];
            byte tmp = pos[0];
            int j = 0;
            while (llI != tmp) {
                byte tmp2 = tmp;
                tmp = pos[++j];
                pos[j] = tmp2;
            }
            pos[0] = tmp;
            dataShadow.selectorMtf[i] = (byte)j;
        }
    }

    private void sendMTFValues3(int nGroups, int alphaSize) {
        int[][] code = this.data.sendMTFValuesCode;
        byte[][] len = this.data.sendMTFValuesLen;
        for (int t = 0; t < nGroups; ++t) {
            int minLen = 32;
            int maxLen = 0;
            byte[] lenT = len[t];
            int i = alphaSize;
            while (--i >= 0) {
                int l = lenT[i] & 0xFF;
                if (l > maxLen) {
                    maxLen = l;
                }
                if (l >= minLen) continue;
                minLen = l;
            }
            CBZip2OutputStream.hbAssignCodes(code[t], len[t], minLen, maxLen, alphaSize);
        }
    }

    private void sendMTFValues4() throws IOException {
        boolean[] inUse = this.data.inUse;
        boolean[] inUse16 = this.data.sentMTFValues4InUse16;
        int i = 16;
        block0: while (--i >= 0) {
            inUse16[i] = false;
            int i16 = i * 16;
            int j = 16;
            while (--j >= 0) {
                if (!inUse[i16 + j]) continue;
                inUse16[i] = true;
                continue block0;
            }
        }
        for (i = 0; i < 16; ++i) {
            this.bsW(1, inUse16[i] ? 1 : 0);
        }
        OutputStream outShadow = this.out;
        int bsLiveShadow = this.bsLive;
        int bsBuffShadow = this.bsBuff;
        for (int i2 = 0; i2 < 16; ++i2) {
            if (!inUse16[i2]) continue;
            int i16 = i2 * 16;
            for (int j = 0; j < 16; ++j) {
                while (bsLiveShadow >= 8) {
                    outShadow.write(bsBuffShadow >> 24);
                    bsBuffShadow <<= 8;
                    bsLiveShadow -= 8;
                }
                if (inUse[i16 + j]) {
                    bsBuffShadow |= 1 << 32 - bsLiveShadow - 1;
                }
                ++bsLiveShadow;
            }
        }
        this.bsBuff = bsBuffShadow;
        this.bsLive = bsLiveShadow;
    }

    private void sendMTFValues5(int nGroups, int nSelectors) throws IOException {
        this.bsW(3, nGroups);
        this.bsW(15, nSelectors);
        OutputStream outShadow = this.out;
        byte[] selectorMtf = this.data.selectorMtf;
        int bsLiveShadow = this.bsLive;
        int bsBuffShadow = this.bsBuff;
        for (int i = 0; i < nSelectors; ++i) {
            int hj = selectorMtf[i] & 0xFF;
            for (int j = 0; j < hj; ++j) {
                while (bsLiveShadow >= 8) {
                    outShadow.write(bsBuffShadow >> 24);
                    bsBuffShadow <<= 8;
                    bsLiveShadow -= 8;
                }
                bsBuffShadow |= 1 << 32 - bsLiveShadow - 1;
                ++bsLiveShadow;
            }
            while (bsLiveShadow >= 8) {
                outShadow.write(bsBuffShadow >> 24);
                bsBuffShadow <<= 8;
                bsLiveShadow -= 8;
            }
            ++bsLiveShadow;
        }
        this.bsBuff = bsBuffShadow;
        this.bsLive = bsLiveShadow;
    }

    private void sendMTFValues6(int nGroups, int alphaSize) throws IOException {
        byte[][] len = this.data.sendMTFValuesLen;
        OutputStream outShadow = this.out;
        int bsLiveShadow = this.bsLive;
        int bsBuffShadow = this.bsBuff;
        for (int t = 0; t < nGroups; ++t) {
            byte[] lenT = len[t];
            int curr = lenT[0] & 0xFF;
            while (bsLiveShadow >= 8) {
                outShadow.write(bsBuffShadow >> 24);
                bsBuffShadow <<= 8;
                bsLiveShadow -= 8;
            }
            bsBuffShadow |= curr << 32 - bsLiveShadow - 5;
            bsLiveShadow += 5;
            for (int i = 0; i < alphaSize; ++i) {
                int lti = lenT[i] & 0xFF;
                while (curr < lti) {
                    while (bsLiveShadow >= 8) {
                        outShadow.write(bsBuffShadow >> 24);
                        bsBuffShadow <<= 8;
                        bsLiveShadow -= 8;
                    }
                    bsBuffShadow |= 2 << 32 - bsLiveShadow - 2;
                    bsLiveShadow += 2;
                    ++curr;
                }
                while (curr > lti) {
                    while (bsLiveShadow >= 8) {
                        outShadow.write(bsBuffShadow >> 24);
                        bsBuffShadow <<= 8;
                        bsLiveShadow -= 8;
                    }
                    bsBuffShadow |= 3 << 32 - bsLiveShadow - 2;
                    bsLiveShadow += 2;
                    --curr;
                }
                while (bsLiveShadow >= 8) {
                    outShadow.write(bsBuffShadow >> 24);
                    bsBuffShadow <<= 8;
                    bsLiveShadow -= 8;
                }
                ++bsLiveShadow;
            }
        }
        this.bsBuff = bsBuffShadow;
        this.bsLive = bsLiveShadow;
    }

    private void sendMTFValues7() throws IOException {
        Data dataShadow = this.data;
        byte[][] len = dataShadow.sendMTFValuesLen;
        int[][] code = dataShadow.sendMTFValuesCode;
        OutputStream outShadow = this.out;
        byte[] selector = dataShadow.selector;
        char[] sfmap = dataShadow.sfmap;
        int nMTFShadow = this.nMTF;
        int selCtr = 0;
        int bsLiveShadow = this.bsLive;
        int bsBuffShadow = this.bsBuff;
        int gs = 0;
        while (gs < nMTFShadow) {
            int ge = Math.min(gs + 50 - 1, nMTFShadow - 1);
            int selectorSelCtr = selector[selCtr] & 0xFF;
            int[] codeSelCtr = code[selectorSelCtr];
            byte[] lenSelCtr = len[selectorSelCtr];
            while (gs <= ge) {
                char sfmapI = sfmap[gs];
                while (bsLiveShadow >= 8) {
                    outShadow.write(bsBuffShadow >> 24);
                    bsBuffShadow <<= 8;
                    bsLiveShadow -= 8;
                }
                int n = lenSelCtr[sfmapI] & 0xFF;
                bsBuffShadow |= codeSelCtr[sfmapI] << 32 - bsLiveShadow - n;
                bsLiveShadow += n;
                ++gs;
            }
            gs = ge + 1;
            ++selCtr;
        }
        this.bsBuff = bsBuffShadow;
        this.bsLive = bsLiveShadow;
    }

    private void moveToFrontCodeAndSend() throws IOException {
        this.bsW(24, this.origPtr);
        this.generateMTFValues();
        this.sendMTFValues();
    }

    private boolean mainSimpleSort(Data dataShadow, int lo, int hi, int d) {
        int bigN = hi - lo + 1;
        if (bigN < 2) {
            return this.firstAttempt && this.workDone > this.workLimit;
        }
        int hp = 0;
        while (INCS[hp] < bigN) {
            ++hp;
        }
        int[] fmap = dataShadow.fmap;
        char[] quadrant = dataShadow.quadrant;
        byte[] block = dataShadow.block;
        int lastShadow = this.last;
        int lastPlus1 = lastShadow + 1;
        boolean firstAttemptShadow = this.firstAttempt;
        int workLimitShadow = this.workLimit;
        int workDoneShadow = this.workDone;
        block1: while (--hp >= 0) {
            int h2 = INCS[hp];
            int mj = lo + h2 - 1;
            int i = lo + h2;
            while (i <= hi) {
                int k = 3;
                while (i <= hi && --k >= 0) {
                    int v = fmap[i];
                    int vd = v + d;
                    int j = i;
                    boolean onceRunned = false;
                    int a = 0;
                    block4: while (true) {
                        int i2;
                        int i1;
                        if (onceRunned) {
                            fmap[j] = a;
                            if ((j -= h2) <= mj) {
                                break;
                            }
                        } else {
                            onceRunned = true;
                        }
                        if (block[(i1 = (a = fmap[j - h2]) + d) + 1] == block[(i2 = vd) + 1]) {
                            if (block[i1 + 2] == block[i2 + 2]) {
                                if (block[i1 + 3] == block[i2 + 3]) {
                                    if (block[i1 + 4] == block[i2 + 4]) {
                                        if (block[i1 + 5] == block[i2 + 5]) {
                                            if (block[i1 += 6] == block[i2 += 6]) {
                                                int x = lastShadow;
                                                while (x > 0) {
                                                    x -= 4;
                                                    if (block[i1 + 1] == block[i2 + 1]) {
                                                        if (quadrant[i1] == quadrant[i2]) {
                                                            if (block[i1 + 2] == block[i2 + 2]) {
                                                                if (quadrant[i1 + 1] == quadrant[i2 + 1]) {
                                                                    if (block[i1 + 3] == block[i2 + 3]) {
                                                                        if (quadrant[i1 + 2] == quadrant[i2 + 2]) {
                                                                            if (block[i1 + 4] == block[i2 + 4]) {
                                                                                if (quadrant[i1 + 3] == quadrant[i2 + 3]) {
                                                                                    if ((i1 += 4) >= lastPlus1) {
                                                                                        i1 -= lastPlus1;
                                                                                    }
                                                                                    if ((i2 += 4) >= lastPlus1) {
                                                                                        i2 -= lastPlus1;
                                                                                    }
                                                                                    ++workDoneShadow;
                                                                                    continue;
                                                                                }
                                                                                if (quadrant[i1 + 3] <= quadrant[i2 + 3]) break block4;
                                                                                continue block4;
                                                                            }
                                                                            if ((block[i1 + 4] & 0xFF) <= (block[i2 + 4] & 0xFF)) break block4;
                                                                            continue block4;
                                                                        }
                                                                        if (quadrant[i1 + 2] <= quadrant[i2 + 2]) break block4;
                                                                        continue block4;
                                                                    }
                                                                    if ((block[i1 + 3] & 0xFF) <= (block[i2 + 3] & 0xFF)) break block4;
                                                                    continue block4;
                                                                }
                                                                if (quadrant[i1 + 1] <= quadrant[i2 + 1]) break block4;
                                                                continue block4;
                                                            }
                                                            if ((block[i1 + 2] & 0xFF) <= (block[i2 + 2] & 0xFF)) break block4;
                                                            continue block4;
                                                        }
                                                        if (quadrant[i1] <= quadrant[i2]) break block4;
                                                        continue block4;
                                                    }
                                                    if ((block[i1 + 1] & 0xFF) <= (block[i2 + 1] & 0xFF)) break block4;
                                                    continue block4;
                                                }
                                                break;
                                            }
                                            if ((block[i1] & 0xFF) > (block[i2] & 0xFF)) continue;
                                            break;
                                        }
                                        if ((block[i1 + 5] & 0xFF) <= (block[i2 + 5] & 0xFF)) break;
                                        continue;
                                    }
                                    if ((block[i1 + 4] & 0xFF) <= (block[i2 + 4] & 0xFF)) break;
                                    continue;
                                }
                                if ((block[i1 + 3] & 0xFF) <= (block[i2 + 3] & 0xFF)) break;
                                continue;
                            }
                            if ((block[i1 + 2] & 0xFF) <= (block[i2 + 2] & 0xFF)) break;
                            continue;
                        }
                        if ((block[i1 + 1] & 0xFF) <= (block[i2 + 1] & 0xFF)) break;
                    }
                    fmap[j] = v;
                    ++i;
                }
                if (!firstAttemptShadow || i > hi || workDoneShadow <= workLimitShadow) continue;
                break block1;
            }
        }
        this.workDone = workDoneShadow;
        return firstAttemptShadow && workDoneShadow > workLimitShadow;
    }

    private static void vswap(int[] fmap, int p1, int p2, int n) {
        n += p1;
        while (p1 < n) {
            int t = fmap[p1];
            fmap[p1++] = fmap[p2];
            fmap[p2++] = t;
        }
    }

    private static byte med3(byte a, byte b, byte c) {
        return a < b ? (b < c ? b : (a < c ? c : a)) : (b > c ? b : (a > c ? c : a));
    }

    private void blockSort() {
        this.workLimit = 30 * this.last;
        this.workDone = 0;
        this.blockRandomised = false;
        this.firstAttempt = true;
        this.mainSort();
        if (this.firstAttempt && this.workDone > this.workLimit) {
            this.randomiseBlock();
            this.workLimit = 0;
            this.workDone = 0;
            this.firstAttempt = false;
            this.mainSort();
        }
        int[] fmap = this.data.fmap;
        this.origPtr = -1;
        int lastShadow = this.last;
        for (int i = 0; i <= lastShadow; ++i) {
            if (fmap[i] != 0) continue;
            this.origPtr = i;
            break;
        }
    }

    private void mainQSort3(Data dataShadow, int loSt, int hiSt, int dSt) {
        int[] stackLl = dataShadow.stackLl;
        int[] stackHh = dataShadow.stackHh;
        int[] stackDd = dataShadow.stackDd;
        int[] fmap = dataShadow.fmap;
        byte[] block = dataShadow.block;
        stackLl[0] = loSt;
        stackHh[0] = hiSt;
        stackDd[0] = dSt;
        int sp = 1;
        while (--sp >= 0) {
            int n;
            int lo = stackLl[sp];
            int hi = stackHh[sp];
            int d = stackDd[sp];
            if (hi - lo < 20 || d > 10) {
                if (!this.mainSimpleSort(dataShadow, lo, hi, d)) continue;
                return;
            }
            int d1 = d + 1;
            int med = CBZip2OutputStream.med3(block[fmap[lo] + d1], block[fmap[hi] + d1], block[fmap[lo + hi >>> 1] + d1]) & 0xFF;
            int unLo = lo;
            int unHi = hi;
            int ltLo = lo;
            int gtHi = hi;
            while (true) {
                int temp;
                if (unLo <= unHi) {
                    n = (block[fmap[unLo] + d1] & 0xFF) - med;
                    if (n == 0) {
                        temp = fmap[unLo];
                        fmap[unLo++] = fmap[ltLo];
                        fmap[ltLo++] = temp;
                        continue;
                    }
                    if (n < 0) {
                        ++unLo;
                        continue;
                    }
                }
                while (unLo <= unHi) {
                    n = (block[fmap[unHi] + d1] & 0xFF) - med;
                    if (n == 0) {
                        temp = fmap[unHi];
                        fmap[unHi--] = fmap[gtHi];
                        fmap[gtHi--] = temp;
                        continue;
                    }
                    if (n <= 0) break;
                    --unHi;
                }
                if (unLo > unHi) break;
                int temp2 = fmap[unLo];
                fmap[unLo++] = fmap[unHi];
                fmap[unHi--] = temp2;
            }
            if (gtHi < ltLo) {
                stackLl[sp] = lo;
                stackHh[sp] = hi;
                stackDd[sp] = d1;
                ++sp;
                continue;
            }
            n = Math.min(ltLo - lo, unLo - ltLo);
            CBZip2OutputStream.vswap(fmap, lo, unLo - n, n);
            int m3 = Math.min(hi - gtHi, gtHi - unHi);
            CBZip2OutputStream.vswap(fmap, unLo, hi - m3 + 1, m3);
            n = lo + unLo - ltLo - 1;
            m3 = hi - (gtHi - unHi) + 1;
            stackLl[sp] = lo;
            stackHh[sp] = n;
            stackDd[sp] = d;
            stackLl[++sp] = n + 1;
            stackHh[sp] = m3 - 1;
            stackDd[sp] = d1;
            stackLl[++sp] = m3;
            stackHh[sp] = hi;
            stackDd[sp] = d;
            ++sp;
        }
    }

    private void mainSort() {
        int j;
        int c2;
        int i;
        Data dataShadow = this.data;
        int[] runningOrder = dataShadow.mainSortRunningOrder;
        int[] copy = dataShadow.mainSortCopy;
        boolean[] bigDone = dataShadow.mainSortBigDone;
        int[] ftab = dataShadow.ftab;
        byte[] block = dataShadow.block;
        int[] fmap = dataShadow.fmap;
        char[] quadrant = dataShadow.quadrant;
        int lastShadow = this.last;
        int workLimitShadow = this.workLimit;
        boolean firstAttemptShadow = this.firstAttempt;
        int i2 = 65537;
        while (--i2 >= 0) {
            ftab[i2] = 0;
        }
        for (i2 = 0; i2 < 20; ++i2) {
            block[lastShadow + i2 + 2] = block[i2 % (lastShadow + 1) + 1];
        }
        i2 = lastShadow + 20 + 1;
        while (--i2 >= 0) {
            quadrant[i2] = '\u0000';
        }
        block[0] = block[lastShadow + 1];
        int c1 = block[0] & 0xFF;
        for (i = 0; i <= lastShadow; ++i) {
            c2 = block[i + 1] & 0xFF;
            int n = (c1 << 8) + c2;
            ftab[n] = ftab[n] + 1;
            c1 = c2;
        }
        for (i = 1; i <= 65536; ++i) {
            int n = i;
            ftab[n] = ftab[n] + ftab[i - 1];
        }
        c1 = block[1] & 0xFF;
        i = 0;
        while (i < lastShadow) {
            c2 = block[i + 2] & 0xFF;
            int n = (c1 << 8) + c2;
            int n2 = ftab[n] - 1;
            ftab[n] = n2;
            fmap[n2] = i++;
            c1 = c2;
        }
        int n = ((block[lastShadow + 1] & 0xFF) << 8) + (block[1] & 0xFF);
        int n3 = ftab[n] - 1;
        ftab[n] = n3;
        fmap[n3] = lastShadow;
        i = 256;
        while (--i >= 0) {
            bigDone[i] = false;
            runningOrder[i] = i;
        }
        int h2 = 364;
        while (h2 != 1) {
            for (int i3 = h2 /= 3; i3 <= 255; ++i3) {
                int vv = runningOrder[i3];
                int a = ftab[vv + 1 << 8] - ftab[vv << 8];
                int b = h2 - 1;
                j = i3;
                int ro = runningOrder[j - h2];
                while (ftab[ro + 1 << 8] - ftab[ro << 8] > a) {
                    runningOrder[j] = ro;
                    if ((j -= h2) <= b) break;
                    ro = runningOrder[j - h2];
                }
                runningOrder[j] = vv;
            }
        }
        for (i = 0; i <= 255; ++i) {
            int j2;
            int ss = runningOrder[i];
            for (j2 = 0; j2 <= 255; ++j2) {
                int sb = (ss << 8) + j2;
                int ftabSb = ftab[sb];
                if ((ftabSb & 0x200000) == 0x200000) continue;
                int hi = (ftab[sb + 1] & 0xFFDFFFFF) - 1;
                int lo = ftabSb & 0xFFDFFFFF;
                if (hi > lo) {
                    this.mainQSort3(dataShadow, lo, hi, 2);
                    if (firstAttemptShadow && this.workDone > workLimitShadow) {
                        return;
                    }
                }
                ftab[sb] = ftabSb | 0x200000;
            }
            for (j2 = 0; j2 <= 255; ++j2) {
                copy[j2] = ftab[(j2 << 8) + ss] & 0xFFDFFFFF;
            }
            int hj = ftab[ss + 1 << 8] & 0xFFDFFFFF;
            for (j2 = ftab[ss << 8] & 0xFFDFFFFF; j2 < hj; ++j2) {
                int fmapJ = fmap[j2];
                c1 = block[fmapJ] & 0xFF;
                if (bigDone[c1]) continue;
                fmap[copy[c1]] = fmapJ == 0 ? lastShadow : fmapJ - 1;
                int n4 = c1;
                copy[n4] = copy[n4] + 1;
            }
            j2 = 256;
            while (--j2 >= 0) {
                int n5 = (j2 << 8) + ss;
                ftab[n5] = ftab[n5] | 0x200000;
            }
            bigDone[ss] = true;
            if (i >= 255) continue;
            int bbStart = ftab[ss << 8] & 0xFFDFFFFF;
            int bbSize = (ftab[ss + 1 << 8] & 0xFFDFFFFF) - bbStart;
            int shifts = 0;
            while (bbSize >> shifts > 65534) {
                ++shifts;
            }
            for (j = 0; j < bbSize; ++j) {
                char qVal;
                int a2update = fmap[bbStart + j];
                quadrant[a2update] = qVal = (char)(j >> shifts);
                if (a2update >= 20) continue;
                quadrant[a2update + lastShadow + 1] = qVal;
            }
        }
    }

    private void randomiseBlock() {
        boolean[] inUse = this.data.inUse;
        byte[] block = this.data.block;
        int lastShadow = this.last;
        int i = 256;
        while (--i >= 0) {
            inUse[i] = false;
        }
        int rNToGo = 0;
        int rTPos = 0;
        int i2 = 0;
        int j = 1;
        while (i2 <= lastShadow) {
            if (rNToGo == 0) {
                rNToGo = (char)R_NUMS[rTPos];
                if (++rTPos == 512) {
                    rTPos = 0;
                }
            }
            int n = j;
            block[n] = (byte)(block[n] ^ (--rNToGo == 1 ? (byte)1 : 0));
            inUse[block[j] & 0xFF] = true;
            i2 = j++;
        }
        this.blockRandomised = true;
    }

    private void generateMTFValues() {
        int eob;
        int i;
        int lastShadow = this.last;
        Data dataShadow = this.data;
        boolean[] inUse = dataShadow.inUse;
        byte[] block = dataShadow.block;
        int[] fmap = dataShadow.fmap;
        char[] sfmap = dataShadow.sfmap;
        int[] mtfFreq = dataShadow.mtfFreq;
        byte[] unseqToSeq = dataShadow.unseqToSeq;
        byte[] yy = dataShadow.generateMTFValuesYy;
        int nInUseShadow = 0;
        for (int i2 = 0; i2 < 256; ++i2) {
            if (!inUse[i2]) continue;
            unseqToSeq[i2] = (byte)nInUseShadow;
            ++nInUseShadow;
        }
        this.nInUse = nInUseShadow;
        for (i = eob = nInUseShadow + 1; i >= 0; --i) {
            mtfFreq[i] = 0;
        }
        i = nInUseShadow;
        while (--i >= 0) {
            yy[i] = (byte)i;
        }
        int wr = 0;
        int zPend = 0;
        for (int i3 = 0; i3 <= lastShadow; ++i3) {
            byte llI = unseqToSeq[block[fmap[i3]] & 0xFF];
            byte tmp = yy[0];
            int j = 0;
            while (llI != tmp) {
                byte tmp2 = tmp;
                tmp = yy[++j];
                yy[j] = tmp2;
            }
            yy[0] = tmp;
            if (j == 0) {
                ++zPend;
                continue;
            }
            if (zPend > 0) {
                --zPend;
                while (true) {
                    if ((zPend & 1) == 0) {
                        sfmap[wr] = '\u0000';
                        ++wr;
                        mtfFreq[0] = mtfFreq[0] + 1;
                    } else {
                        sfmap[wr] = '\u0001';
                        ++wr;
                        mtfFreq[1] = mtfFreq[1] + 1;
                    }
                    if (zPend < 2) break;
                    zPend = zPend - 2 >> 1;
                }
                zPend = 0;
            }
            sfmap[wr] = (char)(j + 1);
            ++wr;
            int n = j + 1;
            mtfFreq[n] = mtfFreq[n] + 1;
        }
        if (zPend > 0) {
            --zPend;
            while (true) {
                if ((zPend & 1) == 0) {
                    sfmap[wr] = '\u0000';
                    ++wr;
                    mtfFreq[0] = mtfFreq[0] + 1;
                } else {
                    sfmap[wr] = '\u0001';
                    ++wr;
                    mtfFreq[1] = mtfFreq[1] + 1;
                }
                if (zPend < 2) break;
                zPend = zPend - 2 >> 1;
            }
        }
        sfmap[wr] = (char)eob;
        int n = eob;
        mtfFreq[n] = mtfFreq[n] + 1;
        this.nMTF = wr + 1;
    }

    private static final class Data {
        final boolean[] inUse = new boolean[256];
        final byte[] unseqToSeq = new byte[256];
        final int[] mtfFreq = new int[258];
        final byte[] selector = new byte[18002];
        final byte[] selectorMtf = new byte[18002];
        final byte[] generateMTFValuesYy = new byte[256];
        final byte[][] sendMTFValuesLen = new byte[6][258];
        final int[][] sendMTFValuesRfreq = new int[6][258];
        final int[] sendMTFValuesFave = new int[6];
        final short[] sendMTFValuesCost = new short[6];
        final int[][] sendMTFValuesCode = new int[6][258];
        final byte[] sendMTFValues2Pos = new byte[6];
        final boolean[] sentMTFValues4InUse16 = new boolean[16];
        final int[] stackLl = new int[1000];
        final int[] stackHh = new int[1000];
        final int[] stackDd = new int[1000];
        final int[] mainSortRunningOrder = new int[256];
        final int[] mainSortCopy = new int[256];
        final boolean[] mainSortBigDone = new boolean[256];
        final int[] heap = new int[260];
        final int[] weight = new int[516];
        final int[] parent = new int[516];
        final int[] ftab = new int[65537];
        final byte[] block;
        final int[] fmap;
        final char[] sfmap;
        final char[] quadrant;

        Data(int blockSize100k) {
            int n = blockSize100k * 100000;
            this.block = new byte[n + 1 + 20];
            this.fmap = new int[n];
            this.sfmap = new char[2 * n];
            this.quadrant = this.sfmap;
        }
    }
}

