/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.shade.connector.file.org.apache.orc.storage.ql.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.seatunnel.shade.connector.file.org.apache.orc.storage.ql.util.JavaDataModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncrementalObjectSizeEstimator {
    public static final JavaDataModel memoryModel = JavaDataModel.get();
    private static final Logger LOG = LoggerFactory.getLogger((String)IncrementalObjectSizeEstimator.class.getName());

    public static HashMap<Class<?>, ObjectEstimator> createEstimators(Object rootObj) {
        HashMap byType = new HashMap();
        IncrementalObjectSizeEstimator.addHardcodedEstimators(byType);
        IncrementalObjectSizeEstimator.createEstimators(rootObj, byType);
        return byType;
    }

    public static void createEstimators(Object rootObj, HashMap<Class<?>, ObjectEstimator> byType) {
        Deque<Object> stack = IncrementalObjectSizeEstimator.createWorkStack(rootObj, byType);
        while (!stack.isEmpty()) {
            Class<?> clazz;
            Object obj = stack.pop();
            if (obj instanceof Class) {
                clazz = (Class<?>)obj;
                obj = null;
            } else {
                clazz = obj.getClass();
            }
            ObjectEstimator estimator = byType.get(clazz);
            assert (estimator != null);
            if (!estimator.isFromClass && obj == null || estimator.isProcessed()) continue;
            estimator.init();
            for (Field field : IncrementalObjectSizeEstimator.getAllFields(clazz)) {
                Class<?> fieldClass = field.getType();
                if (Modifier.isStatic(field.getModifiers()) || Class.class.isAssignableFrom(fieldClass)) continue;
                if (fieldClass.isPrimitive()) {
                    estimator.addPrimitive(fieldClass);
                    continue;
                }
                if (Enum.class.isAssignableFrom(fieldClass)) {
                    estimator.addEnum();
                    continue;
                }
                boolean isArray = fieldClass.isArray();
                if (isArray && fieldClass.getComponentType().isPrimitive()) {
                    estimator.addField(FieldType.PRIMITIVE_ARRAY, field);
                    continue;
                }
                Object fieldObj = null;
                if (obj != null) {
                    fieldObj = IncrementalObjectSizeEstimator.extractFieldObj(obj, field);
                    fieldClass = IncrementalObjectSizeEstimator.determineRealClass(byType, stack, field, fieldClass, fieldObj);
                }
                if (isArray) {
                    estimator.addField(FieldType.OBJECT_ARRAY, field);
                    IncrementalObjectSizeEstimator.addArrayEstimator(byType, stack, field, fieldObj);
                    continue;
                }
                if (Collection.class.isAssignableFrom(fieldClass)) {
                    estimator.addField(FieldType.COLLECTION, field);
                    IncrementalObjectSizeEstimator.addCollectionEstimator(byType, stack, field, fieldClass, fieldObj);
                    continue;
                }
                if (Map.class.isAssignableFrom(fieldClass)) {
                    estimator.addField(FieldType.MAP, field);
                    IncrementalObjectSizeEstimator.addMapEstimator(byType, stack, field, fieldClass, fieldObj);
                    continue;
                }
                estimator.addField(FieldType.OTHER, field);
                IncrementalObjectSizeEstimator.addToProcessing(byType, stack, fieldObj, fieldClass);
            }
            estimator.directSize = (int)JavaDataModel.alignUp(estimator.directSize, memoryModel.memoryAlign());
        }
    }

    private static Deque<Object> createWorkStack(Object rootObj, HashMap<Class<?>, ObjectEstimator> byType) {
        ArrayDeque<Object> stack = new ArrayDeque<Object>(32);
        Class rootClass = rootObj.getClass();
        if (Class.class.equals(rootClass)) {
            rootClass = (Class)rootObj;
            rootObj = null;
        } else if (rootClass.isArray() && !rootClass.getComponentType().isPrimitive()) {
            IncrementalObjectSizeEstimator.addArrayEstimator(byType, stack, null, rootObj);
        } else if (Collection.class.isAssignableFrom(rootClass)) {
            IncrementalObjectSizeEstimator.addCollectionEstimator(byType, stack, null, rootClass, rootObj);
        } else if (Map.class.isAssignableFrom(rootClass)) {
            IncrementalObjectSizeEstimator.addMapEstimator(byType, stack, null, rootClass, rootObj);
        }
        IncrementalObjectSizeEstimator.addToProcessing(byType, stack, rootObj, rootClass);
        return stack;
    }

    private static void addHardcodedEstimators(HashMap<Class<?>, ObjectEstimator> byType) {
        byType.put(ArrayList.class, new CollectionEstimator(memoryModel.arrayList(), memoryModel.ref()));
        byType.put(LinkedList.class, new CollectionEstimator(memoryModel.linkedListBase(), memoryModel.linkedListEntry()));
        byType.put(HashSet.class, new CollectionEstimator(memoryModel.hashSetBase(), memoryModel.hashSetEntry()));
        byType.put(HashMap.class, new CollectionEstimator(memoryModel.hashMapBase(), memoryModel.hashMapEntry()));
    }

    private static Object extractFieldObj(Object obj, Field field) {
        try {
            return field.get(obj);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)("IAE: " + field + "; " + e.getMessage()));
        }
    }

    private static Class<?> determineRealClass(HashMap<Class<?>, ObjectEstimator> byType, Deque<Object> stack, Field field, Class<?> fieldClass, Object fieldObj) {
        if (fieldObj == null) {
            return fieldClass;
        }
        Class<?> realFieldClass = fieldObj.getClass();
        if (!fieldClass.equals(realFieldClass)) {
            IncrementalObjectSizeEstimator.addToProcessing(byType, stack, null, fieldClass);
            return realFieldClass;
        }
        return fieldClass;
    }

    private static void addCollectionEstimator(HashMap<Class<?>, ObjectEstimator> byType, Deque<Object> stack, Field field, Class<?> fieldClass, Object fieldObj) {
        Collection fieldCol = null;
        if (fieldObj != null && (fieldCol = (Collection)fieldObj).size() == 0) {
            fieldCol = null;
            LOG.trace("Empty collection {}", (Object)field);
        }
        if (fieldCol != null) {
            for (Object element : fieldCol) {
                if (element == null) continue;
                IncrementalObjectSizeEstimator.addToProcessing(byType, stack, element, element.getClass());
            }
        }
        if (field != null) {
            Class<?> collectionArg = IncrementalObjectSizeEstimator.getCollectionArg(field);
            if (collectionArg != null) {
                IncrementalObjectSizeEstimator.addToProcessing(byType, stack, null, collectionArg);
            }
            IncrementalObjectSizeEstimator.addToProcessing(byType, stack, fieldObj, fieldClass);
        }
    }

    private static void addMapEstimator(HashMap<Class<?>, ObjectEstimator> byType, Deque<Object> stack, Field field, Class<?> fieldClass, Object fieldObj) {
        Map fieldCol = null;
        if (fieldObj != null && (fieldCol = (Map)fieldObj).size() == 0) {
            fieldCol = null;
            LOG.trace("Empty map {}", (Object)field);
        }
        if (fieldCol != null) {
            for (Map.Entry element : fieldCol.entrySet()) {
                Object k = element.getKey();
                Object v = element.getValue();
                if (k != null) {
                    IncrementalObjectSizeEstimator.addToProcessing(byType, stack, k, k.getClass());
                }
                if (v == null) continue;
                IncrementalObjectSizeEstimator.addToProcessing(byType, stack, v, v.getClass());
            }
        }
        if (field != null) {
            Class<?>[] mapArgs = IncrementalObjectSizeEstimator.getMapArgs(field);
            if (mapArgs != null) {
                for (Class<?> mapArg : mapArgs) {
                    IncrementalObjectSizeEstimator.addToProcessing(byType, stack, null, mapArg);
                }
            }
            IncrementalObjectSizeEstimator.addToProcessing(byType, stack, fieldObj, fieldClass);
        }
    }

    private static Class<?>[] getMapArgs(Field field) {
        Type genericType = field.getGenericType();
        if (genericType instanceof ParameterizedType) {
            Type[] types = ((ParameterizedType)genericType).getActualTypeArguments();
            if (types.length == 2 && types[0] instanceof Class && types[1] instanceof Class) {
                return new Class[]{(Class)types[0], (Class)types[1]};
            }
            LOG.trace("Cannot determine map type: {}", (Object)field);
        } else {
            LOG.trace("Non-parametrized map type: {}", (Object)field);
        }
        return null;
    }

    private static Class<?> getCollectionArg(Field field) {
        Type genericType = field.getGenericType();
        if (genericType instanceof ParameterizedType) {
            Type type = ((ParameterizedType)genericType).getActualTypeArguments()[0];
            if (type instanceof Class) {
                return (Class)type;
            }
            LOG.trace("Cannot determine collection type: {}", (Object)field);
        } else {
            LOG.trace("Non-parametrized collection type: {}", (Object)field);
        }
        return null;
    }

    private static void addArrayEstimator(HashMap<Class<?>, ObjectEstimator> byType, Deque<Object> stack, Field field, Object fieldObj) {
        if (fieldObj == null) {
            return;
        }
        int arrayLen = Array.getLength(fieldObj);
        LOG.trace("Empty array {}", (Object)field);
        for (int i = 0; i < arrayLen; ++i) {
            Object element = Array.get(fieldObj, i);
            if (element == null) continue;
            IncrementalObjectSizeEstimator.addToProcessing(byType, stack, element, element.getClass());
        }
        Class<?> elementClass = fieldObj.getClass().getComponentType();
        IncrementalObjectSizeEstimator.addToProcessing(byType, stack, null, elementClass);
    }

    private static void addToProcessing(HashMap<Class<?>, ObjectEstimator> byType, Deque<Object> stack, Object element, Class<?> elementClass) {
        ObjectEstimator existing = byType.get(elementClass);
        if (!(existing == null || existing.isFromClass && element != null)) {
            return;
        }
        if (elementClass.isInterface()) {
            if (element == null) {
                return;
            }
            elementClass = element.getClass();
        }
        byType.put(elementClass, new ObjectEstimator(element == null));
        stack.push(element == null ? elementClass : element);
    }

    private static int getPrimitiveSize(Class<?> fieldClass) {
        if (fieldClass == Long.TYPE || fieldClass == Double.TYPE) {
            return 8;
        }
        if (fieldClass == Integer.TYPE || fieldClass == Float.TYPE) {
            return 4;
        }
        if (fieldClass == Short.TYPE || fieldClass == Character.TYPE) {
            return 2;
        }
        if (fieldClass == Byte.TYPE || fieldClass == Boolean.TYPE) {
            return 1;
        }
        throw new AssertionError((Object)("Unrecognized primitive " + fieldClass.getName()));
    }

    private static Iterable<Field> getAllFields(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>(8);
        while (clazz != null) {
            fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
            clazz = clazz.getSuperclass();
        }
        AccessibleObject.setAccessible(fields.toArray(new AccessibleObject[fields.size()]), true);
        return fields;
    }

    public static void addEstimator(String className, HashMap<Class<?>, ObjectEstimator> sizeEstimators, Class<?> topClass) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            LOG.warn("Cannot find " + className);
            return;
        }
        IncrementalObjectSizeEstimator.createEstimators(clazz, sizeEstimators);
    }

    private static class CollectionEstimator
    extends ObjectEstimator {
        private int perEntryOverhead;

        public CollectionEstimator(int base, int perElement) {
            super(false);
            this.directSize = base;
            this.perEntryOverhead = perElement;
        }

        @Override
        protected int estimate(Object obj, HashMap<Class<?>, ObjectEstimator> parent, IdentityHashMap<Object, Boolean> uniqueObjects) {
            if (obj instanceof Collection) {
                Collection c = (Collection)obj;
                int overhead = this.estimateOverhead(c.size());
                int elements = this.estimateCollectionElements(parent, c, null, uniqueObjects);
                return overhead + elements + memoryModel.object();
            }
            if (obj instanceof Map) {
                Map m = (Map)obj;
                int overhead = this.estimateOverhead(m.size());
                int elements = this.estimateMapElements(parent, m, null, uniqueObjects);
                return overhead + elements + memoryModel.object();
            }
            throw new AssertionError((Object)obj.getClass().getName());
        }

        int estimateOverhead(int size) {
            return this.directSize + this.perEntryOverhead * size;
        }
    }

    public static class ObjectEstimator {
        private List<FieldAndType> fields;
        protected int directSize = -1;
        private boolean isFromClass;

        public ObjectEstimator(boolean isFromClass) {
            this.isFromClass = isFromClass;
        }

        boolean isProcessed() {
            return this.directSize >= 0;
        }

        private void init() {
            assert (this.directSize == -1);
            this.directSize = memoryModel.object();
        }

        private void addPrimitive(Class<?> clazz) {
            this.directSize += IncrementalObjectSizeEstimator.getPrimitiveSize(clazz);
        }

        private void addEnum() {
            this.directSize += memoryModel.ref();
        }

        private void addField(FieldType type, Field field) {
            if (this.fields == null) {
                this.fields = new ArrayList<FieldAndType>();
            }
            this.directSize += memoryModel.ref();
            this.fields.add(new FieldAndType(field, type));
        }

        public int estimate(Object obj, HashMap<Class<?>, ObjectEstimator> parent) {
            IdentityHashMap<Object, Boolean> uniqueObjects = new IdentityHashMap<Object, Boolean>();
            uniqueObjects.put(obj, Boolean.TRUE);
            return this.estimate(obj, parent, uniqueObjects);
        }

        protected int estimate(Object obj, HashMap<Class<?>, ObjectEstimator> parent, IdentityHashMap<Object, Boolean> uniqueObjects) {
            if (this.fields == null) {
                return this.directSize;
            }
            int referencedSize = 0;
            block9: for (FieldAndType e : this.fields) {
                Object fieldObj;
                try {
                    fieldObj = e.field.get(obj);
                }
                catch (IllegalAccessException ex) {
                    throw new AssertionError((Object)("IAE: " + ex.getMessage()));
                }
                if (fieldObj == null || null != uniqueObjects.put(fieldObj, Boolean.TRUE)) continue;
                switch (e.type) {
                    case COLLECTION: {
                        Collection c = (Collection)fieldObj;
                        ObjectEstimator collEstimator = parent.get(fieldObj.getClass());
                        if (collEstimator == null) {
                            LOG.trace("Approximate estimation for collection {} from {}", (Object)e.field, (Object)fieldObj.getClass().getName());
                            referencedSize += memoryModel.object();
                            referencedSize += this.estimateCollectionElements(parent, c, e.field, uniqueObjects);
                            referencedSize += memoryModel.array() + c.size() * memoryModel.ref();
                            continue block9;
                        }
                        if (collEstimator instanceof CollectionEstimator) {
                            referencedSize += memoryModel.object();
                            referencedSize += this.estimateCollectionElements(parent, c, e.field, uniqueObjects);
                            referencedSize += ((CollectionEstimator)collEstimator).estimateOverhead(c.size());
                            continue block9;
                        }
                        LOG.trace("Verbose estimation for collection {} from {}", (Object)fieldObj.getClass().getName(), (Object)e.field);
                        referencedSize += collEstimator.estimate(c, parent, uniqueObjects);
                        continue block9;
                    }
                    case MAP: {
                        Map m = (Map)fieldObj;
                        ObjectEstimator collEstimator = parent.get(fieldObj.getClass());
                        if (collEstimator == null) {
                            LOG.trace("Approximate estimation for map {} from {}", (Object)fieldObj.getClass().getName(), (Object)e.field);
                            referencedSize += memoryModel.object();
                            referencedSize += this.estimateMapElements(parent, m, e.field, uniqueObjects);
                            referencedSize += memoryModel.array() + m.size() * (memoryModel.ref() * 2 + memoryModel.object());
                            continue block9;
                        }
                        if (collEstimator instanceof CollectionEstimator) {
                            referencedSize += memoryModel.object();
                            referencedSize += this.estimateMapElements(parent, m, e.field, uniqueObjects);
                            referencedSize += ((CollectionEstimator)collEstimator).estimateOverhead(m.size());
                            continue block9;
                        }
                        LOG.trace("Verbose estimation for map {} from {}", (Object)fieldObj.getClass().getName(), (Object)e.field);
                        referencedSize += collEstimator.estimate(m, parent, uniqueObjects);
                        continue block9;
                    }
                    case OBJECT_ARRAY: {
                        int len = Array.getLength(fieldObj);
                        referencedSize = (int)((long)referencedSize + JavaDataModel.alignUp(memoryModel.array() + len * memoryModel.ref(), memoryModel.memoryAlign()));
                        if (len == 0) continue block9;
                        referencedSize += this.estimateArrayElements(parent, e, fieldObj, len, uniqueObjects);
                        continue block9;
                    }
                    case PRIMITIVE_ARRAY: {
                        int arraySize = memoryModel.array();
                        int len = Array.getLength(fieldObj);
                        if (len != 0) {
                            int elementSize = IncrementalObjectSizeEstimator.getPrimitiveSize(e.field.getType().getComponentType());
                            arraySize += elementSize * len;
                            arraySize = (int)JavaDataModel.alignUp(arraySize, memoryModel.memoryAlign());
                        }
                        referencedSize += arraySize;
                        continue block9;
                    }
                    case OTHER: {
                        ObjectEstimator fieldEstimator = parent.get(fieldObj.getClass());
                        if (fieldEstimator == null) {
                            IncrementalObjectSizeEstimator.createEstimators(fieldObj.getClass(), parent);
                        }
                        if ((fieldEstimator = parent.get(fieldObj.getClass())) == null) {
                            throw new AssertionError((Object)("Don't know how to measure " + fieldObj.getClass().getName() + " from " + e.field));
                        }
                        referencedSize += fieldEstimator.estimate(fieldObj, parent, uniqueObjects);
                        continue block9;
                    }
                }
                throw new AssertionError((Object)("Unknown type " + (Object)((Object)e.type)));
            }
            return this.directSize + referencedSize;
        }

        private int estimateArrayElements(HashMap<Class<?>, ObjectEstimator> parent, FieldAndType e, Object fieldObj, int len, IdentityHashMap<Object, Boolean> uniqueObjects) {
            int result = 0;
            Class<?> lastClass = e.field.getType().getComponentType();
            ObjectEstimator lastEstimator = parent.get(lastClass);
            for (int i = 0; i < len; ++i) {
                Object element = Array.get(fieldObj, i);
                if (element == null || null != uniqueObjects.put(element, Boolean.TRUE)) continue;
                Class<?> elementClass = element.getClass();
                if (lastClass != elementClass) {
                    lastClass = elementClass;
                    lastEstimator = parent.get(lastClass);
                    if (lastEstimator == null) {
                        IncrementalObjectSizeEstimator.createEstimators(lastClass, parent);
                    }
                    if ((lastEstimator = parent.get(lastClass)) == null) {
                        throw new AssertionError((Object)("Don't know how to measure element " + lastClass.getName() + " from " + e.field));
                    }
                }
                result += lastEstimator.estimate(element, parent, uniqueObjects);
            }
            return result;
        }

        protected int estimateCollectionElements(HashMap<Class<?>, ObjectEstimator> parent, Collection<?> c, Field field, IdentityHashMap<Object, Boolean> uniqueObjects) {
            ObjectEstimator lastEstimator = null;
            Class<?> lastClass = null;
            int result = 0;
            for (Object element : c) {
                if (element == null || null != uniqueObjects.put(element, Boolean.TRUE)) continue;
                Class<?> elementClass = element.getClass();
                if (lastClass != elementClass) {
                    lastClass = elementClass;
                    lastEstimator = parent.get(lastClass);
                    if (lastEstimator == null) {
                        IncrementalObjectSizeEstimator.createEstimators(lastClass, parent);
                    }
                    if ((lastEstimator = parent.get(lastClass)) == null) {
                        throw new AssertionError((Object)("Don't know how to measure element " + lastClass.getName() + " from " + field));
                    }
                }
                result += lastEstimator.estimate(element, parent, uniqueObjects);
            }
            return result;
        }

        protected int estimateMapElements(HashMap<Class<?>, ObjectEstimator> parent, Map<?, ?> m, Field field, IdentityHashMap<Object, Boolean> uniqueObjects) {
            ObjectEstimator keyEstimator = null;
            ObjectEstimator valueEstimator = null;
            Class<?> lastKeyClass = null;
            Class<?> lastValueClass = null;
            int result = 0;
            for (Map.Entry<?, ?> element : m.entrySet()) {
                Object key = element.getKey();
                Object value = element.getValue();
                if (null != uniqueObjects.put(key, Boolean.TRUE)) continue;
                Class<?> keyClass = key.getClass();
                if (lastKeyClass != keyClass) {
                    lastKeyClass = keyClass;
                    keyEstimator = parent.get(lastKeyClass);
                    if (keyEstimator == null) {
                        IncrementalObjectSizeEstimator.createEstimators(lastKeyClass, parent);
                    }
                    if ((keyEstimator = parent.get(lastKeyClass)) == null) {
                        throw new AssertionError((Object)("Don't know how to measure key " + lastKeyClass.getName() + " from " + field));
                    }
                }
                result += keyEstimator.estimate(key, parent, uniqueObjects);
                if (value == null || null != uniqueObjects.put(value, Boolean.TRUE)) continue;
                Class<?> valueClass = value.getClass();
                if (lastValueClass != valueClass) {
                    lastValueClass = valueClass;
                    valueEstimator = parent.get(lastValueClass);
                    if (valueEstimator == null) {
                        IncrementalObjectSizeEstimator.createEstimators(lastValueClass, parent);
                    }
                    if ((valueEstimator = parent.get(lastValueClass)) == null) {
                        throw new AssertionError((Object)("Don't know how to measure value " + lastValueClass.getName() + " from " + field));
                    }
                }
                result += valueEstimator.estimate(value, parent, uniqueObjects);
            }
            return result;
        }
    }

    private static class FieldAndType {
        public Field field;
        public FieldType type;

        public FieldAndType(Field field, FieldType type) {
            this.field = field;
            this.type = type;
        }
    }

    private static enum FieldType {
        PRIMITIVE_ARRAY,
        OBJECT_ARRAY,
        COLLECTION,
        MAP,
        OTHER;

    }
}

