/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.file.sink.writer;

import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import lombok.NonNull;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.common.exception.CommonError;
import org.apache.seatunnel.common.exception.CommonErrorCodeDeprecated;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.file.exception.FileConnectorErrorCode;
import org.apache.seatunnel.connectors.seatunnel.file.exception.FileConnectorException;
import org.apache.seatunnel.connectors.seatunnel.file.sink.config.FileSinkConfig;
import org.apache.seatunnel.connectors.seatunnel.file.sink.writer.AbstractWriteStrategy;
import org.apache.seatunnel.connectors.seatunnel.file.source.reader.BinaryReadStrategy;

public class BinaryWriteStrategy
extends AbstractWriteStrategy {
    private final LinkedHashMap<String, FSDataOutputStream> beingWrittenOutputStream = new LinkedHashMap();
    private final LinkedHashMap<String, Long> partIndexMap = new LinkedHashMap();

    public BinaryWriteStrategy(FileSinkConfig fileSinkConfig) {
        super(fileSinkConfig);
    }

    @Override
    public void setCatalogTable(CatalogTable catalogTable) {
        super.setCatalogTable(catalogTable);
        if (!catalogTable.getSeaTunnelRowType().equals((Object)BinaryReadStrategy.binaryRowType)) {
            throw new FileConnectorException((SeaTunnelErrorCode)FileConnectorErrorCode.FORMAT_NOT_SUPPORT, "BinaryWriteStrategy only supports binary format, please read file with `BINARY` format, and do not change schema in the transform.");
        }
    }

    @Override
    public void write(SeaTunnelRow seaTunnelRow) throws FileConnectorException {
        byte[] data = (byte[])seaTunnelRow.getField(0);
        String relativePath = (String)seaTunnelRow.getField(1);
        long partIndex = (Long)seaTunnelRow.getField(2);
        String filePath = this.getOrCreateFilePathBeingWritten(relativePath);
        FSDataOutputStream fsDataOutputStream = this.getOrCreateOutputStream(filePath);
        if (partIndex - 1L != this.partIndexMap.get(filePath)) {
            throw new FileConnectorException((SeaTunnelErrorCode)FileConnectorErrorCode.BINARY_FILE_PART_ORDER_ERROR, "Last order is " + this.partIndexMap.get(filePath) + ", but get " + partIndex);
        }
        this.partIndexMap.put(filePath, partIndex);
        try {
            fsDataOutputStream.write(data);
        }
        catch (IOException e) {
            throw CommonError.fileOperationFailed((String)"BinaryFile", (String)"write", (String)filePath, (Throwable)e);
        }
    }

    public String getOrCreateFilePathBeingWritten(String relativePath) {
        String beingWrittenFilePath = (String)this.beingWrittenFile.get(relativePath);
        if (beingWrittenFilePath != null) {
            return beingWrittenFilePath;
        }
        CharSequence[] pathSegments = new String[]{this.transactionDirectory, relativePath};
        String newBeingWrittenFilePath = String.join((CharSequence)File.separator, pathSegments);
        this.beingWrittenFile.put(relativePath, newBeingWrittenFilePath);
        return newBeingWrittenFilePath;
    }

    private FSDataOutputStream getOrCreateOutputStream(@NonNull String filePath) {
        if (filePath == null) {
            throw new NullPointerException("filePath is marked non-null but is null");
        }
        FSDataOutputStream fsDataOutputStream = this.beingWrittenOutputStream.get(filePath);
        if (fsDataOutputStream == null) {
            try {
                fsDataOutputStream = this.hadoopFileSystemProxy.getOutputStream(filePath);
                this.beingWrittenOutputStream.put(filePath, fsDataOutputStream);
                this.partIndexMap.put(filePath, -1L);
            }
            catch (IOException e) {
                throw CommonError.fileOperationFailed((String)"BinaryFile", (String)"open", (String)filePath, (Throwable)e);
            }
        }
        return fsDataOutputStream;
    }

    @Override
    public void finishAndCloseFile() {
        this.beingWrittenOutputStream.forEach((key, value) -> {
            try {
                value.flush();
            }
            catch (IOException e) {
                throw new FileConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.FLUSH_DATA_FAILED, String.format("Flush data to this file [%s] failed", key), e);
            }
            finally {
                try {
                    value.close();
                }
                catch (IOException e) {
                    this.log.error("error when close output stream {}", key, (Object)e);
                }
            }
            this.needMoveFiles.put(key, this.getTargetLocation((String)key));
        });
        this.beingWrittenOutputStream.clear();
        this.partIndexMap.clear();
    }
}

