/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.file.config;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.seatunnel.connectors.seatunnel.file.sink.config.FileSinkConfig;
import org.apache.seatunnel.connectors.seatunnel.file.sink.writer.BinaryWriteStrategy;
import org.apache.seatunnel.connectors.seatunnel.file.sink.writer.ExcelWriteStrategy;
import org.apache.seatunnel.connectors.seatunnel.file.sink.writer.JsonWriteStrategy;
import org.apache.seatunnel.connectors.seatunnel.file.sink.writer.OrcWriteStrategy;
import org.apache.seatunnel.connectors.seatunnel.file.sink.writer.ParquetWriteStrategy;
import org.apache.seatunnel.connectors.seatunnel.file.sink.writer.TextWriteStrategy;
import org.apache.seatunnel.connectors.seatunnel.file.sink.writer.WriteStrategy;
import org.apache.seatunnel.connectors.seatunnel.file.sink.writer.XmlWriteStrategy;
import org.apache.seatunnel.connectors.seatunnel.file.source.reader.BinaryReadStrategy;
import org.apache.seatunnel.connectors.seatunnel.file.source.reader.ExcelReadStrategy;
import org.apache.seatunnel.connectors.seatunnel.file.source.reader.JsonReadStrategy;
import org.apache.seatunnel.connectors.seatunnel.file.source.reader.OrcReadStrategy;
import org.apache.seatunnel.connectors.seatunnel.file.source.reader.ParquetReadStrategy;
import org.apache.seatunnel.connectors.seatunnel.file.source.reader.ReadStrategy;
import org.apache.seatunnel.connectors.seatunnel.file.source.reader.TextReadStrategy;
import org.apache.seatunnel.connectors.seatunnel.file.source.reader.XmlReadStrategy;

public enum FileFormat implements Serializable
{
    CSV(new String[]{"csv"}){

        @Override
        public WriteStrategy getWriteStrategy(FileSinkConfig fileSinkConfig) {
            fileSinkConfig.setFieldDelimiter(",");
            return new TextWriteStrategy(fileSinkConfig);
        }

        @Override
        public ReadStrategy getReadStrategy() {
            return new TextReadStrategy();
        }
    }
    ,
    TEXT(new String[]{"txt"}){

        @Override
        public WriteStrategy getWriteStrategy(FileSinkConfig fileSinkConfig) {
            return new TextWriteStrategy(fileSinkConfig);
        }

        @Override
        public ReadStrategy getReadStrategy() {
            return new TextReadStrategy();
        }
    }
    ,
    PARQUET(new String[]{"parquet"}){

        @Override
        public WriteStrategy getWriteStrategy(FileSinkConfig fileSinkConfig) {
            return new ParquetWriteStrategy(fileSinkConfig);
        }

        @Override
        public ReadStrategy getReadStrategy() {
            return new ParquetReadStrategy();
        }
    }
    ,
    ORC(new String[]{"orc"}){

        @Override
        public WriteStrategy getWriteStrategy(FileSinkConfig fileSinkConfig) {
            return new OrcWriteStrategy(fileSinkConfig);
        }

        @Override
        public ReadStrategy getReadStrategy() {
            return new OrcReadStrategy();
        }
    }
    ,
    JSON(new String[]{"json"}){

        @Override
        public WriteStrategy getWriteStrategy(FileSinkConfig fileSinkConfig) {
            return new JsonWriteStrategy(fileSinkConfig);
        }

        @Override
        public ReadStrategy getReadStrategy() {
            return new JsonReadStrategy();
        }
    }
    ,
    EXCEL(new String[]{"xlsx", "xls"}){

        @Override
        public WriteStrategy getWriteStrategy(FileSinkConfig fileSinkConfig) {
            return new ExcelWriteStrategy(fileSinkConfig);
        }

        @Override
        public ReadStrategy getReadStrategy() {
            return new ExcelReadStrategy();
        }
    }
    ,
    XML(new String[]{"xml"}){

        @Override
        public WriteStrategy getWriteStrategy(FileSinkConfig fileSinkConfig) {
            return new XmlWriteStrategy(fileSinkConfig);
        }

        @Override
        public ReadStrategy getReadStrategy() {
            return new XmlReadStrategy();
        }
    }
    ,
    BINARY(new String[]{""}){

        @Override
        public WriteStrategy getWriteStrategy(FileSinkConfig fileSinkConfig) {
            return new BinaryWriteStrategy(fileSinkConfig);
        }

        @Override
        public ReadStrategy getReadStrategy() {
            return new BinaryReadStrategy();
        }
    };

    private final String[] suffix;

    private FileFormat(String ... suffix) {
        this.suffix = suffix;
    }

    public String getSuffix() {
        if (this.suffix.length > 0) {
            return "." + this.suffix[0];
        }
        return "";
    }

    public String[] getAllSuffix() {
        return (String[])Arrays.stream(this.suffix).map(suffix -> "." + suffix).toArray(String[]::new);
    }

    public ReadStrategy getReadStrategy() {
        return null;
    }

    public WriteStrategy getWriteStrategy(FileSinkConfig fileSinkConfig) {
        return null;
    }
}

