/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.file.source.split;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.seatunnel.api.source.SourceSplitEnumerator;
import org.apache.seatunnel.connectors.seatunnel.file.config.BaseFileSourceConfig;
import org.apache.seatunnel.connectors.seatunnel.file.config.BaseMultipleTableFileSourceConfig;
import org.apache.seatunnel.connectors.seatunnel.file.source.split.FileSourceSplit;
import org.apache.seatunnel.connectors.seatunnel.file.source.state.FileSourceState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipleTableFileSourceSplitEnumerator
implements SourceSplitEnumerator<FileSourceSplit, FileSourceState> {
    private static final Logger log = LoggerFactory.getLogger(MultipleTableFileSourceSplitEnumerator.class);
    private final SourceSplitEnumerator.Context<FileSourceSplit> context;
    private final Set<FileSourceSplit> pendingSplit;
    private final Set<FileSourceSplit> assignedSplit;
    private final Map<String, List<String>> filePathMap;

    public MultipleTableFileSourceSplitEnumerator(SourceSplitEnumerator.Context<FileSourceSplit> context, BaseMultipleTableFileSourceConfig multipleTableFileSourceConfig) {
        this.context = context;
        this.filePathMap = multipleTableFileSourceConfig.getFileSourceConfigs().stream().collect(Collectors.toMap(localFileSourceConfig -> localFileSourceConfig.getCatalogTable().getTableId().toTablePath().toString(), BaseFileSourceConfig::getFilePaths));
        this.assignedSplit = new HashSet<FileSourceSplit>();
        this.pendingSplit = new HashSet<FileSourceSplit>();
    }

    public MultipleTableFileSourceSplitEnumerator(SourceSplitEnumerator.Context<FileSourceSplit> context, BaseMultipleTableFileSourceConfig multipleTableFileSourceConfig, FileSourceState fileSourceState) {
        this(context, multipleTableFileSourceConfig);
        this.assignedSplit.addAll(fileSourceState.getAssignedSplit());
    }

    public void addSplitsBack(List<FileSourceSplit> splits, int subtaskId) {
        if (CollectionUtils.isEmpty(splits)) {
            return;
        }
        this.pendingSplit.addAll(splits);
        this.assignSplit(subtaskId);
    }

    public int currentUnassignedSplitSize() {
        return this.pendingSplit.size();
    }

    public void handleSplitRequest(int subtaskId) {
    }

    public void registerReader(int subtaskId) {
        for (Map.Entry<String, List<String>> filePathEntry : this.filePathMap.entrySet()) {
            String tableId = filePathEntry.getKey();
            List<String> filePaths = filePathEntry.getValue();
            for (String filePath : filePaths) {
                this.pendingSplit.add(new FileSourceSplit(tableId, filePath));
            }
        }
        this.assignSplit(subtaskId);
    }

    public FileSourceState snapshotState(long checkpointId) {
        return new FileSourceState(this.assignedSplit);
    }

    public void notifyCheckpointComplete(long checkpointId) {
    }

    private void assignSplit(int taskId) {
        ArrayList<FileSourceSplit> currentTaskSplits = new ArrayList<FileSourceSplit>();
        if (this.context.currentParallelism() == 1) {
            currentTaskSplits.addAll(this.pendingSplit);
        } else {
            for (FileSourceSplit fileSourceSplit : this.pendingSplit) {
                int splitOwner = MultipleTableFileSourceSplitEnumerator.getSplitOwner(fileSourceSplit.splitId(), this.context.currentParallelism());
                if (splitOwner != taskId) continue;
                currentTaskSplits.add(fileSourceSplit);
            }
        }
        this.context.assignSplit(taskId, currentTaskSplits);
        this.assignedSplit.addAll(currentTaskSplits);
        currentTaskSplits.forEach(this.pendingSplit::remove);
        log.info("SubTask {} is assigned to [{}]", (Object)taskId, (Object)currentTaskSplits.stream().map(FileSourceSplit::splitId).collect(Collectors.joining(",")));
        this.context.signalNoMoreSplits(taskId);
    }

    private static int getSplitOwner(String tp, int numReaders) {
        return (tp.hashCode() & Integer.MAX_VALUE) % numReaders;
    }

    public void open() {
    }

    public void run() throws Exception {
    }

    public void close() throws IOException {
    }
}

