/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.file.sink.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.exception.CommonErrorCodeDeprecated;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.file.config.BaseFileSinkConfig;
import org.apache.seatunnel.connectors.seatunnel.file.config.BaseSinkConfig;
import org.apache.seatunnel.connectors.seatunnel.file.config.FileFormat;
import org.apache.seatunnel.connectors.seatunnel.file.config.PartitionConfig;
import org.apache.seatunnel.connectors.seatunnel.file.exception.FileConnectorException;
import org.apache.seatunnel.shade.com.google.common.base.Preconditions;
import org.apache.seatunnel.shade.com.typesafe.config.Config;

public class FileSinkConfig
extends BaseFileSinkConfig
implements PartitionConfig {
    private List<String> sinkColumnList;
    private List<String> partitionFieldList;
    private String partitionDirExpression;
    private boolean isPartitionFieldWriteInFile = (Boolean)BaseSinkConfig.IS_PARTITION_FIELD_WRITE_IN_FILE.defaultValue();
    private String tmpPath = (String)BaseSinkConfig.TMP_PATH.defaultValue();
    private String fileNameTimeFormat = (String)BaseSinkConfig.FILENAME_TIME_FORMAT.defaultValue();
    private boolean isEnableTransaction = (Boolean)BaseSinkConfig.IS_ENABLE_TRANSACTION.defaultValue();
    private String encoding = (String)BaseSinkConfig.ENCODING.defaultValue();
    private List<Integer> sinkColumnsIndexInRow;
    private List<Integer> partitionFieldsIndexInRow;
    private int maxRowsInMemory;
    private String sheetName;
    private String xmlRootTag = (String)BaseSinkConfig.XML_ROOT_TAG.defaultValue();
    private String xmlRowTag = (String)BaseSinkConfig.XML_ROW_TAG.defaultValue();
    private Boolean xmlUseAttrFormat;
    private Boolean parquetWriteTimestampAsInt96 = (Boolean)BaseSinkConfig.PARQUET_AVRO_WRITE_TIMESTAMP_AS_INT96.defaultValue();
    private List<String> parquetAvroWriteFixedAsInt96 = (List)BaseSinkConfig.PARQUET_AVRO_WRITE_FIXED_AS_INT96.defaultValue();

    public FileSinkConfig(@NonNull Config config, @NonNull SeaTunnelRowType seaTunnelRowTypeInfo) {
        super(config);
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (seaTunnelRowTypeInfo == null) {
            throw new NullPointerException("seaTunnelRowTypeInfo is marked non-null but is null");
        }
        Preconditions.checkArgument((!CollectionUtils.isEmpty(Arrays.asList(seaTunnelRowTypeInfo.getFieldNames())) ? 1 : 0) != 0);
        if (config.hasPath(BaseSinkConfig.SINK_COLUMNS.key()) && !CollectionUtils.isEmpty(config.getStringList(BaseSinkConfig.SINK_COLUMNS.key()))) {
            this.sinkColumnList = config.getStringList(BaseSinkConfig.SINK_COLUMNS.key());
        }
        if (CollectionUtils.isEmpty(this.sinkColumnList)) {
            this.sinkColumnList = new ArrayList<String>(Arrays.asList(seaTunnelRowTypeInfo.getFieldNames()));
        }
        this.partitionFieldList = config.hasPath(BaseSinkConfig.PARTITION_BY.key()) ? config.getStringList(BaseSinkConfig.PARTITION_BY.key()) : Collections.emptyList();
        if (config.hasPath(BaseSinkConfig.PARTITION_DIR_EXPRESSION.key()) && !StringUtils.isBlank(config.getString(BaseSinkConfig.PARTITION_DIR_EXPRESSION.key()))) {
            this.partitionDirExpression = config.getString(BaseSinkConfig.PARTITION_DIR_EXPRESSION.key());
        }
        if (config.hasPath(BaseSinkConfig.IS_PARTITION_FIELD_WRITE_IN_FILE.key())) {
            this.isPartitionFieldWriteInFile = config.getBoolean(BaseSinkConfig.IS_PARTITION_FIELD_WRITE_IN_FILE.key());
        }
        if (config.hasPath(BaseSinkConfig.TMP_PATH.key()) && !StringUtils.isBlank(config.getString(BaseSinkConfig.TMP_PATH.key()))) {
            this.tmpPath = config.getString(BaseSinkConfig.TMP_PATH.key());
        }
        if (config.hasPath(BaseSinkConfig.FILENAME_TIME_FORMAT.key()) && !StringUtils.isBlank(config.getString(BaseSinkConfig.FILENAME_TIME_FORMAT.key()))) {
            this.fileNameTimeFormat = config.getString(BaseSinkConfig.FILENAME_TIME_FORMAT.key());
        }
        if (config.hasPath(BaseSinkConfig.IS_ENABLE_TRANSACTION.key())) {
            this.isEnableTransaction = config.getBoolean(BaseSinkConfig.IS_ENABLE_TRANSACTION.key());
        }
        if (config.hasPath(BaseSinkConfig.ENCODING.key())) {
            this.encoding = config.getString(BaseSinkConfig.ENCODING.key());
        }
        if (this.isEnableTransaction && !this.fileNameExpression.contains("transactionId")) {
            throw new FileConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.ILLEGAL_ARGUMENT, "file_name_expression must contains transactionId when is_enable_transaction is true");
        }
        if (!(CollectionUtils.isEmpty(this.partitionFieldList) || !CollectionUtils.isEmpty(this.sinkColumnList) && new HashSet<String>(this.sinkColumnList).containsAll(this.partitionFieldList))) {
            throw new FileConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.ILLEGAL_ARGUMENT, "partition fields must in sink columns");
        }
        if (!(CollectionUtils.isEmpty(this.partitionFieldList) || this.isPartitionFieldWriteInFile || this.sinkColumnList.removeAll(this.partitionFieldList))) {
            throw new FileConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.ILLEGAL_ARGUMENT, "remove partition field from sink columns error");
        }
        if (CollectionUtils.isEmpty(this.sinkColumnList)) {
            throw new FileConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.ILLEGAL_ARGUMENT, "sink columns can not be empty");
        }
        HashMap<String, Integer> columnsMap = new HashMap<String, Integer>(seaTunnelRowTypeInfo.getFieldNames().length);
        String[] fieldNames = seaTunnelRowTypeInfo.getFieldNames();
        for (int i = 0; i < fieldNames.length; ++i) {
            columnsMap.put(fieldNames[i].toLowerCase(), i);
        }
        this.sinkColumnsIndexInRow = this.sinkColumnList.stream().map(column -> (Integer)columnsMap.get(column.toLowerCase())).filter(e -> e != null).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(this.partitionFieldList)) {
            this.partitionFieldsIndexInRow = this.partitionFieldList.stream().map(columnsMap::get).collect(Collectors.toList());
        }
        if (config.hasPath(BaseSinkConfig.MAX_ROWS_IN_MEMORY.key())) {
            this.maxRowsInMemory = config.getInt(BaseSinkConfig.MAX_ROWS_IN_MEMORY.key());
        }
        if (config.hasPath(BaseSinkConfig.SHEET_NAME.key())) {
            this.sheetName = config.getString(BaseSinkConfig.SHEET_NAME.key());
        }
        if (FileFormat.XML.name().equalsIgnoreCase(config.getString(BaseSinkConfig.FILE_FORMAT_TYPE.key()))) {
            if (!config.hasPath(BaseSinkConfig.XML_USE_ATTR_FORMAT.key())) {
                throw new FileConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.ILLEGAL_ARGUMENT, "User must define xml_use_attr_format when file_format_type is xml");
            }
            this.xmlUseAttrFormat = config.getBoolean(BaseSinkConfig.XML_USE_ATTR_FORMAT.key());
            if (config.hasPath(BaseSinkConfig.XML_ROOT_TAG.key())) {
                this.xmlRootTag = config.getString(BaseSinkConfig.XML_ROOT_TAG.key());
            }
            if (config.hasPath(BaseSinkConfig.XML_ROW_TAG.key())) {
                this.xmlRowTag = config.getString(BaseSinkConfig.XML_ROW_TAG.key());
            }
        }
        if (FileFormat.PARQUET.name().equalsIgnoreCase(config.getString(BaseSinkConfig.FILE_FORMAT_TYPE.key()))) {
            if (config.hasPath(BaseSinkConfig.PARQUET_AVRO_WRITE_TIMESTAMP_AS_INT96.key())) {
                this.parquetWriteTimestampAsInt96 = config.getBoolean(BaseSinkConfig.PARQUET_AVRO_WRITE_TIMESTAMP_AS_INT96.key());
            }
            if (config.hasPath(BaseSinkConfig.PARQUET_AVRO_WRITE_FIXED_AS_INT96.key())) {
                this.parquetAvroWriteFixedAsInt96 = config.getStringList(BaseSinkConfig.PARQUET_AVRO_WRITE_FIXED_AS_INT96.key());
            }
        }
    }

    public List<String> getSinkColumnList() {
        return this.sinkColumnList;
    }

    @Override
    public List<String> getPartitionFieldList() {
        return this.partitionFieldList;
    }

    public String getPartitionDirExpression() {
        return this.partitionDirExpression;
    }

    @Override
    public boolean isPartitionFieldWriteInFile() {
        return this.isPartitionFieldWriteInFile;
    }

    public String getTmpPath() {
        return this.tmpPath;
    }

    public String getFileNameTimeFormat() {
        return this.fileNameTimeFormat;
    }

    public boolean isEnableTransaction() {
        return this.isEnableTransaction;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public List<Integer> getSinkColumnsIndexInRow() {
        return this.sinkColumnsIndexInRow;
    }

    public List<Integer> getPartitionFieldsIndexInRow() {
        return this.partitionFieldsIndexInRow;
    }

    public int getMaxRowsInMemory() {
        return this.maxRowsInMemory;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public String getXmlRootTag() {
        return this.xmlRootTag;
    }

    public String getXmlRowTag() {
        return this.xmlRowTag;
    }

    public Boolean getXmlUseAttrFormat() {
        return this.xmlUseAttrFormat;
    }

    public Boolean getParquetWriteTimestampAsInt96() {
        return this.parquetWriteTimestampAsInt96;
    }

    public List<String> getParquetAvroWriteFixedAsInt96() {
        return this.parquetAvroWriteFixedAsInt96;
    }

    public void setSinkColumnList(List<String> sinkColumnList) {
        this.sinkColumnList = sinkColumnList;
    }

    public void setPartitionFieldList(List<String> partitionFieldList) {
        this.partitionFieldList = partitionFieldList;
    }

    public void setPartitionDirExpression(String partitionDirExpression) {
        this.partitionDirExpression = partitionDirExpression;
    }

    public void setPartitionFieldWriteInFile(boolean isPartitionFieldWriteInFile) {
        this.isPartitionFieldWriteInFile = isPartitionFieldWriteInFile;
    }

    public void setTmpPath(String tmpPath) {
        this.tmpPath = tmpPath;
    }

    public void setFileNameTimeFormat(String fileNameTimeFormat) {
        this.fileNameTimeFormat = fileNameTimeFormat;
    }

    public void setEnableTransaction(boolean isEnableTransaction) {
        this.isEnableTransaction = isEnableTransaction;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setSinkColumnsIndexInRow(List<Integer> sinkColumnsIndexInRow) {
        this.sinkColumnsIndexInRow = sinkColumnsIndexInRow;
    }

    public void setPartitionFieldsIndexInRow(List<Integer> partitionFieldsIndexInRow) {
        this.partitionFieldsIndexInRow = partitionFieldsIndexInRow;
    }

    public void setMaxRowsInMemory(int maxRowsInMemory) {
        this.maxRowsInMemory = maxRowsInMemory;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    public void setXmlRootTag(String xmlRootTag) {
        this.xmlRootTag = xmlRootTag;
    }

    public void setXmlRowTag(String xmlRowTag) {
        this.xmlRowTag = xmlRowTag;
    }

    public void setXmlUseAttrFormat(Boolean xmlUseAttrFormat) {
        this.xmlUseAttrFormat = xmlUseAttrFormat;
    }

    public void setParquetWriteTimestampAsInt96(Boolean parquetWriteTimestampAsInt96) {
        this.parquetWriteTimestampAsInt96 = parquetWriteTimestampAsInt96;
    }

    public void setParquetAvroWriteFixedAsInt96(List<String> parquetAvroWriteFixedAsInt96) {
        this.parquetAvroWriteFixedAsInt96 = parquetAvroWriteFixedAsInt96;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileSinkConfig)) {
            return false;
        }
        FileSinkConfig other = (FileSinkConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isPartitionFieldWriteInFile() != other.isPartitionFieldWriteInFile()) {
            return false;
        }
        if (this.isEnableTransaction() != other.isEnableTransaction()) {
            return false;
        }
        if (this.getMaxRowsInMemory() != other.getMaxRowsInMemory()) {
            return false;
        }
        Boolean this$xmlUseAttrFormat = this.getXmlUseAttrFormat();
        Boolean other$xmlUseAttrFormat = other.getXmlUseAttrFormat();
        if (this$xmlUseAttrFormat == null ? other$xmlUseAttrFormat != null : !((Object)this$xmlUseAttrFormat).equals(other$xmlUseAttrFormat)) {
            return false;
        }
        Boolean this$parquetWriteTimestampAsInt96 = this.getParquetWriteTimestampAsInt96();
        Boolean other$parquetWriteTimestampAsInt96 = other.getParquetWriteTimestampAsInt96();
        if (this$parquetWriteTimestampAsInt96 == null ? other$parquetWriteTimestampAsInt96 != null : !((Object)this$parquetWriteTimestampAsInt96).equals(other$parquetWriteTimestampAsInt96)) {
            return false;
        }
        List<String> this$sinkColumnList = this.getSinkColumnList();
        List<String> other$sinkColumnList = other.getSinkColumnList();
        if (this$sinkColumnList == null ? other$sinkColumnList != null : !((Object)this$sinkColumnList).equals(other$sinkColumnList)) {
            return false;
        }
        List<String> this$partitionFieldList = this.getPartitionFieldList();
        List<String> other$partitionFieldList = other.getPartitionFieldList();
        if (this$partitionFieldList == null ? other$partitionFieldList != null : !((Object)this$partitionFieldList).equals(other$partitionFieldList)) {
            return false;
        }
        String this$partitionDirExpression = this.getPartitionDirExpression();
        String other$partitionDirExpression = other.getPartitionDirExpression();
        if (this$partitionDirExpression == null ? other$partitionDirExpression != null : !this$partitionDirExpression.equals(other$partitionDirExpression)) {
            return false;
        }
        String this$tmpPath = this.getTmpPath();
        String other$tmpPath = other.getTmpPath();
        if (this$tmpPath == null ? other$tmpPath != null : !this$tmpPath.equals(other$tmpPath)) {
            return false;
        }
        String this$fileNameTimeFormat = this.getFileNameTimeFormat();
        String other$fileNameTimeFormat = other.getFileNameTimeFormat();
        if (this$fileNameTimeFormat == null ? other$fileNameTimeFormat != null : !this$fileNameTimeFormat.equals(other$fileNameTimeFormat)) {
            return false;
        }
        String this$encoding = this.getEncoding();
        String other$encoding = other.getEncoding();
        if (this$encoding == null ? other$encoding != null : !this$encoding.equals(other$encoding)) {
            return false;
        }
        List<Integer> this$sinkColumnsIndexInRow = this.getSinkColumnsIndexInRow();
        List<Integer> other$sinkColumnsIndexInRow = other.getSinkColumnsIndexInRow();
        if (this$sinkColumnsIndexInRow == null ? other$sinkColumnsIndexInRow != null : !((Object)this$sinkColumnsIndexInRow).equals(other$sinkColumnsIndexInRow)) {
            return false;
        }
        List<Integer> this$partitionFieldsIndexInRow = this.getPartitionFieldsIndexInRow();
        List<Integer> other$partitionFieldsIndexInRow = other.getPartitionFieldsIndexInRow();
        if (this$partitionFieldsIndexInRow == null ? other$partitionFieldsIndexInRow != null : !((Object)this$partitionFieldsIndexInRow).equals(other$partitionFieldsIndexInRow)) {
            return false;
        }
        String this$sheetName = this.getSheetName();
        String other$sheetName = other.getSheetName();
        if (this$sheetName == null ? other$sheetName != null : !this$sheetName.equals(other$sheetName)) {
            return false;
        }
        String this$xmlRootTag = this.getXmlRootTag();
        String other$xmlRootTag = other.getXmlRootTag();
        if (this$xmlRootTag == null ? other$xmlRootTag != null : !this$xmlRootTag.equals(other$xmlRootTag)) {
            return false;
        }
        String this$xmlRowTag = this.getXmlRowTag();
        String other$xmlRowTag = other.getXmlRowTag();
        if (this$xmlRowTag == null ? other$xmlRowTag != null : !this$xmlRowTag.equals(other$xmlRowTag)) {
            return false;
        }
        List<String> this$parquetAvroWriteFixedAsInt96 = this.getParquetAvroWriteFixedAsInt96();
        List<String> other$parquetAvroWriteFixedAsInt96 = other.getParquetAvroWriteFixedAsInt96();
        return !(this$parquetAvroWriteFixedAsInt96 == null ? other$parquetAvroWriteFixedAsInt96 != null : !((Object)this$parquetAvroWriteFixedAsInt96).equals(other$parquetAvroWriteFixedAsInt96));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof FileSinkConfig;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isPartitionFieldWriteInFile() ? 79 : 97);
        result = result * 59 + (this.isEnableTransaction() ? 79 : 97);
        result = result * 59 + this.getMaxRowsInMemory();
        Boolean $xmlUseAttrFormat = this.getXmlUseAttrFormat();
        result = result * 59 + ($xmlUseAttrFormat == null ? 43 : ((Object)$xmlUseAttrFormat).hashCode());
        Boolean $parquetWriteTimestampAsInt96 = this.getParquetWriteTimestampAsInt96();
        result = result * 59 + ($parquetWriteTimestampAsInt96 == null ? 43 : ((Object)$parquetWriteTimestampAsInt96).hashCode());
        List<String> $sinkColumnList = this.getSinkColumnList();
        result = result * 59 + ($sinkColumnList == null ? 43 : ((Object)$sinkColumnList).hashCode());
        List<String> $partitionFieldList = this.getPartitionFieldList();
        result = result * 59 + ($partitionFieldList == null ? 43 : ((Object)$partitionFieldList).hashCode());
        String $partitionDirExpression = this.getPartitionDirExpression();
        result = result * 59 + ($partitionDirExpression == null ? 43 : $partitionDirExpression.hashCode());
        String $tmpPath = this.getTmpPath();
        result = result * 59 + ($tmpPath == null ? 43 : $tmpPath.hashCode());
        String $fileNameTimeFormat = this.getFileNameTimeFormat();
        result = result * 59 + ($fileNameTimeFormat == null ? 43 : $fileNameTimeFormat.hashCode());
        String $encoding = this.getEncoding();
        result = result * 59 + ($encoding == null ? 43 : $encoding.hashCode());
        List<Integer> $sinkColumnsIndexInRow = this.getSinkColumnsIndexInRow();
        result = result * 59 + ($sinkColumnsIndexInRow == null ? 43 : ((Object)$sinkColumnsIndexInRow).hashCode());
        List<Integer> $partitionFieldsIndexInRow = this.getPartitionFieldsIndexInRow();
        result = result * 59 + ($partitionFieldsIndexInRow == null ? 43 : ((Object)$partitionFieldsIndexInRow).hashCode());
        String $sheetName = this.getSheetName();
        result = result * 59 + ($sheetName == null ? 43 : $sheetName.hashCode());
        String $xmlRootTag = this.getXmlRootTag();
        result = result * 59 + ($xmlRootTag == null ? 43 : $xmlRootTag.hashCode());
        String $xmlRowTag = this.getXmlRowTag();
        result = result * 59 + ($xmlRowTag == null ? 43 : $xmlRowTag.hashCode());
        List<String> $parquetAvroWriteFixedAsInt96 = this.getParquetAvroWriteFixedAsInt96();
        result = result * 59 + ($parquetAvroWriteFixedAsInt96 == null ? 43 : ((Object)$parquetAvroWriteFixedAsInt96).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "FileSinkConfig(sinkColumnList=" + this.getSinkColumnList() + ", partitionFieldList=" + this.getPartitionFieldList() + ", partitionDirExpression=" + this.getPartitionDirExpression() + ", isPartitionFieldWriteInFile=" + this.isPartitionFieldWriteInFile() + ", tmpPath=" + this.getTmpPath() + ", fileNameTimeFormat=" + this.getFileNameTimeFormat() + ", isEnableTransaction=" + this.isEnableTransaction() + ", encoding=" + this.getEncoding() + ", sinkColumnsIndexInRow=" + this.getSinkColumnsIndexInRow() + ", partitionFieldsIndexInRow=" + this.getPartitionFieldsIndexInRow() + ", maxRowsInMemory=" + this.getMaxRowsInMemory() + ", sheetName=" + this.getSheetName() + ", xmlRootTag=" + this.getXmlRootTag() + ", xmlRowTag=" + this.getXmlRowTag() + ", xmlUseAttrFormat=" + this.getXmlUseAttrFormat() + ", parquetWriteTimestampAsInt96=" + this.getParquetWriteTimestampAsInt96() + ", parquetAvroWriteFixedAsInt96=" + this.getParquetAvroWriteFixedAsInt96() + ")";
    }
}

