/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.file.config;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.CatalogTableUtil;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.PhysicalColumn;
import org.apache.seatunnel.api.table.catalog.TableIdentifier;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.api.table.catalog.schema.TableSchemaOptions;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.file.config.BaseSourceConfigOptions;
import org.apache.seatunnel.connectors.seatunnel.file.config.FileFormat;
import org.apache.seatunnel.connectors.seatunnel.file.config.HadoopConf;
import org.apache.seatunnel.connectors.seatunnel.file.exception.FileConnectorErrorCode;
import org.apache.seatunnel.connectors.seatunnel.file.exception.FileConnectorException;
import org.apache.seatunnel.connectors.seatunnel.file.source.reader.ReadStrategy;
import org.apache.seatunnel.connectors.seatunnel.file.source.reader.ReadStrategyFactory;

public abstract class BaseFileSourceConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final CatalogTable catalogTable;
    private final FileFormat fileFormat;
    private final ReadStrategy readStrategy;
    private final List<String> filePaths;
    private final ReadonlyConfig baseFileSourceConfig;

    public abstract HadoopConf getHadoopConfig();

    public abstract String getPluginName();

    public BaseFileSourceConfig(ReadonlyConfig readonlyConfig) {
        this.baseFileSourceConfig = readonlyConfig;
        this.fileFormat = (FileFormat)readonlyConfig.get(BaseSourceConfigOptions.FILE_FORMAT_TYPE);
        this.readStrategy = ReadStrategyFactory.of(readonlyConfig, this.getHadoopConfig());
        this.filePaths = this.parseFilePaths(readonlyConfig);
        this.catalogTable = this.parseCatalogTable(readonlyConfig);
    }

    private List<String> parseFilePaths(ReadonlyConfig readonlyConfig) {
        String rootPath = null;
        try {
            rootPath = (String)readonlyConfig.get(BaseSourceConfigOptions.FILE_PATH);
            return this.readStrategy.getFileNamesByPath(rootPath);
        }
        catch (Exception ex) {
            String errorMsg = String.format("Get file list from this path [%s] failed", rootPath);
            throw new FileConnectorException(FileConnectorErrorCode.FILE_LIST_GET_FAILED, errorMsg, ex);
        }
    }

    private CatalogTable parseCatalogTable(ReadonlyConfig readonlyConfig) {
        boolean configSchema = readonlyConfig.getOptional(TableSchemaOptions.SCHEMA).isPresent();
        CatalogTable catalogTable = configSchema ? CatalogTableUtil.buildWithConfig((String)this.getPluginName(), (ReadonlyConfig)readonlyConfig) : CatalogTableUtil.buildSimpleTextTable();
        if (CollectionUtils.isEmpty(this.filePaths)) {
            return catalogTable;
        }
        switch (this.fileFormat) {
            case CSV: 
            case TEXT: 
            case JSON: 
            case EXCEL: 
            case XML: {
                this.readStrategy.setCatalogTable(catalogTable);
                return this.newCatalogTable(catalogTable, this.readStrategy.getActualSeaTunnelRowTypeInfo());
            }
            case ORC: 
            case PARQUET: 
            case BINARY: {
                return this.newCatalogTable(catalogTable, this.readStrategy.getSeaTunnelRowTypeInfoWithUserConfigRowType(this.filePaths.get(0), configSchema ? catalogTable.getSeaTunnelRowType() : null));
            }
        }
        throw new FileConnectorException((SeaTunnelErrorCode)FileConnectorErrorCode.FORMAT_NOT_SUPPORT, "SeaTunnel does not supported this file format: [" + this.fileFormat + "]");
    }

    private CatalogTable newCatalogTable(CatalogTable catalogTable, SeaTunnelRowType seaTunnelRowType) {
        TableSchema tableSchema = catalogTable.getTableSchema();
        Map columnMap = tableSchema.getColumns().stream().collect(Collectors.toMap(Column::getName, Function.identity()));
        String[] fieldNames = seaTunnelRowType.getFieldNames();
        SeaTunnelDataType[] fieldTypes = seaTunnelRowType.getFieldTypes();
        ArrayList<Object> finalColumns = new ArrayList<Object>();
        for (int i = 0; i < fieldNames.length; ++i) {
            Column column = (Column)columnMap.get(fieldNames[i]);
            if (column != null) {
                finalColumns.add(column);
                continue;
            }
            finalColumns.add(PhysicalColumn.of((String)fieldNames[i], (SeaTunnelDataType)fieldTypes[i], (Integer)0, (boolean)false, null, null));
        }
        TableSchema finalSchema = TableSchema.builder().columns(finalColumns).primaryKey(tableSchema.getPrimaryKey()).constraintKey(tableSchema.getConstraintKeys()).build();
        return CatalogTable.of((TableIdentifier)catalogTable.getTableId(), (TableSchema)finalSchema, (Map)catalogTable.getOptions(), (List)catalogTable.getPartitionKeys(), (String)catalogTable.getComment(), (String)catalogTable.getCatalogName());
    }

    public CatalogTable getCatalogTable() {
        return this.catalogTable;
    }

    public FileFormat getFileFormat() {
        return this.fileFormat;
    }

    public ReadStrategy getReadStrategy() {
        return this.readStrategy;
    }

    public List<String> getFilePaths() {
        return this.filePaths;
    }

    public ReadonlyConfig getBaseFileSourceConfig() {
        return this.baseFileSourceConfig;
    }
}

