/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.elasticsearch.source;

import com.google.auto.service.AutoService;
import java.io.Serializable;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.source.SeaTunnelSource;
import org.apache.seatunnel.api.source.SourceSplit;
import org.apache.seatunnel.api.table.connector.TableSource;
import org.apache.seatunnel.api.table.factory.Factory;
import org.apache.seatunnel.api.table.factory.TableSourceFactory;
import org.apache.seatunnel.api.table.factory.TableSourceFactoryContext;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.config.EsClusterConnectionConfig;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.config.SourceConfig;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.source.ElasticsearchSource;

@AutoService(value={Factory.class})
public class ElasticsearchSourceFactory
implements TableSourceFactory {
    public String factoryIdentifier() {
        return "Elasticsearch";
    }

    public OptionRule optionRule() {
        return OptionRule.builder().required(new Option[]{EsClusterConnectionConfig.HOSTS}).optional(new Option[]{SourceConfig.INDEX, SourceConfig.INDEX_LIST, EsClusterConnectionConfig.USERNAME, EsClusterConnectionConfig.PASSWORD, SourceConfig.SCROLL_TIME, SourceConfig.SCROLL_SIZE, SourceConfig.QUERY, EsClusterConnectionConfig.TLS_VERIFY_CERTIFICATE, EsClusterConnectionConfig.TLS_VERIFY_HOSTNAME, EsClusterConnectionConfig.TLS_KEY_STORE_PATH, EsClusterConnectionConfig.TLS_KEY_STORE_PASSWORD, EsClusterConnectionConfig.TLS_TRUST_STORE_PATH, EsClusterConnectionConfig.TLS_TRUST_STORE_PASSWORD}).build();
    }

    public <T, SplitT extends SourceSplit, StateT extends Serializable> TableSource<T, SplitT, StateT> createSource(TableSourceFactoryContext context) {
        return () -> new ElasticsearchSource(context.getOptions());
    }

    public Class<? extends SeaTunnelSource> getSourceClass() {
        return ElasticsearchSource.class;
    }
}

