/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.elasticsearch.sink;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.sink.DataSaveMode;
import org.apache.seatunnel.api.sink.DefaultSaveModeHandler;
import org.apache.seatunnel.api.sink.SaveModeHandler;
import org.apache.seatunnel.api.sink.SchemaSaveMode;
import org.apache.seatunnel.api.sink.SeaTunnelSink;
import org.apache.seatunnel.api.sink.SinkWriter;
import org.apache.seatunnel.api.sink.SupportMultiTableSink;
import org.apache.seatunnel.api.sink.SupportSaveMode;
import org.apache.seatunnel.api.sink.SupportSchemaEvolutionSink;
import org.apache.seatunnel.api.table.catalog.Catalog;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.factory.CatalogFactory;
import org.apache.seatunnel.api.table.factory.FactoryUtil;
import org.apache.seatunnel.api.table.schema.SchemaChangeType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.config.SinkConfig;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.sink.ElasticsearchSinkWriter;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.state.ElasticsearchAggregatedCommitInfo;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.state.ElasticsearchCommitInfo;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.state.ElasticsearchSinkState;

public class ElasticsearchSink
implements SeaTunnelSink<SeaTunnelRow, ElasticsearchSinkState, ElasticsearchCommitInfo, ElasticsearchAggregatedCommitInfo>,
SupportMultiTableSink,
SupportSaveMode,
SupportSchemaEvolutionSink {
    private ReadonlyConfig config;
    private CatalogTable catalogTable;
    private final int maxBatchSize;
    private final int maxRetryCount;

    public ElasticsearchSink(ReadonlyConfig config, CatalogTable catalogTable) {
        this.config = config;
        this.catalogTable = catalogTable;
        this.maxBatchSize = (Integer)config.get(SinkConfig.MAX_BATCH_SIZE);
        this.maxRetryCount = (Integer)config.get(SinkConfig.MAX_RETRY_COUNT);
    }

    public String getPluginName() {
        return "Elasticsearch";
    }

    public ElasticsearchSinkWriter createWriter(SinkWriter.Context context) {
        return new ElasticsearchSinkWriter(context, this.catalogTable, this.config, this.maxBatchSize, this.maxRetryCount);
    }

    public Optional<SaveModeHandler> getSaveModeHandler() {
        CatalogFactory catalogFactory = (CatalogFactory)FactoryUtil.discoverFactory((ClassLoader)Thread.currentThread().getContextClassLoader(), CatalogFactory.class, (String)this.getPluginName());
        if (catalogFactory == null) {
            return Optional.empty();
        }
        Catalog catalog = catalogFactory.createCatalog(catalogFactory.factoryIdentifier(), this.config);
        SchemaSaveMode schemaSaveMode = (SchemaSaveMode)this.config.get(SinkConfig.SCHEMA_SAVE_MODE);
        DataSaveMode dataSaveMode = (DataSaveMode)this.config.get(SinkConfig.DATA_SAVE_MODE);
        TablePath tablePath = TablePath.of((String)"", (String)this.catalogTable.getTableId().getTableName());
        return Optional.of(new DefaultSaveModeHandler(schemaSaveMode, dataSaveMode, catalog, tablePath, null, null));
    }

    public Optional<CatalogTable> getWriteCatalogTable() {
        return Optional.ofNullable(this.catalogTable);
    }

    public List<SchemaChangeType> supports() {
        return Arrays.asList(SchemaChangeType.ADD_COLUMN);
    }
}

